/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.remote;

import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNRemote;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.AuthnCallback;
import org.apache.subversion.javahl.callback.ConfigEvent;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.TunnelAgent;
import org.apache.subversion.javahl.callback.UserPasswordCallback;

public class RemoteFactory {
    private String configDirectory;
    private String username;
    private String password;
    private AuthnCallback prompt;
    private UserPasswordCallback deprecatedPrompt;
    private ProgressCallback progress;
    private ConfigEvent configHandler;
    private TunnelAgent tunnelAgent;

    public RemoteFactory() {
    }

    public RemoteFactory(String configDirectory, String username, String password, AuthnCallback prompt, ProgressCallback progress, ConfigEvent configHandler, TunnelAgent tunnelAgent) {
        this.setConfigDirectory(configDirectory);
        this.setUsername(username);
        this.setPassword(password);
        this.setPrompt(prompt);
        this.setProgressCallback(progress);
        this.setConfigEventHandler(configHandler);
        this.setTunnelAgent(tunnelAgent);
    }

    public RemoteFactory(String configDirectory, String username, String password, UserPasswordCallback prompt, ProgressCallback progress, ConfigEvent configHandler, TunnelAgent tunnelAgent) {
        this.setConfigDirectory(configDirectory);
        this.setUsername(username);
        this.setPassword(password);
        this.setPrompt(prompt);
        this.setProgressCallback(progress);
        this.setConfigEventHandler(configHandler);
        this.setTunnelAgent(tunnelAgent);
    }

    public void setUsername(String username) {
        if (username != null && username.isEmpty()) {
            throw new IllegalArgumentException("username must not be empty");
        }
        this.username = username;
    }

    public void setPassword(String password) {
        if (password != null && password.isEmpty()) {
            throw new IllegalArgumentException("password must not be empty");
        }
        this.password = password;
    }

    public void setPrompt(AuthnCallback prompt) {
        assert (this.deprecatedPrompt == null);
        this.prompt = prompt;
    }

    public void setPrompt(UserPasswordCallback prompt) {
        assert (this.prompt == null);
        this.deprecatedPrompt = prompt;
    }

    public void setProgressCallback(ProgressCallback progress) {
        this.progress = progress;
    }

    public void setConfigDirectory(String configDirectory) {
        this.configDirectory = configDirectory;
    }

    public void setConfigEventHandler(ConfigEvent configHandler) {
        this.configHandler = configHandler;
    }

    public void setTunnelAgent(TunnelAgent tunnelAgent) {
        this.tunnelAgent = tunnelAgent;
    }

    public ISVNRemote openRemoteSession(String url) throws ClientException, SubversionException {
        return RemoteFactory.open(1, url, null, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    public ISVNRemote openRemoteSession(String url, int retryAttempts) throws ClientException, SubversionException {
        if (retryAttempts <= 0) {
            throw new IllegalArgumentException("retryAttempts must be positive");
        }
        return RemoteFactory.open(retryAttempts, url, null, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    public ISVNRemote openRemoteSession(String url, String reposUUID) throws ClientException, SubversionException {
        if (reposUUID == null) {
            throw new IllegalArgumentException("reposUUID may not be null");
        }
        return RemoteFactory.open(1, url, reposUUID, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    public ISVNRemote openRemoteSession(String url, String reposUUID, int retryAttempts) throws ClientException, SubversionException {
        if (reposUUID == null) {
            throw new IllegalArgumentException("reposUUID may not be null");
        }
        if (retryAttempts <= 0) {
            throw new IllegalArgumentException("retryAttempts must be positive");
        }
        return RemoteFactory.open(retryAttempts, url, reposUUID, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    private static native ISVNRemote open(int var0, String var1, String var2, String var3, String var4, String var5, AuthnCallback var6, UserPasswordCallback var7, ProgressCallback var8, ConfigEvent var9, TunnelAgent var10) throws ClientException, SubversionException;

    static {
        NativeResources.loadNativeLibrary();
    }
}

