/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetObjectContentRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String sha;
    private String filePath;
    private String opcRequestId;

    @ConstructorProperties(value={"repositoryId", "sha", "filePath", "opcRequestId"})
    GetObjectContentRequest(String repositoryId, String sha, String filePath, String opcRequestId) {
        this.repositoryId = repositoryId;
        this.sha = sha;
        this.filePath = filePath;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).sha(this.sha).filePath(this.filePath).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetObjectContentRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", sha=" + this.getSha() + ", filePath=" + this.getFilePath() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetObjectContentRequest)) {
            return false;
        }
        GetObjectContentRequest other = (GetObjectContentRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        String this$sha = this.getSha();
        String other$sha = other.getSha();
        if (this$sha == null ? other$sha != null : !this$sha.equals(other$sha)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetObjectContentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        String $sha = this.getSha();
        result = result * 59 + ($sha == null ? 43 : $sha.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getSha() {
        return this.sha;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetObjectContentRequest, Void> {
        private String repositoryId;
        private String sha;
        private String filePath;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetObjectContentRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.sha(o.getSha());
            this.filePath(o.getFilePath());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetObjectContentRequest build() {
            GetObjectContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder sha(String sha) {
            this.sha = sha;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetObjectContentRequest buildWithoutInvocationCallback() {
            return new GetObjectContentRequest(this.repositoryId, this.sha, this.filePath, this.opcRequestId);
        }

        public String toString() {
            return "GetObjectContentRequest.Builder(repositoryId=" + this.repositoryId + ", sha=" + this.sha + ", filePath=" + this.filePath + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

