/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.spi.ProjectDependenciesImplementation;

public class ProjectDependencies {
    public static ArtifactSpec getProjectArtifact(Project target) {
        ProjectDependenciesImplementation pds = (ProjectDependenciesImplementation)target.getLookup().lookup(ProjectDependenciesImplementation.class);
        if (pds == null) {
            return null;
        }
        return pds.getProjectArtifact();
    }

    public static DependencyResult findDependencies(Project target, DependencyQuery query) throws ProjectOperationException {
        ProjectDependenciesImplementation pds = (ProjectDependenciesImplementation)target.getLookup().lookup(ProjectDependenciesImplementation.class);
        if (pds == null) {
            return null;
        }
        return pds.findDependencies(query);
    }

    public static DependencyQueryBuilder newBuilder() {
        return new DependencyQueryBuilder();
    }

    public static DependencyQuery newQuery(Scope ... scopes) {
        return ProjectDependencies.newBuilder().scope(scopes).build();
    }

    public static final class DependencyQuery {
        private final Set<Scope> scopes;
        private final Dependency.Filter filter;
        private final boolean offline;
        private final boolean flushChaches;

        private DependencyQuery(Set<Scope> scopes, Dependency.Filter filter, boolean offline, boolean flushCaches) {
            this.scopes = scopes == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<Scope>(scopes));
            this.filter = filter;
            this.offline = offline;
            this.flushChaches = flushCaches;
        }

        public Set<Scope> getScopes() {
            return this.scopes;
        }

        public Dependency.Filter getFilter() {
            return this.filter;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public boolean isFlushChaches() {
            return this.flushChaches;
        }
    }

    public static final class DependencyQueryBuilder {
        private Set<Scope> scopes;
        private Dependency.Filter filter;
        private boolean offline = true;
        private boolean flush;

        private DependencyQueryBuilder() {
        }

        public DependencyQuery build() {
            if (this.scopes == null) {
                this.scope(Scopes.COMPILE);
            }
            return new DependencyQuery(this.scopes, this.filter, this.offline, this.flush);
        }

        public DependencyQueryBuilder filter(Dependency.Filter f) {
            this.filter = f;
            return this;
        }

        public DependencyQueryBuilder scope(Scope ... s) {
            if (s == null || s.length == 0) {
                return this;
            }
            if (this.scopes == null) {
                this.scopes = new LinkedHashSet<Scope>();
            }
            this.scopes.addAll(Arrays.asList(s));
            return this;
        }

        public DependencyQueryBuilder online() {
            this.offline = false;
            return this;
        }

        public DependencyQueryBuilder offline() {
            this.offline = true;
            return this;
        }

        public DependencyQueryBuilder withoutCaches() {
            this.flush = true;
            return this;
        }
    }
}

