/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.AbstractClassPathProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.modules.java.api.common.classpath.ModuleClassPaths;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Parameters;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
extends AbstractClassPathProvider {
    private static final String buildGeneratedDir = "build.generated.sources.dir";
    private static final String[] processorTestClasspath = new String[]{"javac.test.processorpath"};
    private static final String[] processorTestModulepath = new String[]{"javac.test.processormodulepath"};
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final String buildClassesDir;
    private final String distJar;
    private final String buildTestClassesDir;
    private final String[] javacClasspath;
    private final String[] processorClasspath;
    private final String[] javacTestClasspath;
    private final String[] runClasspath;
    private final String[] runTestClasspath;
    private final String[] endorsedClasspath;
    private final String[] modulePath;
    private final String[] testModulePath;
    private final String[] processorModulePath;
    private final String[] moduleExecutePath;
    private final String[] testModuleExecutePath;
    private final Union2<String, String[]> platform;
    private final String javacSource;
    private final AtomicReference<Project> project;
    private final ClassPath[] cache = new ClassPath[31];
    private final Map<String, FileObject> dirCache = new ConcurrentHashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this(helper, evaluator, sourceRoots, testSourceRoots, "build.classes.dir", "dist.jar", "build.test.classes.dir", Builder.DEFAULT_JAVAC_CLASS_PATH, Builder.DEFAULT_JAVAC_TEST_CLASS_PATH, Builder.DEFAULT_RUN_CLASS_PATH, Builder.DEFAULT_RUN_TEST_CLASS_PATH);
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, javacTestClasspath, runClasspath, runTestClasspath, Builder.DEFAULT_ENDORSED_CLASSPATH);
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath, String[] endorsedClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, Builder.DEFAULT_PROCESSOR_PATH, javacTestClasspath, runClasspath, runTestClasspath, endorsedClasspath);
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] processorPath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath, String[] endorsedClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, processorPath, javacTestClasspath, runClasspath, runTestClasspath, endorsedClasspath, Builder.DEFAULT_MODULE_PATH, Builder.DEFAULT_TEST_MODULE_PATH, Builder.DEFAULT_PROCESSOR_MODULE_PATH, Builder.DEFAULT_MODULE_EXECUTE_PATH, Builder.DEFAULT_TEST_MODULE_EXECUTE_PATH, (Union2<String, String[]>)Union2.createFirst((Object)"j2se"), "javac.source", null);
    }

    private ClassPathProviderImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots, @NonNull String buildClassesDir, @NonNull String distJar, @NonNull String buildTestClassesDir, @NonNull String[] javacClasspath, @NonNull String[] processorPath, @NonNull String[] javacTestClasspath, @NonNull String[] runClasspath, @NonNull String[] runTestClasspath, @NonNull String[] endorsedClasspath, @NonNull String[] modulePath, @NonNull String[] testModulePath, @NonNull String[] processorModulePath, @NonNull String[] moduleExecutePath, @NonNull String[] testModuleExecutePath, @NonNull Union2<String, String[]> platform, @NonNull String javacSource, @NullAllowed Project project) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
        Parameters.notNull((CharSequence)"testSourceRoots", (Object)testSourceRoots);
        Parameters.notNull((CharSequence)"buildClassesDir", (Object)buildClassesDir);
        Parameters.notNull((CharSequence)"distJar", (Object)distJar);
        Parameters.notNull((CharSequence)"buildTestClassesDir", (Object)buildTestClassesDir);
        Parameters.notNull((CharSequence)"javacClasspath", (Object)javacClasspath);
        Parameters.notNull((CharSequence)"processorPath", (Object)processorPath);
        Parameters.notNull((CharSequence)"javacTestClasspath", (Object)javacTestClasspath);
        Parameters.notNull((CharSequence)"runClasspath", (Object)runClasspath);
        Parameters.notNull((CharSequence)"runTestClasspath", (Object)runTestClasspath);
        Parameters.notNull((CharSequence)"endorsedClasspath", (Object)endorsedClasspath);
        Parameters.notNull((CharSequence)"modulePath", (Object)modulePath);
        Parameters.notNull((CharSequence)"testModulePath", (Object)testModulePath);
        Parameters.notNull((CharSequence)"processorModulePath", (Object)processorModulePath);
        Parameters.notNull((CharSequence)"moduleExecutePath", (Object)moduleExecutePath);
        Parameters.notNull((CharSequence)"testModuleExecutePath", (Object)testModuleExecutePath);
        Parameters.notNull((CharSequence)"platform", platform);
        Parameters.notNull((CharSequence)"javacSource", (Object)javacSource);
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        this.buildClassesDir = buildClassesDir;
        this.distJar = distJar;
        this.buildTestClassesDir = buildTestClassesDir;
        this.javacClasspath = javacClasspath;
        this.processorClasspath = processorPath;
        this.javacTestClasspath = javacTestClasspath;
        this.runClasspath = runClasspath;
        this.runTestClasspath = runTestClasspath;
        this.endorsedClasspath = endorsedClasspath;
        this.modulePath = modulePath;
        this.testModulePath = testModulePath;
        this.processorModulePath = processorModulePath;
        this.moduleExecutePath = moduleExecutePath;
        this.testModuleExecutePath = testModuleExecutePath;
        this.platform = platform;
        this.javacSource = javacSource;
        this.project = new AtomicReference<Project>(project);
    }

    private FileObject getDir(@NonNull String propname) {
        String prop;
        FileObject fo = this.dirCache.get(propname);
        if (!(fo != null && fo.isValid() || (prop = this.evaluator.getProperty(propname)) == null || (fo = this.helper.resolveFileObject(prop)) == null)) {
            this.dirCache.put(propname, fo);
        }
        return fo;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(this.buildClassesDir);
    }

    private FileObject getBuildGeneratedDir() {
        return this.getDir(buildGeneratedDir);
    }

    private FileObject getDistJar() {
        return this.getDir(this.distJar);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(this.buildTestClassesDir);
    }

    private FileObject getAnnotationProcessingSourceOutputDir() {
        return this.getDir("annotation.processing.source.output");
    }

    private int getType(FileObject file) {
        FileObject root;
        int i;
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 0;
        }
        srcPath = this.getTestSrcDir();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 1;
        }
        FileObject dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 4;
        }
        dir = this.getBuildTestClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        dir = this.getBuildGeneratedDir();
        if (dir != null && FileUtil.isParentOf((FileObject)dir, (FileObject)file)) {
            dir = this.getAnnotationProcessingSourceOutputDir();
            if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getCompileTimeClasspath(type);
    }

    private ClassPath getCompileTimeClasspath(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(2 + type, () -> ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> this.getJava8ClassPath(type), () -> ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createModuleInfoBasedPath(this.getModuleCompilePath(type), this.getSourcepath(type), this.getModuleBootPath(), this.getModuleCompilePath(type), this.getJava8ClassPath(type), null)))));
            }
        }
        return null;
    }

    private ClassPath getProcessorClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getProcessorClasspath(type);
    }

    private ClassPath getProcessorClasspath(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(10 + type, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])(type == 0 ? this.processorClasspath : processorTestClasspath))));
            }
        }
        return null;
    }

    private ClassPath getRunTimeClasspath(FileObject file) {
        int type = this.getType(file);
        if (type < 0 || type > 4) {
            return null;
        }
        return this.getRunTimeClasspath(type);
    }

    private ClassPath getRunTimeClasspath(int type) {
        int index;
        switch (type) {
            case 0: 
            case 2: {
                index = 4;
                break;
            }
            case 1: 
            case 3: {
                index = 5;
                break;
            }
            case 4: {
                index = 6;
                break;
            }
            default: {
                return null;
            }
        }
        return this.computeIfAbsent(index, () -> ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> this.getJava8RunTimeClassPath(type), () -> ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createModuleInfoBasedPath(this.getModuleExecutePath(type), this.getSourcepath(index != 5 ? 0 : 1), this.getModuleBootPath(), this.getModuleExecutePath(type), this.getJava8RunTimeClassPath(type), this.getFilter(type))))));
    }

    private ClassPath getEndorsedClasspath() {
        return this.computeIfAbsent(9, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.endorsedClasspath)));
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    @CheckForNull
    private ClassPath getSourcepath(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(type, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation(type == 0 ? this.sourceRoots : this.testSourceRoots, this.helper, this.evaluator)));
            }
        }
        return null;
    }

    @CheckForNull
    private ClassPath getBootClassPath(@NonNull FileObject artefact) {
        int type = this.getType(artefact);
        switch (type) {
            case -1: {
                Project prj = this.getProject();
                if (prj != null && prj.equals(FileOwnerQuery.getOwner((FileObject)artefact))) {
                    type = 0;
                    break;
                }
                return null;
            }
            case 0: 
            case 2: 
            case 4: {
                type = 0;
                break;
            }
            case 1: 
            case 3: {
                type = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
        return this.getBootClassPath(type);
    }

    private ClassPath getBootClassPath(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(7 + type, () -> {
                    if (this.platform.hasFirst()) {
                        return ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> this.getJava8BootClassPath(), () -> ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createModuleInfoBasedPath(this.getModuleBootPath(), this.getSourcepath(type), this.getModuleBootPath(), this.getModuleCompilePath(type), null, null))));
                    }
                    assert (this.platform.hasSecond());
                    if (type == 0) {
                        return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.getEndorsedClasspath(), ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])((String[])this.platform.second())))});
                    }
                    return this.getBootClassPath(0);
                });
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    @NonNull
    private ClassPath getModuleBootPath() {
        return this.computeIfAbsent(12, () -> {
            if (this.platform.hasFirst()) {
                return ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> ClassPath.EMPTY, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createPlatformModulePath(this.evaluator, (String)this.platform.first()))));
            }
            return ClassPath.EMPTY;
        });
    }

    @CheckForNull
    private ClassPath getModuleCompilePath(@NonNull FileObject fo) {
        int type = this.getType(fo);
        if (type < 0 || type > 1) {
            return null;
        }
        return this.getModuleCompilePath(type);
    }

    @NonNull
    private ClassPath getModuleCompilePath(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(13 + type, () -> ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> ClassPath.EMPTY, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ModuleClassPaths.createPropertyBasedModulePath(this.projectDirectory, this.evaluator, null, type == 0 ? this.modulePath : this.testModulePath)))));
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    @CheckForNull
    private ClassPath getModuleLegacyClassPath(@NonNull FileObject fo) {
        int type = this.getType(fo);
        if (type < 0 || type > 1) {
            return null;
        }
        return this.getModuleLegacyClassPath(type);
    }

    @NonNull
    private ClassPath getModuleLegacyClassPath(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(15 + type, () -> ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> ClassPath.EMPTY, () -> this.getJava8ClassPath(type))));
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    private ClassPath getProcessorModulePath(FileObject file) {
        int type = this.getType(file);
        return this.getProcessorModulePath(type);
    }

    private ClassPath getProcessorModulePath(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(29 + type, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])(type == 0 ? this.processorModulePath : processorTestModulepath))));
            }
        }
        return null;
    }

    @CheckForNull
    private ClassPath getModuleExecutePath(@NonNull FileObject fo) {
        int type = this.getType(fo);
        if (type < 0 || type > 4) {
            return null;
        }
        return this.getModuleExecutePath(type);
    }

    @NonNull
    private ClassPath getModuleExecutePath(int type) {
        Supplier<ClassPathImplementation> provider;
        int index;
        switch (type) {
            case 0: 
            case 2: {
                index = 17;
                break;
            }
            case 1: 
            case 3: {
                index = 18;
                break;
            }
            case 4: {
                index = 19;
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
        switch (index) {
            case 17: {
                provider = () -> {
                    String[] props = new String[this.moduleExecutePath.length + 1];
                    props[0] = this.buildClassesDir;
                    System.arraycopy(this.moduleExecutePath, 0, props, 1, this.moduleExecutePath.length);
                    return ModuleClassPaths.createPropertyBasedModulePath(this.projectDirectory, this.evaluator, null, props);
                };
                break;
            }
            case 18: {
                provider = () -> {
                    String[] props = new String[this.testModuleExecutePath.length + 1];
                    props[0] = this.buildTestClassesDir;
                    System.arraycopy(this.testModuleExecutePath, 0, props, 1, this.testModuleExecutePath.length);
                    return ModuleClassPaths.createPropertyBasedModulePath(this.projectDirectory, this.evaluator, null, props);
                };
                break;
            }
            case 19: {
                provider = () -> {
                    String[] props = new String[this.moduleExecutePath.length + 1];
                    props[0] = this.distJar;
                    System.arraycopy(this.moduleExecutePath, 0, props, 1, this.moduleExecutePath.length);
                    return ModuleClassPaths.createPropertyBasedModulePath(this.projectDirectory, this.evaluator, new Filter(null, this.buildClassesDir), props);
                };
                break;
            }
            default: {
                throw new IllegalStateException(Integer.toString(index));
            }
        }
        return this.computeIfAbsent(index, () -> ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> ClassPath.EMPTY, () -> ClassPathProviderImpl.lambda$getModuleExecutePath$26((Supplier)provider))));
    }

    @CheckForNull
    private ClassPath getModuleLegacyExecuteClassPath(@NonNull FileObject fo) {
        int type = this.getType(fo);
        if (type < 0 || type > 4) {
            return null;
        }
        return this.getModuleLegacyExecuteClassPath(type);
    }

    @NonNull
    private ClassPath getModuleLegacyExecuteClassPath(int type) {
        int index;
        switch (type) {
            case 0: 
            case 2: {
                index = 20;
                break;
            }
            case 1: 
            case 3: {
                index = 21;
                break;
            }
            case 4: {
                index = 22;
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
        return this.computeIfAbsent(index, () -> ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)this.createSourceLevelSelector(() -> ClassPath.EMPTY, () -> this.getJava8RunTimeClassPath(type))));
    }

    @NonNull
    private ClassPath getJava8ClassPath(int type) {
        assert (type >= 0 && type <= 1);
        switch (type) {
            case 0: 
            case 1: {
                return this.computeIfAbsent(23 + type, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])(type == 0 ? this.javacClasspath : this.javacTestClasspath))));
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    @NonNull
    private ClassPath getJava8RunTimeClassPath(int type) {
        Supplier<ClassPath> provider;
        int index;
        switch (type) {
            case 0: 
            case 2: {
                index = 25;
                break;
            }
            case 1: 
            case 3: {
                index = 26;
                break;
            }
            case 4: {
                index = 27;
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
        switch (index) {
            case 25: 
            case 26: {
                provider = () -> ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])(index == 25 ? this.runClasspath : this.runTestClasspath)));
                break;
            }
            case 27: {
                provider = () -> {
                    String[] props = new String[this.runClasspath.length + 1];
                    System.arraycopy(this.runClasspath, 0, props, 1, this.runClasspath.length);
                    props[0] = this.distJar;
                    return ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])props));
                };
                break;
            }
            default: {
                throw new IllegalStateException(Integer.toString(index));
            }
        }
        return this.computeIfAbsent(index, provider);
    }

    @NonNull
    private ClassPath getJava8BootClassPath() {
        return this.computeIfAbsent(28, () -> ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createBootClassPathImplementation(this.evaluator, this.getProject(), this.getEndorsedClasspath(), (String)this.platform.first())));
    }

    @CheckForNull
    private Project getProject() {
        Project prj = this.project.get();
        if (prj == null) {
            prj = FileOwnerQuery.getOwner((FileObject)this.helper.getProjectDirectory());
            this.project.set(prj);
        }
        return prj;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/processor")) {
            return this.getProcessorClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath(file);
        }
        if (type.equals("classpath/endorsed")) {
            return this.getEndorsedClasspath();
        }
        if (type.equals("modules/boot")) {
            return this.getModuleBootPath();
        }
        if (type.equals("modules/compile")) {
            return this.getModuleCompilePath(file);
        }
        if (type.equals("modules/classpath")) {
            return this.getModuleLegacyClassPath(file);
        }
        if (type.equals("modules/processor")) {
            return this.getProcessorModulePath(file);
        }
        if (type.equals("modules/execute")) {
            return this.getModuleExecutePath(file);
        }
        if (type.equals("modules/execute-classpath")) {
            return this.getModuleLegacyExecuteClassPath(file);
        }
        return null;
    }

    @Override
    public ClassPath[] getProjectClassPaths(String type) {
        return (ClassPath[])ProjectManager.mutex().readAccess(() -> {
            if ("classpath/boot".equals(type)) {
                return new ClassPath[]{this.getBootClassPath(0), this.getBootClassPath(1)};
            }
            if ("classpath/compile".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getCompileTimeClasspath(0), this.getCompileTimeClasspath(1)};
                return l;
            }
            if ("classpath/source".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(1)};
                return l;
            }
            if ("classpath/execute".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getRunTimeClasspath(0), this.getRunTimeClasspath(1)};
                return l;
            }
            if ("classpath/processor".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getProcessorClasspath(0), this.getProcessorClasspath(1)};
                return l;
            }
            if ("modules/boot".equals(type)) {
                return new ClassPath[]{this.getModuleBootPath()};
            }
            if ("modules/compile".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getModuleCompilePath(0), this.getModuleCompilePath(1)};
                return l;
            }
            if ("modules/classpath".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getModuleLegacyClassPath(0), this.getModuleLegacyClassPath(1)};
                return l;
            }
            if ("modules/processor".equals(type)) {
                ClassPath[] l = new ClassPath[]{this.getProcessorModulePath(0), this.getProcessorModulePath(1)};
                return l;
            }
            assert (false);
            return null;
        });
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/boot".equals(type)) {
            return this.getBootClassPath(0);
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/processor".equals(type)) {
            return this.getProcessorClasspath(0);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        if ("classpath/execute".equals(type)) {
            return this.getRunTimeClasspath(0);
        }
        if ("modules/boot".equals(type)) {
            return this.getModuleBootPath();
        }
        if ("modules/compile".equals(type)) {
            return this.getModuleCompilePath(0);
        }
        if ("modules/processor".equals(type)) {
            return this.getProcessorModulePath(0);
        }
        if ("modules/classpath".equals(type)) {
            return this.getModuleLegacyClassPath(0);
        }
        if ("modules/execute".equals(type)) {
            return this.getModuleExecutePath(0);
        }
        if ("modules/execute-classpath".equals(type)) {
            return this.getModuleLegacyExecuteClassPath(0);
        }
        assert (false) : "Unknown classpath type: " + type;
        return null;
    }

    public String[] getPropertyName(SourceRoots roots, String type) {
        if ("classpath/endorsed".equals(type)) {
            return this.endorsedClasspath;
        }
        if (roots.isTest()) {
            if ("classpath/compile".equals(type)) {
                return this.javacTestClasspath;
            }
            if ("classpath/execute".equals(type)) {
                return this.runTestClasspath;
            }
            if ("classpath/processor".equals(type)) {
                return processorTestClasspath;
            }
            if ("modules/compile".equals(type)) {
                return this.testModulePath;
            }
            if ("modules/processor".equals(type)) {
                return processorTestModulepath;
            }
            return null;
        }
        if ("classpath/compile".equals(type)) {
            return this.javacClasspath;
        }
        if ("classpath/execute".equals(type)) {
            return this.runClasspath;
        }
        if ("classpath/processor".equals(type)) {
            return this.processorClasspath;
        }
        if ("modules/compile".equals(type)) {
            return this.modulePath;
        }
        if ("modules/processor".equals(type)) {
            return this.processorModulePath;
        }
        return null;
    }

    @Override
    public String[] getPropertyName(SourceGroup sg, String type) {
        int i;
        if ("classpath/endorsed".equals(type)) {
            return this.endorsedClasspath;
        }
        FileObject root = sg.getRootFolder();
        FileObject[] path = this.getPrimarySrcPath();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            switch (type) {
                case "classpath/compile": {
                    return this.javacClasspath;
                }
                case "classpath/execute": {
                    return this.runClasspath;
                }
                case "classpath/processor": {
                    return this.processorClasspath;
                }
                case "modules/compile": {
                    return this.modulePath;
                }
                case "modules/execute": {
                    return this.moduleExecutePath;
                }
                case "modules/processor": {
                    return this.processorModulePath;
                }
            }
            return null;
        }
        path = this.getTestSrcDir();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            switch (type) {
                case "classpath/compile": {
                    return this.javacTestClasspath;
                }
                case "classpath/execute": {
                    return this.runTestClasspath;
                }
                case "classpath/processor": {
                    return processorTestClasspath;
                }
                case "modules/compile": {
                    return this.testModulePath;
                }
                case "modules/execute": {
                    return this.moduleExecutePath;
                }
                case "modules/processor": {
                    return processorTestModulepath;
                }
            }
            return null;
        }
        return null;
    }

    @NonNull
    private Function<URL, Boolean> getFilter(int type) {
        switch (type) {
            case 0: 
            case 2: {
                return new Filter(this.buildClassesDir);
            }
            case 1: 
            case 3: {
                return new Filter(this.buildTestClassesDir);
            }
            case 4: {
                return new Filter(this.distJar);
            }
        }
        throw new IllegalArgumentException(Integer.toString(type));
    }

    @NonNull
    private ClassPathSupport.Selector createSourceLevelSelector(@NonNull Supplier<? extends ClassPath> preJdk9, @NonNull Supplier<? extends ClassPath> jdk9) {
        ArrayList<Supplier<? extends ClassPath>> cps = new ArrayList<Supplier<? extends ClassPath>>(2);
        cps.add(preJdk9);
        cps.add(jdk9);
        return new SourceLevelSelector(this.evaluator, this.javacSource, cps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath computeIfAbsent(int cacheIndex, Supplier<ClassPath> provider) {
        ClassPathProviderImpl classPathProviderImpl = this;
        synchronized (classPathProviderImpl) {
            ClassPath cp = this.cache[cacheIndex];
            if (cp != null) {
                return cp;
            }
        }
        return (ClassPath)ProjectManager.mutex().readAccess(() -> {
            ClassPathProviderImpl classPathProviderImpl = this;
            synchronized (classPathProviderImpl) {
                ClassPath cp = this.cache[cacheIndex];
                if (cp == null) {
                    this.cache[cacheIndex] = cp = (ClassPath)provider.get();
                }
                return cp;
            }
        });
    }

    private static /* synthetic */ ClassPath lambda$getModuleExecutePath$26(Supplier provider) {
        return ClassPathFactory.createClassPath((ClassPathImplementation)((ClassPathImplementation)provider.get()));
    }

    static final class SourceLevelSelector
    implements ClassPathSupport.Selector,
    PropertyChangeListener {
        private static final SpecificationVersion JDK9 = new SpecificationVersion("1.9");
        private final PropertyEvaluator eval;
        private final String sourceLevelPropName;
        private final List<? extends Supplier<? extends ClassPath>> cpfs;
        private final PropertyChangeSupport listeners;
        private volatile ClassPath active;
        private volatile ClassPath[] cps;

        SourceLevelSelector(@NonNull PropertyEvaluator eval, @NonNull String sourceLevelPropName, @NonNull List<? extends Supplier<? extends ClassPath>> cpFactories) {
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"sourceLevelPropName", (Object)sourceLevelPropName);
            Parameters.notNull((CharSequence)"cpFactories", cpFactories);
            if (cpFactories.size() != 2) {
                throw new IllegalArgumentException("Invalid classpaths: " + cpFactories);
            }
            for (Supplier<? extends ClassPath> supplier : cpFactories) {
                if (supplier != null) continue;
                throw new NullPointerException("Classpaths contain null: " + cpFactories);
            }
            this.eval = eval;
            this.sourceLevelPropName = sourceLevelPropName;
            this.cpfs = cpFactories;
            this.listeners = new PropertyChangeSupport(this);
            this.cps = new ClassPath[2];
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
        }

        @NonNull
        public ClassPath getActiveClassPath() {
            ClassPath res = this.active;
            if (res == null) {
                int index = 0;
                String sl = this.eval.getProperty(this.sourceLevelPropName);
                if (sl != null) {
                    try {
                        if (JDK9.compareTo((Object)new SpecificationVersion(sl)) <= 0) {
                            index = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((res = this.cps[index]) == null) {
                    res = this.cpfs.get(index).get();
                    if (res == null) {
                        throw new IllegalStateException(String.format("ClassPathFactory: %s returned null", this.cpfs.get(index)));
                    }
                    this.cps[index] = res;
                    this.cps = this.cps;
                }
                this.active = res;
            }
            return res;
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || this.sourceLevelPropName.equals(propName)) {
                this.active = null;
                this.listeners.firePropertyChange("activeClassPath", null, null);
            }
        }
    }

    private class Filter
    implements Function<URL, Boolean> {
        private final String includeProp;
        private final String excludeProp;

        Filter(String includeProp) {
            this(includeProp, null);
        }

        Filter(@NullAllowed String includeProp, String excludeProp) {
            this.includeProp = includeProp;
            this.excludeProp = excludeProp;
        }

        @Override
        public Boolean apply(@NonNull URL url) {
            URL aurl;
            URL uRL = aurl = FileUtil.isArchiveArtifact((URL)url) ? FileUtil.getArchiveFile((URL)url) : url;
            if (Optional.ofNullable(this.includeProp).map(p -> ClassPathProviderImpl.this.getDir(p)).map(fo -> Objects.equals(fo.toURL(), aurl)).orElse(Boolean.FALSE).booleanValue()) {
                return Boolean.TRUE;
            }
            if (Optional.ofNullable(this.excludeProp).map(p -> ClassPathProviderImpl.this.getDir(p)).map(fo -> Objects.equals(fo.toURL(), aurl)).orElse(Boolean.FALSE).booleanValue()) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    public static final class Builder {
        private static final String DEFAULT_BUILD_CLASSES_DIR = "build.classes.dir";
        private static final String DEFAULT_BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
        private static final String DEFAULT_DIST_JAR = "dist.jar";
        private static final String[] DEFAULT_JAVAC_CLASS_PATH = new String[]{"javac.classpath"};
        private static final String[] DEFAULT_PROCESSOR_PATH = new String[]{"javac.processorpath"};
        private static final String[] DEFAULT_JAVAC_TEST_CLASS_PATH = new String[]{"javac.test.classpath"};
        private static final String[] DEFAULT_RUN_CLASS_PATH = new String[]{"run.classpath"};
        private static final String[] DEFAULT_RUN_TEST_CLASS_PATH = new String[]{"run.test.classpath"};
        private static final String[] DEFAULT_ENDORSED_CLASSPATH = new String[]{"endorsed.classpath"};
        private static final String[] DEFAULT_MODULE_PATH = new String[]{"javac.modulepath"};
        private static final String[] DEFAULT_TEST_MODULE_PATH = new String[]{"javac.test.modulepath"};
        private static final String[] DEFAULT_PROCESSOR_MODULE_PATH = new String[]{"javac.processormodulepath"};
        private static final String[] DEFAULT_MODULE_EXECUTE_PATH = new String[]{"run.modulepath"};
        private static final String[] DEFAULT_TEST_MODULE_EXECUTE_PATH = new String[]{"run.test.modulepath"};
        private static final String DEFAULT_JAVAC_SOURCE = "javac.source";
        private final AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private final SourceRoots sourceRoots;
        private final SourceRoots testSourceRoots;
        private String platformType = "j2se";
        private String buildClassesDir = "build.classes.dir";
        private String buildTestClassesDir = "build.test.classes.dir";
        private String distJar = "dist.jar";
        private String[] javacClasspath = DEFAULT_JAVAC_CLASS_PATH;
        private String[] processorPath = DEFAULT_PROCESSOR_PATH;
        private String[] javacTestClasspath = DEFAULT_JAVAC_TEST_CLASS_PATH;
        private String[] runClasspath = DEFAULT_RUN_CLASS_PATH;
        private String[] runTestClasspath = DEFAULT_RUN_TEST_CLASS_PATH;
        private String[] endorsedClasspath = DEFAULT_ENDORSED_CLASSPATH;
        private String[] modulePath = DEFAULT_MODULE_PATH;
        private String[] testModulePath = DEFAULT_TEST_MODULE_PATH;
        private String[] processorModulePath = DEFAULT_PROCESSOR_MODULE_PATH;
        private String[] moduleExecutePath = DEFAULT_MODULE_EXECUTE_PATH;
        private String[] testModuleExecutePath = DEFAULT_TEST_MODULE_EXECUTE_PATH;
        private String[] bootClasspathProperties;
        private String javacSource = "javac.source";
        private Project project;

        private Builder(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
            Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
            Parameters.notNull((CharSequence)"testSourceRoots", (Object)testSourceRoots);
            this.helper = helper;
            this.evaluator = evaluator;
            this.sourceRoots = sourceRoots;
            this.testSourceRoots = testSourceRoots;
        }

        @NonNull
        public Builder setPlatformType(@NonNull String platformType) {
            Parameters.notNull((CharSequence)"platformType", (Object)platformType);
            this.platformType = platformType;
            return this;
        }

        @NonNull
        public Builder setBuildClassesDirProperty(@NonNull String buildClassesDirProperty) {
            Parameters.notNull((CharSequence)"buildClassesDirProperty", (Object)buildClassesDirProperty);
            this.buildClassesDir = buildClassesDirProperty;
            return this;
        }

        @NonNull
        public Builder setBuildTestClassesDirProperty(@NonNull String buildTestClassesDirProperty) {
            Parameters.notNull((CharSequence)"buildTestClassesDirProperty", (Object)buildTestClassesDirProperty);
            this.buildTestClassesDir = buildTestClassesDirProperty;
            return this;
        }

        @NonNull
        public Builder setDistJarProperty(@NonNull String distJarProperty) {
            Parameters.notNull((CharSequence)"distJarProperty", (Object)distJarProperty);
            this.distJar = distJarProperty;
            return this;
        }

        @NonNull
        public Builder setJavacClassPathProperties(@NonNull String[] javacClassPathProperties) {
            Parameters.notNull((CharSequence)"javacClassPathProperties", (Object)javacClassPathProperties);
            this.javacClasspath = Arrays.copyOf(javacClassPathProperties, javacClassPathProperties.length);
            return this;
        }

        @NonNull
        public Builder setProcessorPathProperties(@NonNull String[] processorPathProperties) {
            Parameters.notNull((CharSequence)"processorPathProperties", (Object)processorPathProperties);
            this.processorPath = Arrays.copyOf(processorPathProperties, processorPathProperties.length);
            return this;
        }

        @NonNull
        public Builder setJavacTestClasspathProperties(@NonNull String[] javacTestClasspathProperties) {
            Parameters.notNull((CharSequence)"javacTestClasspathProperties", (Object)javacTestClasspathProperties);
            this.javacTestClasspath = Arrays.copyOf(javacTestClasspathProperties, javacTestClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunClasspathProperties(@NonNull String[] runClasspathProperties) {
            Parameters.notNull((CharSequence)"runClasspathProperties", (Object)runClasspathProperties);
            this.runClasspath = Arrays.copyOf(runClasspathProperties, runClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunTestClasspathProperties(@NonNull String[] runTestClasspathProperties) {
            Parameters.notNull((CharSequence)"runTestClasspathProperties", (Object)runTestClasspathProperties);
            this.runTestClasspath = Arrays.copyOf(runTestClasspathProperties, runTestClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setEndorsedClasspathProperties(@NonNull String[] endorsedClasspathProperties) {
            Parameters.notNull((CharSequence)"endorsedClasspathProperties", (Object)endorsedClasspathProperties);
            this.endorsedClasspath = Arrays.copyOf(endorsedClasspathProperties, endorsedClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setModulepathProperties(@NonNull String[] modulePathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulePathProperties);
            this.modulePath = Arrays.copyOf(modulePathProperties, modulePathProperties.length);
            return this;
        }

        @NonNull
        public Builder setTestModulepathProperties(@NonNull String[] modulePathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulePathProperties);
            this.testModulePath = Arrays.copyOf(modulePathProperties, modulePathProperties.length);
            return this;
        }

        @NonNull
        public Builder setProcessorModulepathProperties(@NonNull String[] processorModulePathProperties) {
            Parameters.notNull((CharSequence)"processorModulePathProperties", (Object)processorModulePathProperties);
            this.modulePath = Arrays.copyOf(processorModulePathProperties, processorModulePathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunModulepathProperties(@NonNull String[] modulePathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulePathProperties);
            this.moduleExecutePath = Arrays.copyOf(modulePathProperties, modulePathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunTestModulepathProperties(@NonNull String[] modulePathProperties) {
            Parameters.notNull((CharSequence)"modulePathProperties", (Object)modulePathProperties);
            this.testModuleExecutePath = Arrays.copyOf(modulePathProperties, modulePathProperties.length);
            return this;
        }

        @NonNull
        public Builder setBootClasspathProperties(String ... bootClasspathProperties) {
            Parameters.notNull((CharSequence)"bootClasspathProperties", (Object)bootClasspathProperties);
            this.bootClasspathProperties = Arrays.copyOf(bootClasspathProperties, bootClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setProject(@NonNull Project project) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            this.project = project;
            return this;
        }

        @NonNull
        public Builder setJavacSourceProperty(@NonNull String javacSource) {
            Parameters.notNull((CharSequence)"javacSource", (Object)javacSource);
            this.javacSource = javacSource;
            return this;
        }

        @NonNull
        public ClassPathProviderImpl build() {
            Union2 platform = this.bootClasspathProperties == null ? Union2.createFirst((Object)this.platformType) : Union2.createSecond((Object)this.bootClasspathProperties);
            return new ClassPathProviderImpl(this.helper, this.evaluator, this.sourceRoots, this.testSourceRoots, this.buildClassesDir, this.distJar, this.buildTestClassesDir, this.javacClasspath, this.processorPath, this.javacTestClasspath, this.runClasspath, this.runTestClasspath, this.endorsedClasspath, this.modulePath, this.testModulePath, this.processorModulePath, this.moduleExecutePath, this.testModuleExecutePath, platform, this.javacSource, this.project);
        }

        @NonNull
        public static Builder create(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots) {
            return new Builder(helper, evaluator, sourceRoots, testSourceRoots);
        }
    }
}

