/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

class ThemeJsonNamedColorPsiReference
extends JsonSchemaBaseReference<JsonLiteral> {
    private final String myName;

    ThemeJsonNamedColorPsiReference(JsonLiteral element) {
        super((PsiElement)element, element.getTextLength() >= 2 ? new TextRange(1, element.getTextLength() - 1) : TextRange.EMPTY_RANGE);
        this.myName = StringUtil.unquoteString((String)element.getText());
    }

    @Nullable
    public PsiElement resolveInner() {
        PsiFile containingFile = ((JsonLiteral)this.getElement()).getContainingFile();
        if (!(containingFile instanceof JsonFile)) {
            return null;
        }
        List<JsonProperty> namedColors = ThemeJsonUtil.getNamedColors((JsonFile)containingFile);
        return (PsiElement)ContainerUtil.find(namedColors, property -> property.getName().equals(this.myName));
    }

    public Object @NotNull [] getVariants() {
        if (EMPTY_ARRAY == null) {
            ThemeJsonNamedColorPsiReference.$$$reportNull$$$0(0);
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/themes/ThemeJsonNamedColorPsiReference", "getVariants"));
    }
}

