/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class UseCoupleQuickFix
implements LocalQuickFix {
    private static final String COUPLE_FQN = "com.intellij.openapi.util.Couple";
    @IntentionName
    private final String myText;

    public UseCoupleQuickFix(@IntentionName String text2) {
        this.myText = text2;
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = this.myText;
        if (string == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.use.couple.family.name", new Object[0]);
        if (string == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement newElement;
        if (project == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            UseCoupleQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiClassType type1 = (PsiClassType)typeElement.getType();
            PsiType[] parameters = type1.getParameters();
            if (parameters.length != 2) {
                return;
            }
            PsiTypeElement newType = factory.createTypeElementFromText("com.intellij.openapi.util.Couple<" + parameters[0].getCanonicalText() + ">", element.getContext());
            newElement = element.replace((PsiElement)newType);
        } else {
            PsiElement parent = element.getParent().getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            String text2 = "com.intellij.openapi.util.Couple.of" + methodCallExpression.getArgumentList().getText();
            PsiExpression expression = factory.createExpressionFromText(text2, element.getContext());
            newElement = parent.replace((PsiElement)expression);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/quickfix/UseCoupleQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/quickfix/UseCoupleQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

