/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ReportSection;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;
import org.jetbrains.coverage.gnu.trove.TObjectIntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassListSection
extends ReportSection {
    protected abstract void loadClass(DataInputStream var1, ClassData var2, int var3) throws IOException;

    protected abstract void saveClass(ClassData var1, DataOutput var2, int var3) throws IOException;

    @Override
    public void load(ProjectData projectData, DataInputStream in, TIntObjectHashMap<ClassData> dict, int version) throws IOException {
        int classId = CoverageIOUtil.readINT(in);
        while (classId != -1) {
            ClassData classData = dict.get(classId);
            this.loadClass(in, classData, version);
            classId = CoverageIOUtil.readINT(in);
        }
    }

    @Override
    protected void saveInternal(final ProjectData projectData, final DataOutput out, TObjectIntHashMap<String> dict) throws IOException {
        try {
            dict.forEachEntry(new TObjectIntProcedure<String>(){

                @Override
                public boolean execute(String className, int index) {
                    try {
                        ClassListSection.this.saveClass(projectData.getClassData(className), out, index);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        CoverageIOUtil.writeINT(out, -1);
    }
}

