/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.shellcheck.ShQuickFixIntention;
import com.intellij.sh.shellcheck.ShShellcheckInspection;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.sh.shellcheck.intention.ShDisableInspectionIntention;
import com.intellij.sh.shellcheck.intention.ShSuppressInspectionIntention;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShShellcheckExternalAnnotator
extends ExternalAnnotator<CollectedInfo, ShellcheckResponse> {
    private static final Logger LOG = Logger.getInstance(ShShellcheckExternalAnnotator.class);
    private static final List<@NlsSafe String> KNOWN_SHELLS = Arrays.asList("bash", "dash", "ksh", "sh");
    @NlsSafe
    private static final String DEFAULT_SHELL = "bash";
    private static final int TIMEOUT_IN_MILLISECONDS = 10000;

    public String getPairedBatchInspectionShortName() {
        return "ShellCheck";
    }

    @Nullable
    public CollectedInfo collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(0);
        }
        if (!(file instanceof ShFile)) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return null;
        }
        return new CollectedInfo(file.getProject(), parent.getPath(), file.getText(), file.getModificationStamp(), ShShellcheckExternalAnnotator.getShellcheckExecutionParams(file));
    }

    @Nullable
    public ShellcheckResponse doAnnotate(@NotNull CollectedInfo fileInfo) {
        Application application;
        if (fileInfo == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(1);
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isReadAccessAllowed() && !application.isUnitTestMode()) {
            return null;
        }
        String shellcheckExecutable = ShSettings.getShellcheckPath();
        if (!ShShellcheckUtil.isExecutionValidPath(shellcheckExecutable)) {
            return null;
        }
        ShShellcheckUtil.checkShellCheckForUpdate(fileInfo.project);
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(shellcheckExecutable).withParameters(fileInfo.executionParams);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                commandLine.withWorkDirectory(fileInfo.workDirectory);
            }
            final long timestamp = fileInfo.modificationStamp;
            OSProcessHandler handler = new OSProcessHandler(commandLine);
            final Ref response = Ref.create();
            handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Type type = TypeToken.getParameterized(List.class, (Type[])new Type[]{Result.class}).getType();
                    Collection results = (Collection)new Gson().fromJson(this.getOutput().getStdout(), type);
                    if (results != null) {
                        response.set((Object)new ShellcheckResponse(results, timestamp));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sh/shellcheck/ShShellcheckExternalAnnotator$1", "processTerminated"));
                }
            });
            handler.startNotify();
            ShShellcheckExternalAnnotator.writeFileContentToStdin(handler.getProcess(), fileInfo.fileContent, commandLine.getCharset());
            if (!handler.waitFor(10000L)) {
                LOG.debug("Execution timeout, process will be forcibly terminated");
                handler.destroyProcess();
            }
            return (ShellcheckResponse)response.get();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void apply(@NotNull PsiFile file, ShellcheckResponse shellcheckResponse, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(3);
        }
        super.apply(file, (Object)shellcheckResponse, holder);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        Collection outerElements = PsiTreeUtil.findChildrenOfType((PsiElement)file, OuterLanguageElement.class);
        List rangesOfOuterElements = ContainerUtil.map((Collection)outerElements, el -> el.getTextRange());
        for (Result result : shellcheckResponse.results) {
            CharSequence sequence = document.getCharsSequence();
            int startOffset = ShShellcheckUtil.calcOffset(sequence, document.getLineStartOffset(result.line - 1), result.column);
            int endOffset = ShShellcheckUtil.calcOffset(sequence, document.getLineStartOffset(result.endLine - 1), result.endColumn);
            TextRange range = TextRange.create((int)startOffset, (int)(endOffset == startOffset ? endOffset + 1 : endOffset));
            if (!file.getTextRange().contains(range) || ContainerUtil.exists((Iterable)rangesOfOuterElements, it -> it.contains(range))) continue;
            long code = result.code;
            String message = result.message;
            @NonNls String scCode = "SC" + code;
            @NonNls String html = "<html><p>" + StringUtil.escapeXmlEntities((String)message) + "</p><p>See <a href='https://github.com/koalaman/shellcheck/wiki/SC" + code + "'>" + scCode + "</a>.</p></html>";
            AnnotationBuilder builder = holder.newAnnotation(ShShellcheckExternalAnnotator.severity(result.level), message).range(range).tooltip(html);
            String formattedMessage = ShShellcheckExternalAnnotator.format(message);
            Fix fix = result.fix;
            if (fix != null && !ArrayUtil.isEmpty((Object[])fix.replacements)) {
                builder = builder.withFix((IntentionAction)new ShQuickFixIntention(formattedMessage, fix, shellcheckResponse.timestamp));
            }
            String quotedMessage = ShShellcheckExternalAnnotator.quote(formattedMessage);
            builder.withFix((IntentionAction)new ShSuppressInspectionIntention(quotedMessage, scCode, startOffset)).withFix((IntentionAction)new ShDisableInspectionIntention(quotedMessage, scCode)).create();
        }
    }

    @NotNull
    private static HighlightSeverity severity(@Nullable String level) {
        if ("error".equals(level)) {
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            if (highlightSeverity == null) {
                ShShellcheckExternalAnnotator.$$$reportNull$$$0(4);
            }
            return highlightSeverity;
        }
        if ("warning".equals(level)) {
            HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
            if (highlightSeverity == null) {
                ShShellcheckExternalAnnotator.$$$reportNull$$$0(5);
            }
            return highlightSeverity;
        }
        HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
        if (highlightSeverity == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(6);
        }
        return highlightSeverity;
    }

    private static @NotNull List<@NlsSafe String> getShellcheckExecutionParams(@NotNull PsiFile file) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(7);
        }
        String interpreter = ShShellcheckExternalAnnotator.getInterpreter(file);
        SmartList params = new SmartList();
        ShShellcheckInspection inspection = ShShellcheckInspection.findShShellcheckInspection((PsiElement)file);
        Collections.addAll(params, new String[]{"--color=never", "--format=json", "--severity=style", "--shell=" + interpreter, "--wiki-link-count=10", "--exclude=SC1091", "-"});
        inspection.getDisabledInspections().forEach(arg_0 -> ShShellcheckExternalAnnotator.lambda$getShellcheckExecutionParams$2((List)params, arg_0));
        SmartList smartList = params;
        if (smartList == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static void writeFileContentToStdin(@NotNull Process process, @NotNull String content, @NotNull Charset charset) {
        if (process == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(9);
        }
        if (content == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(10);
        }
        if (charset == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(11);
        }
        try (OutputStream stdin = Objects.requireNonNull(process.getOutputStream());){
            stdin.write(content.getBytes(charset));
            stdin.flush();
        }
        catch (IOException e) {
            LOG.debug("Failed to write file content to stdin\n\n" + content, (Throwable)e);
        }
    }

    @Contract(pure=true)
    @NotNull
    private static String format(@NotNull String originalMessage) {
        if (originalMessage == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(12);
        }
        String string = originalMessage.endsWith(".") ? originalMessage.substring(0, originalMessage.length() - 1) : originalMessage;
        if (string == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String quote(@NotNull String originalMessage) {
        if (originalMessage == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(14);
        }
        String string = "'" + StringUtil.first((String)originalMessage, (int)60, (boolean)true) + "'";
        if (string == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getInterpreter(@NotNull PsiFile file) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(16);
        }
        if (!(file instanceof ShFile)) {
            return DEFAULT_SHELL;
        }
        String string = ShShebangParserUtil.getInterpreter((ShFile)file, KNOWN_SHELLS, DEFAULT_SHELL);
        if (string == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void lambda$getShellcheckExecutionParams$2(List params, String setting) {
        params.add("--exclude=" + setting);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/shellcheck/ShShellcheckExternalAnnotator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/shellcheck/ShShellcheckExternalAnnotator";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "severity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellcheckExecutionParams";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getShellcheckExecutionParams";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeFileContentToStdin";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CollectedInfo {
        private final Project project;
        private final String workDirectory;
        private final String fileContent;
        private final long modificationStamp;
        private final List<String> executionParams;

        CollectedInfo(Project project, String workDirectory, String fileContent, long modificationStamp, List<String> executionParams) {
            this.project = project;
            this.workDirectory = workDirectory;
            this.fileContent = fileContent;
            this.modificationStamp = modificationStamp;
            this.executionParams = executionParams;
        }
    }

    class Replacement {
        int line;
        int column;
        int endLine;
        int endColumn;
        String replacement;

        Replacement() {
        }
    }

    class Fix {
        Replacement[] replacements;

        Fix() {
        }
    }

    class Result {
        int line;
        int endLine;
        int column;
        int endColumn;
        String level;
        @InspectionMessage String message;
        long code;
        @Nullable
        Fix fix;

        Result() {
        }
    }

    class ShellcheckResponse {
        final Collection<Result> results;
        final long timestamp;

        ShellcheckResponse(Collection<Result> results, long timestamp) {
            if (results == null) {
                ShellcheckResponse.$$$reportNull$$$0(0);
            }
            this.results = results;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/sh/shellcheck/ShShellcheckExternalAnnotator$ShellcheckResponse", "<init>"));
        }
    }
}

