/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.ExistingTemplatesComponent;
import com.intellij.structuralsearch.plugin.ui.FileTypeChooser;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.TriConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper
implements DocumentListener {
    @NonNls
    private static final String SEARCH_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String REPLACE_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    @NonNls
    private static final String SHORTEN_FQN_STATE = "structural.search.shorten.fqn";
    @NonNls
    private static final String REFORMAT_STATE = "structural.search.reformat";
    @NonNls
    private static final String USE_STATIC_IMPORT_STATE = "structural.search.use.static.import";
    @NonNls
    private static final String FILTERS_VISIBLE_STATE = "structural.search.filters.visible";
    @NonNls
    private static final String TEMPLATES_VISIBLE_STATE = "structural.search.templates.visible";
    @NonNls
    private static final String PINNED_STATE = "structural.seach.pinned";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH_DIALOG = Key.create((String)"STRUCTURAL_SEARCH_DIALOG");
    public static final Key<String> STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID = Key.create((String)"STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID");
    public static final Key<Runnable> STRUCTURAL_SEARCH_ERROR_CALLBACK = Key.create((String)"STRUCTURAL_SEARCH_ERROR_CALLBACK");
    private static final Key<Configuration> STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION = Key.create((String)"STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION");
    public static final Key<Boolean> TEST_STRUCTURAL_SEARCH_DIALOG = Key.create((String)"TEST_STRUCTURAL_SEARCH_DIALOG");
    @NotNull
    private final SearchContext mySearchContext;
    private Editor myEditor;
    private boolean myReplace;
    @NotNull
    private Configuration myConfiguration;
    @Nullable
    @NonNls
    private LanguageFileType myFileType;
    private Language myDialect;
    private PatternContext myPatternContext;
    private final List<RangeHighlighter> myRangeHighlighters;
    private final DocumentListener myRestartHighlightingListener;
    private boolean myChangedConfiguration;
    private final Alarm myAlarm;
    private boolean myUseLastConfiguration;
    private boolean myPinned;
    private final boolean myEditConfigOnly;
    private final FileTypeChooser myFileTypeChooser;
    private ActionToolbarImpl myOptionsToolbar;
    private EditorTextField mySearchCriteriaEdit;
    private EditorTextField myReplaceCriteriaEdit;
    private OnePixelSplitter mySearchEditorPanel;
    private OnePixelSplitter myMainSplitter;
    private FilterPanel myFilterPanel;
    private ExistingTemplatesComponent myExistingTemplatesComponent;
    private LinkComboBox myTargetComboBox;
    private ScopePanel myScopePanel;
    private JCheckBox myOpenInNewTab;
    private JComponent myReplacePanel;
    private SwitchAction mySwitchAction;
    private final ArrayList<JComponent> myComponentsWithEditorBackground;
    private JComponent mySearchWrapper;
    private JBCheckBox myInjected;
    private JBCheckBox myMatchCase;
    private JComponent myReplaceWrapper;
    private JBCheckBox myShortenFqn;
    private JBCheckBox myStaticImport;
    private JBCheckBox myReformat;
    private Balloon myBalloon;

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace) {
        if (searchContext == null) {
            StructuralSearchDialog.$$$reportNull$$$0(0);
        }
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        if (searchContext == null) {
            StructuralSearchDialog.$$$reportNull$$$0(1);
        }
        super(searchContext.getProject(), true);
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        this.myRangeHighlighters = new SmartList();
        this.myRestartHighlightingListener = new DocumentListener(){
            final Runnable runnable = () -> ReadAction.nonBlocking(() -> StructuralSearchDialog.this.addMatchHighlights()).withDocumentsCommitted(StructuralSearchDialog.this.getProject()).expireWith(StructuralSearchDialog.this.getDisposable()).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
                StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "documentChanged"));
            }
        };
        this.myFileTypeChooser = new FileTypeChooser();
        this.myComponentsWithEditorBackground = new ArrayList();
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.myEditConfigOnly = editConfigOnly;
        this.mySearchContext = searchContext;
        this.myEditor = searchContext.getEditor();
        this.addRestartHighlightingListenerToCurrentEditor();
        FileEditorManagerListener listener = new FileEditorManagerListener(){
            FileEditor myNewEditor;
            final Runnable runnable = () -> {
                StructuralSearchDialog.this.removeRestartHighlightingListenerFromCurrentEditor();
                StructuralSearchDialog.this.removeMatchHighlights();
                if (this.myNewEditor instanceof TextEditor) {
                    StructuralSearchDialog.this.myEditor = ((TextEditor)this.myNewEditor).getEditor();
                    StructuralSearchDialog.this.addMatchHighlights();
                    StructuralSearchDialog.this.addRestartHighlightingListenerToCurrentEditor();
                } else {
                    StructuralSearchDialog.this.myEditor = null;
                }
            };

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
                this.myNewEditor = event.getNewEditor();
                StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "selectionChanged"));
            }
        };
        MessageBusConnection connection = this.getProject().getMessageBus().connect(this.getDisposable());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                StructuralSearchDialog.this.close(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "beforePluginUnload"));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appClosing() {
                StructuralSearchDialog.this.close(1);
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (project == StructuralSearchDialog.this.getProject()) {
                    StructuralSearchDialog.this.close(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5", "projectClosing"));
            }
        });
        connection.subscribe(EditorColorsManager.TOPIC, uiSettings -> this.updateColors());
        this.myConfiguration = this.createConfiguration(null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        this.setValidationDelay(100);
    }

    private void addRestartHighlightingListenerToCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().addDocumentListener(this.myRestartHighlightingListener);
        }
    }

    private void removeRestartHighlightingListenerFromCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().removeDocumentListener(this.myRestartHighlightingListener);
        }
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.myUseLastConfiguration = useLastConfiguration;
    }

    private EditorTextField createEditor(boolean replace) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile != null);
        Document document = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, "", profile);
        document.addDocumentListener((DocumentListener)this, this.myDisposable);
        document.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)(this.myPatternContext == null ? "" : this.myPatternContext.getId()));
        MyEditorTextField textField = new MyEditorTextField(document, replace);
        textField.setFont(EditorFontType.getGlobalPlainFont());
        textField.setPreferredSize(new Dimension(550, 150));
        textField.setMinimumSize(new Dimension(200, 50));
        this.myComponentsWithEditorBackground.add((JComponent)((Object)textField));
        return textField;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            StructuralSearchDialog.$$$reportNull$$$0(2);
        }
        this.initValidation();
        if (!this.myChangedConfiguration) {
            this.myExistingTemplatesComponent.templateChanged();
        }
    }

    private void initializeFilterPanel(@Nullable CompiledPattern compiledPattern) {
        CompiledPattern finalCompiledPattern;
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        CompiledPattern compiledPattern2 = finalCompiledPattern = compiledPattern == null ? PatternCompiler.compilePattern(this.getProject(), matchOptions, false, false) : compiledPattern;
        if (finalCompiledPattern == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            SubstitutionShortInfoHandler.updateEditorInlays(this.mySearchCriteriaEdit.getEditor());
            if (this.myReplace) {
                SubstitutionShortInfoHandler.updateEditorInlays(this.myReplaceCriteriaEdit.getEditor());
            }
            this.myFilterPanel.setCompiledPattern(finalCompiledPattern);
            if (this.myFilterPanel.getVariable() == null) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
        }, ModalityState.stateForComponent((Component)this.myFilterPanel.getComponent()));
    }

    @NotNull
    private Configuration createConfiguration(Configuration template) {
        if (this.myReplace) {
            return template == null ? new ReplaceConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined()) : new ReplaceConfiguration(template);
        }
        if (template == null) {
            return new SearchConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined());
        }
        return template instanceof ReplaceConfiguration ? new ReplaceConfiguration(template) : new SearchConfiguration(template);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    static String getUserDefined() {
        return SSRBundle.message("new.template.defaultname", new Object[0]);
    }

    private void setTextFromContext() {
        SelectionModel selectionModel;
        String selectedText;
        Editor editor = this.myEditor;
        if (editor != null && (selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration(selectedText)) {
                return;
            }
            String text = selectedText.trim();
            this.setTextForEditor(text.trim(), this.mySearchCriteriaEdit);
            if (this.myReplace) {
                this.setTextForEditor(text, this.myReplaceCriteriaEdit);
            }
            this.myScopePanel.setScopesFromContext(null);
            ApplicationManager.getApplication().invokeLater(() -> this.startTemplate());
            return;
        }
        Configuration previousConfiguration = (Configuration)this.getProject().getUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION);
        if (previousConfiguration != null) {
            this.loadConfiguration(previousConfiguration);
        } else {
            Configuration configuration = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration();
            if (configuration != null) {
                this.loadConfiguration(configuration);
            }
        }
    }

    private void setTextForEditor(String text, EditorTextField editor) {
        editor.setText(text);
        editor.selectAll();
        Project project = this.getProject();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)SSRBundle.message("command.name.adjust.line.indent", new Object[0]), (String)"Structural Search", () -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, new TextRange(0, document.getTextLength())), (PsiFile[])new PsiFile[]{file});
    }

    private void startSearching() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.mySearchContext).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        }
    }

    @NotNull
    @Nls
    @NlsContexts.DialogTitle
    private String getDefaultTitle() {
        String string = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string == null) {
            StructuralSearchDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            StructuralSearchDialog.$$$reportNull$$$0(4);
        }
        return dialogStyle;
    }

    protected JComponent createCenterPanel() {
        JPanel searchPanel = this.createSearchPanel();
        this.myScopePanel = new ScopePanel(this.getProject(), this.myDisposable);
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.getProject()).getRecentDirectories());
            this.myScopePanel.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)scope -> this.initValidation()));
        } else {
            this.myScopePanel.setVisible(false);
        }
        this.myReplacePanel = this.createReplacePanel();
        this.myReplacePanel.setVisible(this.myReplace);
        GridBagLayout centerPanelLayout = new GridBagLayout();
        GridBag centerConstraint = new GridBag().setDefaultFill(1).setDefaultWeightX(1.0).setDefaultWeightY(1.0);
        JPanel centerPanel = new JPanel(centerPanelLayout);
        centerPanel.add((Component)searchPanel, centerConstraint.nextLine());
        centerPanel.add((Component)this.myReplacePanel, centerConstraint.nextLine());
        centerPanel.add((Component)this.myScopePanel, centerConstraint.nextLine().weighty(0.0).insets(8, 10, 8, 10));
        this.myExistingTemplatesComponent = new ExistingTemplatesComponent(this.getProject());
        this.myExistingTemplatesComponent.onConfigurationSelected(configuration -> this.loadConfiguration((Configuration)configuration));
        this.myExistingTemplatesComponent.setConfigurationProducer(() -> this.myConfiguration);
        this.myExistingTemplatesComponent.setSearchEditorProducer(() -> this.mySearchCriteriaEdit);
        this.myExistingTemplatesComponent.setExportRunnable(() -> this.exportToClipboard());
        this.myExistingTemplatesComponent.setImportRunnable(() -> this.importFromClipboard());
        this.myMainSplitter = new OnePixelSplitter(false, 0.2f);
        this.myMainSplitter.setFirstComponent(this.myExistingTemplatesComponent.getTemplatesPanel());
        this.myMainSplitter.setSecondComponent((JComponent)centerPanel);
        this.updateColors();
        this.updateOptions();
        return this.myMainSplitter;
    }

    private JPanel createSearchPanel() {
        List<PatternContext> contexts;
        JBLabel searchTemplateLabel = new JBLabel(SSRBundle.message("search.template", new Object[0]));
        this.myFileType = UIUtil.detectFileType(this.mySearchContext);
        this.myDialect = this.myFileType.getLanguage();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile != null && !(contexts = profile.getPatternContexts()).isEmpty()) {
            this.myPatternContext = contexts.get(0);
        }
        this.myFileTypeChooser.setSelectedItem(this.myFileType, this.myDialect, this.myPatternContext);
        this.myFileTypeChooser.setFileTypeInfoConsumer(info -> {
            if (info == null) {
                this.myFileType = null;
                this.myDialect = null;
                this.myPatternContext = null;
            } else {
                this.myFileType = info.getFileType();
                this.myDialect = info.getDialect();
                this.myPatternContext = info.getContext();
            }
            this.myOptionsToolbar.updateActionsImmediately();
            this.myFilterPanel.setFileType(this.myFileType);
            String contextId = this.myPatternContext == null ? "" : this.myPatternContext.getId();
            StructuralSearchProfile profile1 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
            Document searchDocument = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, this.mySearchCriteriaEdit.getText(), profile1);
            searchDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.mySearchCriteriaEdit.setNewDocumentAndFileType((FileType)(this.myFileType == null ? PlainTextFileType.INSTANCE : this.myFileType), searchDocument);
            searchDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            Document replaceDocument = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, this.myReplaceCriteriaEdit.getText(), profile1);
            replaceDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.myReplaceCriteriaEdit.setNewDocumentAndFileType((FileType)(this.myFileType == null ? PlainTextFileType.INSTANCE : this.myFileType), replaceDocument);
            replaceDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            this.initValidation();
            this.updateOptions();
        });
        this.myFileTypeChooser.setUserActionFileTypeInfoConsumer(info -> this.myExistingTemplatesComponent.selectFileType(info.getText()));
        DumbAwareToggleAction showTemplatesAction = new DumbAwareToggleAction(SSRBundle.message("templates.button", new Object[0]), SSRBundle.message("templates.button.description", new Object[0]), AllIcons.Actions.PreviewDetails){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                return StructuralSearchDialog.this.isExistingTemplatesPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                StructuralSearchDialog.this.setExistingTemplatesPanelVisible(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        final Icon filterModifiedIcon = ExecutionUtil.getLiveIndicator((Icon)AllIcons.General.Filter);
        DumbAwareToggleAction filterAction = new DumbAwareToggleAction(SSRBundle.message("filter.button", new Object[0]), SSRBundle.message("filter.button.description", new Object[0]), filterModifiedIcon){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                super.update(e);
                Presentation presentation = e.getPresentation();
                presentation.setIcon(StructuralSearchDialog.this.myFilterPanel.hasVisibleFilter() ? filterModifiedIcon : AllIcons.General.Filter);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                return StructuralSearchDialog.this.isFilterPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    7.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.setFilterPanelVisible(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myFilterPanel = new FilterPanel(this.getProject(), this.myFileType, this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        DumbAwareToggleAction pinAction = new DumbAwareToggleAction(SSRBundle.message("pin.button", new Object[0]), SSRBundle.message("pin.button.description", new Object[0]), AllIcons.General.Pin_tab){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                return StructuralSearchDialog.this.myPinned;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                StructuralSearchDialog.this.myPinned = state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.mySwitchAction = new SwitchAction();
        DefaultActionGroup optionsActionGroup = new DefaultActionGroup(new AnAction[]{this.myFileTypeChooser, showTemplatesAction, filterAction, new Separator(), pinAction, this.mySwitchAction});
        ActionManager actionManager = ActionManager.getInstance();
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)optionsActionGroup, true);
        this.myOptionsToolbar.setTargetComponent((JComponent)this.mySearchCriteriaEdit);
        this.myOptionsToolbar.setLayoutPolicy(0);
        this.myOptionsToolbar.setForceMinimumSize(true);
        JPanel searchEditorPanel = new JPanel(new GridBagLayout());
        this.myTargetComboBox = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)item -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(name).setPartOfSearchResults(name.equals(item));
            }
            this.initValidation();
        }));
        String text = SSRBundle.message("search.target.label", new Object[0]);
        JLabel searchTargetLabel = new JLabel(text);
        this.myTargetComboBox.setLabel(searchTargetLabel);
        this.myInjected = new JBCheckBox(SSRBundle.message("search.in.injected.checkbox", new Object[0]));
        this.myInjected.setOpaque(false);
        this.myInjected.addActionListener(e -> {
            this.myConfiguration.getMatchOptions().setSearchInjectedCode(this.myInjected.isSelected());
            this.initValidation();
        });
        this.myMatchCase = new JBCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]));
        this.myMatchCase.setOpaque(false);
        this.myMatchCase.addActionListener(e -> {
            this.myConfiguration.getMatchOptions().setCaseSensitiveMatch(this.myMatchCase.isSelected());
            this.initValidation();
        });
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchCriteriaEdit = this.createEditor(false);
        this.mySearchEditorPanel.setFirstComponent((JComponent)searchEditorPanel);
        this.myComponentsWithEditorBackground.add(searchEditorPanel);
        this.mySearchWrapper = new JPanel(new BorderLayout());
        this.mySearchWrapper.add((Component)this.mySearchEditorPanel, "Center");
        GridBag searchConstraint = new GridBag().setDefaultInsets(10, 10, 10, 0);
        searchEditorPanel.add((Component)this.mySearchCriteriaEdit, searchConstraint.nextLine().fillCell().coverLine().weightx(1.0).weighty(1.0).emptyInsets());
        searchEditorPanel.add((Component)searchTargetLabel, searchConstraint.nextLine());
        searchEditorPanel.add((Component)((Object)this.myTargetComboBox), searchConstraint);
        searchEditorPanel.add((Component)this.myInjected, searchConstraint);
        searchEditorPanel.add((Component)this.myMatchCase, searchConstraint.anchor(17).insetRight(10));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
        this.myComponentsWithEditorBackground.add((JComponent)this.myFilterPanel.getTable());
        JPanel searchPanel = new JPanel(new GridBagLayout());
        GridBag northConstraint = new GridBag().setDefaultWeightX(1.0).setDefaultInsets(6, 0, 6, 0);
        searchPanel.add((Component)searchTemplateLabel, northConstraint.nextLine().weightx(0.0).insetLeft(10));
        searchPanel.add((Component)this.myOptionsToolbar.getComponent(), northConstraint.anchor(13).insetRight(10));
        searchPanel.add((Component)this.mySearchWrapper, northConstraint.nextLine().coverLine().fillCell().emptyInsets().weighty(1.0));
        return searchPanel;
    }

    @NotNull
    private JComponent createReplacePanel() {
        JBLabel replacementTemplateLabel = new JBLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        this.myShortenFqn = new JBCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]));
        this.myShortenFqn.setOpaque(false);
        this.myShortenFqn.addActionListener(e -> this.myConfiguration.getReplaceOptions().setToShortenFQN(this.myShortenFqn.isSelected()));
        this.myStaticImport = new JBCheckBox(SSRBundle.message("use.static.import.checkbox", new Object[0]));
        this.myStaticImport.setOpaque(false);
        this.myStaticImport.addActionListener(e -> this.myConfiguration.getReplaceOptions().setToUseStaticImport(this.myStaticImport.isSelected()));
        this.myReformat = new JBCheckBox(SSRBundle.message("reformat.checkbox", new Object[0]));
        this.myReformat.setOpaque(false);
        this.myReformat.addActionListener(e -> this.myConfiguration.getReplaceOptions().setToReformatAccordingToStyle(this.myReformat.isSelected()));
        this.myReplaceCriteriaEdit = this.createEditor(true);
        this.myReplaceWrapper = new JPanel(new GridBagLayout());
        this.myComponentsWithEditorBackground.add(this.myReplaceWrapper);
        GridBag wrapperConstraint = new GridBag().setDefaultInsets(10, 10, 10, 0);
        this.myReplaceWrapper.add((Component)this.myReplaceCriteriaEdit, wrapperConstraint.nextLine().emptyInsets().fillCell().coverLine().weightx(1.0).weighty(1.0));
        this.myReplaceWrapper.add((Component)this.myShortenFqn, wrapperConstraint.nextLine());
        this.myReplaceWrapper.add((Component)this.myStaticImport, wrapperConstraint);
        this.myReplaceWrapper.add((Component)this.myReformat, wrapperConstraint.weightx(1.0).anchor(17));
        JPanel replacePanel = new JPanel(new GridBagLayout());
        GridBag replaceConstraint = new GridBag().setDefaultWeightX(1.0);
        replacePanel.add((Component)replacementTemplateLabel, replaceConstraint.nextLine().anchor(17).insets(16, 10, 14, 0));
        replacePanel.add((Component)this.myReplaceWrapper, replaceConstraint.nextLine().fillCell().weighty(1.0));
        JPanel jPanel = replacePanel;
        if (jPanel == null) {
            StructuralSearchDialog.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private void updateOptions() {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        TriConsumer initReplaceCheckbox = (checkBox, enabledAndVisible, selected) -> {
            checkBox.setEnabled(enabledAndVisible.booleanValue());
            checkBox.setVisible(enabledAndVisible.booleanValue());
            checkBox.setSelected(selected.booleanValue());
        };
        if (this.myInjected == null) {
            return;
        }
        this.myInjected.setSelected(this.myConfiguration.getMatchOptions().isSearchInjectedCode());
        this.myInjected.setVisible(!this.myEditConfigOnly);
        this.myMatchCase.setSelected(this.myConfiguration.getMatchOptions().isCaseSensitiveMatch());
        if (this.myShortenFqn == null) {
            return;
        }
        initReplaceCheckbox.accept((Object)this.myShortenFqn, (Object)(profile != null && profile.supportsShortenFQNames() ? 1 : 0), (Object)(this.myReplace && this.myConfiguration.getReplaceOptions().isToShortenFQN() ? 1 : 0));
        initReplaceCheckbox.accept((Object)this.myStaticImport, (Object)(profile != null && profile.supportsUseStaticImports() ? 1 : 0), (Object)(this.myReplace && this.myConfiguration.getReplaceOptions().isToUseStaticImport() ? 1 : 0));
        this.myReformat.setSelected(this.myReplace && this.myConfiguration.getReplaceOptions().isToReformatAccordingToStyle());
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        if (this.myEditConfigOnly) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.myOpenInNewTab = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.myOpenInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        panel.add((Component)this.myOpenInNewTab, "East");
        return panel;
    }

    private Project getProject() {
        return this.mySearchContext.getProject();
    }

    @Nullable
    public Point getInitialLocation() {
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension size = dimensionService.getSize(this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        if (size != null) {
            this.setSize(size.width, this.myEditConfigOnly ? size.height - this.myScopePanel.getPreferredSize().height : size.height);
        } else {
            this.pack();
            Dimension otherSize = dimensionService.getSize(this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY, this.getProject());
            if (otherSize != null) {
                this.setSize(otherSize.width, this.getSize().height);
            }
        }
        if (this.myEditConfigOnly) {
            return super.getInitialLocation();
        }
        Point location = dimensionService.getLocation(SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        return location == null ? super.getInitialLocation() : location;
    }

    public void show() {
        if (!this.myUseLastConfiguration) {
            this.setTextFromContext();
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        this.setFilterPanelVisible(properties.getBoolean(FILTERS_VISIBLE_STATE, true));
        this.setExistingTemplatesPanelVisible(properties.getBoolean(TEMPLATES_VISIBLE_STATE, true));
        this.myPinned = properties.getBoolean(PINNED_STATE, false);
        super.show();
    }

    private void startTemplate() {
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
        assert (psiFile != null);
        TemplateBuilder builder = StructuralSearchTemplateBuilder.getInstance().buildTemplate(psiFile);
        if (builder == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)SSRBundle.message("command.name.live.search.template.builder", new Object[0]), (String)"Structural Search", () -> builder.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true), (PsiFile[])new PsiFile[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeMatchHighlights();
    }

    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        if (!this.myPinned) {
            this.close(0);
        }
        this.removeMatchHighlights();
        this.myAlarm.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        if (this.myEditConfigOnly) {
            return;
        }
        SearchScope scope = this.myScopePanel.getScope();
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            FindInProjectSettings.getInstance((Project)this.getProject()).addDirectory(directoryScope.getDirectory().getPresentableUrl());
        }
        FindSettings.getInstance().setShowResultsInSeparateView(this.myOpenInNewTab.isSelected());
        ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
        this.startSearching();
    }

    public Configuration getConfiguration() {
        this.saveConfiguration();
        return this.myReplace ? new ReplaceConfiguration(this.myConfiguration) : new SearchConfiguration(this.myConfiguration);
    }

    private void removeMatchHighlights() {
        if (this.myEditConfigOnly || this.myRangeHighlighters.isEmpty()) {
            return;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.getProject();
            if (project.isDisposed()) {
                return;
            }
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter highlighter : this.myRangeHighlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo("");
            this.myRangeHighlighters.clear();
        });
    }

    private void addMatchHighlights() {
        if (this.myEditConfigOnly || DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        Project project = this.getProject();
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = (PsiFile)ReadAction.nonBlocking(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(document)).executeSynchronously();
        if (file == null) {
            return;
        }
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement)file, PredefinedSearchScopeProviderImpl.getCurrentFileScopeName()));
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        try {
            new Matcher(project, matchOptions).findMatches(sink);
            List<MatchResult> matches = sink.getMatches();
            this.removeMatchHighlights();
            this.addMatchHighlights(matches, editor, file, SSRBundle.message("status.bar.text.results.found.in.current.file", matches.size()));
        }
        catch (StructuralSearchException e) {
            this.reportMessage(e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", ""), true, (JComponent)this.mySearchCriteriaEdit);
            this.removeMatchHighlights();
        }
    }

    private void addMatchHighlights(@NotNull List<? extends MatchResult> matchResults, @NotNull Editor editor, @NotNull PsiFile file, @NlsContexts.StatusBarText @Nullable String statusBarText) {
        if (matchResults == null) {
            StructuralSearchDialog.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            StructuralSearchDialog.$$$reportNull$$$0(7);
        }
        if (file == null) {
            StructuralSearchDialog.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.getProject();
            if (project.isDisposed()) {
                return;
            }
            if (!matchResults.isEmpty()) {
                for (MatchResult result : matchResults) {
                    PsiElement match = result.getMatch();
                    if (match == null || match.getContainingFile() != file) continue;
                    int start = -1;
                    int end = -1;
                    if ("__multi_line__".equals(result.getName())) {
                        for (MatchResult child : result.getChildren()) {
                            int endOffset;
                            TextRange range = child.getMatch().getTextRange();
                            int startOffset = range.getStartOffset();
                            if (start == -1 || start > startOffset) {
                                start = startOffset;
                            }
                            if (end >= (endOffset = range.getEndOffset())) continue;
                            end = endOffset;
                        }
                    } else {
                        TextRange range = match.getTextRange();
                        start = range.getStartOffset();
                        end = range.getEndOffset();
                    }
                    HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                    highlightManager.addRangeHighlight(editor, start, end, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, this.myRangeHighlighters);
                }
                HighlightHandlerBase.setupFindModel((Project)project);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo(statusBarText);
        });
    }

    protected boolean continuousValidation() {
        return false;
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.POOLED_THREAD;
        if (threadToUse == null) {
            StructuralSearchDialog.$$$reportNull$$$0(9);
        }
        return threadToUse;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        JRootPane component = this.getRootPane();
        if (component == null) {
            List<ValidationInfo> list = Collections.emptyList();
            if (list == null) {
                StructuralSearchDialog.$$$reportNull$$$0(10);
            }
            return list;
        }
        SmartList errors = new SmartList();
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        try {
            Project project = this.getProject();
            CompiledPattern compiledPattern = null;
            try {
                compiledPattern = PatternCompiler.compilePattern(project, matchOptions, true, !this.myEditConfigOnly && !this.myPerformAction);
            }
            catch (MalformedPatternException e) {
                this.removeMatchHighlights();
                if (!StringUtil.isEmptyOrSpaces((String)matchOptions.getSearchPattern())) {
                    String message = e.getMessage();
                    errors.add(new ValidationInfo(message == null ? SSRBundle.message("this.pattern.is.malformed.message", new Object[0]) : message, (JComponent)this.mySearchCriteriaEdit));
                }
            }
            catch (NoMatchFoundException | UnsupportedPatternException e) {
                this.removeMatchHighlights();
                errors.add(new ValidationInfo(e.getMessage(), (JComponent)this.mySearchCriteriaEdit));
            }
            if (this.myReplace) {
                try {
                    Replacer.checkReplacementPattern(this.getProject(), this.myConfiguration.getReplaceOptions());
                }
                catch (MalformedPatternException | UnsupportedPatternException e) {
                    errors.add(new ValidationInfo(e.getMessage(), (JComponent)this.myReplaceCriteriaEdit));
                }
            }
            this.initializeFilterPanel(compiledPattern);
            if (compiledPattern != null) {
                this.addMatchHighlights();
            } else {
                errors.add(new ValidationInfo(""));
            }
            ApplicationManager.getApplication().invokeLater(() -> this.setSearchTargets(this.myConfiguration.getMatchOptions()), ModalityState.stateForComponent((Component)component));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getInstance(StructuralSearchDialog.class).error((Throwable)e);
        }
        SmartList smartList = errors;
        if (smartList == null) {
            StructuralSearchDialog.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private void reportMessage(@NlsContexts.PopupContent @Nullable String message, boolean error, @NotNull JComponent component) {
        if (component == null) {
            StructuralSearchDialog.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            if (message == null) {
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, error ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myBalloon);
        }, ModalityState.stateForComponent((Component)component));
    }

    private void securityCheck() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        int scripts = 0;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint.getScriptCodeConstraint().length() <= 2) continue;
            ++scripts;
        }
        if (this.myConfiguration instanceof ReplaceConfiguration) {
            ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
            for (ReplacementVariableDefinition variableDefinition : replaceOptions.getVariableDefinitions()) {
                if (variableDefinition.getScriptCodeConstraint().length() <= 2) continue;
                ++scripts;
            }
        }
        if (scripts > 0) {
            NotificationGroupManager.getInstance().getNotificationGroup("Structural Search").createNotification(SSRBundle.message("import.template.script.warning.title", new Object[0]), SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName(), scripts), NotificationType.WARNING).notify(this.mySearchContext.getProject());
        }
    }

    public void showFilterPanel(String variableName) {
        this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
        this.setFilterPanelVisible(true);
        this.myConfiguration.setCurrentVariableName(variableName);
    }

    private void setFilterPanelVisible(boolean visible) {
        if (visible) {
            if (this.myFilterPanel.getVariable() == null) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            if (!this.isFilterPanelVisible()) {
                this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
            }
        } else if (this.isFilterPanelVisible()) {
            this.mySearchEditorPanel.setSecondComponent(null);
            this.myConfiguration.setCurrentVariableName(null);
        }
    }

    private boolean isFilterPanelVisible() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void setExistingTemplatesPanelVisible(boolean visible) {
        if (visible) {
            this.myMainSplitter.setFirstComponent(this.myExistingTemplatesComponent.getTemplatesPanel());
        } else {
            this.myMainSplitter.setFirstComponent(null);
        }
    }

    private boolean isExistingTemplatesPanelVisible() {
        return this.myMainSplitter.getFirstComponent() != null;
    }

    private void setSearchTargets(MatchOptions matchOptions) {
        ArrayList<String> names = new ArrayList<String>(matchOptions.getUsedVariableNames());
        Collections.sort(names);
        names.remove("__context__");
        names.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItems(names);
        this.myTargetComboBox.setEnabled(names.size() > 1);
        for (String name : names) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint == null || !constraint.isPartOfSearchResults()) continue;
            this.myTargetComboBox.setSelectedItem(name);
            return;
        }
        this.myTargetComboBox.setSelectedItem(SSRBundle.message("complete.match.variable.name", new Object[0]));
    }

    private boolean loadConfiguration(String text) {
        if (text == null) {
            return false;
        }
        try {
            Configuration configuration = ConfigurationUtil.fromXml(text);
            if (configuration == null) {
                return false;
            }
            if (configuration instanceof ReplaceConfiguration && !this.myReplace) {
                this.mySwitchAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.mySwitchAction, null, (String)"unknown", (DataContext)DataContext.EMPTY_CONTEXT));
            }
            this.loadConfiguration(configuration);
            this.securityCheck();
        }
        catch (JDOMException e) {
            this.reportMessage(SSRBundle.message("import.template.script.corrupted", new Object[0]) + "\n" + e.getMessage(), false, (JComponent)this.myOptionsToolbar);
        }
        return true;
    }

    public void loadConfiguration(Configuration configuration) {
        Configuration newConfiguration = this.createConfiguration(configuration);
        if (this.myUseLastConfiguration) {
            newConfiguration.setUuid(this.myConfiguration.getUuid());
            newConfiguration.setName(this.myConfiguration.getName());
            newConfiguration.setDescription(this.myConfiguration.getDescription());
            newConfiguration.setSuppressId(this.myConfiguration.getSuppressId());
            newConfiguration.setProblemDescriptor(this.myConfiguration.getProblemDescriptor());
        }
        this.myConfiguration = newConfiguration;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.setSearchTargets(matchOptions);
        if (!this.myEditConfigOnly) {
            SearchScope scope = matchOptions.getScope();
            this.myScopePanel.setScopesFromContext(scope);
            if (this.myUseLastConfiguration) {
                this.myScopePanel.setScope(scope);
            }
        }
        this.myFileTypeChooser.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor searchEditor = this.mySearchCriteriaEdit.getEditor();
        if (searchEditor != null) {
            searchEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        this.setEditorContent(false, matchOptions.getSearchPattern());
        if (this.myReplace) {
            Editor replaceEditor = this.myReplaceCriteriaEdit.getEditor();
            if (replaceEditor != null) {
                replaceEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
            }
            if (configuration instanceof ReplaceConfiguration) {
                ReplaceOptions replaceOptions = configuration.getReplaceOptions();
                this.setEditorContent(true, replaceOptions.getReplacement());
            } else {
                this.setEditorContent(true, matchOptions.getSearchPattern());
            }
        }
        this.updateOptions();
    }

    private void setEditorContent(boolean replace, String text) {
        this.myChangedConfiguration = true;
        UIUtil.setContent(replace ? this.myReplaceCriteriaEdit : this.mySearchCriteriaEdit, text);
        this.myChangedConfiguration = false;
    }

    private void saveConfiguration() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.myEditConfigOnly) {
            SearchScope scope = this.myScopePanel.getScope();
            boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(scope.getDisplayName());
            matchOptions.setScope((SearchScope)(searchWithinHierarchy && !this.myPerformAction ? GlobalSearchScope.projectScope((Project)this.getProject()) : scope));
        } else {
            matchOptions.setScope(null);
        }
        if (this.myFileType != null) {
            matchOptions.setFileType(this.myFileType);
        }
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myPatternContext);
        matchOptions.setSearchPattern(this.getPattern(this.mySearchCriteriaEdit));
        matchOptions.setRecursiveSearch(!this.myReplace);
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
            replaceOptions.setReplacement(this.getPattern(this.myReplaceCriteriaEdit));
            properties.setValue(SHORTEN_FQN_STATE, replaceOptions.isToShortenFQN());
            properties.setValue(USE_STATIC_IMPORT_STATE, replaceOptions.isToUseStaticImport());
            properties.setValue(REFORMAT_STATE, replaceOptions.isToReformatAccordingToStyle());
        }
    }

    private String getPattern(EditorTextField textField) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile != null) {
            Document document = textField.getDocument();
            String pattern = (String)ReadAction.nonBlocking(() -> {
                PsiFile file = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
                assert (file != null);
                return profile.getCodeFragmentText(file);
            }).executeSynchronously();
            return pattern.isEmpty() ? textField.getText() : pattern;
        }
        return textField.getText();
    }

    @Nullable
    protected final String getDimensionServiceKey() {
        return null;
    }

    public void dispose() {
        this.getProject().putUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION, (Object)this.myConfiguration);
        this.storeDimensions();
        if (this.mySearchEditorPanel != null) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            properties.setValue(FILTERS_VISIBLE_STATE, this.isFilterPanelVisible(), true);
            properties.setValue(TEMPLATES_VISIBLE_STATE, this.isExistingTemplatesPanelVisible(), true);
            properties.setValue(PINNED_STATE, this.myPinned);
        }
        StructuralSearchPlugin.getInstance(this.getProject()).setDialog(null);
        this.myAlarm.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        this.removeRestartHighlightingListenerFromCurrentEditor();
        super.dispose();
    }

    private void storeDimensions() {
        if (this.myEditConfigOnly) {
            return;
        }
        String key1 = this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY;
        String key2 = this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY;
        Point location = this.getLocation();
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        DimensionService dimensionService = DimensionService.getInstance();
        dimensionService.setLocation(SEARCH_DIMENSION_SERVICE_KEY, location, this.getProject());
        Dimension size = this.getSize();
        dimensionService.setSize(key1, size, this.getProject());
        Dimension otherSize = dimensionService.getSize(key2, this.getProject());
        if (otherSize != null && otherSize.width != size.width) {
            otherSize.width = size.width;
            dimensionService.setSize(key2, otherSize, this.getProject());
        }
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    private void updateColors() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myComponentsWithEditorBackground.forEach(component -> component.setBackground(scheme.getDefaultBackground()));
        Border borderTopBottom = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)1, (int)0, (int)1, (int)0);
        if (this.myEditConfigOnly) {
            Border borderTopOnly = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)1, (int)0, (int)0, (int)0);
            if (this.mySearchWrapper != null) {
                this.mySearchWrapper.setBorder(this.myReplace ? borderTopBottom : borderTopOnly);
            }
            if (this.myReplaceWrapper != null) {
                this.myReplaceWrapper.setBorder(borderTopOnly);
            }
        } else {
            if (this.mySearchWrapper != null) {
                this.mySearchWrapper.setBorder(borderTopBottom);
            }
            if (this.myReplaceWrapper != null) {
                this.myReplaceWrapper.setBorder(borderTopBottom);
            }
        }
        this.myExistingTemplatesComponent.updateColors();
    }

    private void exportToClipboard() {
        CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(ConfigurationUtil.toXml(this.getConfiguration())));
    }

    private void importFromClipboard() {
        String contents = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (!this.loadConfiguration(contents)) {
            this.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, (JComponent)this.myOptionsToolbar);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacePanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationThreadToUse";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMatchHighlights";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditorTextField
    extends EditorTextField {
        private final boolean myReplace;

        MyEditorTextField(Document document, boolean replace) {
            super(document, StructuralSearchDialog.this.getProject(), (FileType)StructuralSearchDialog.this.myFileType, false, false);
            this.myReplace = replace;
        }

        @NotNull
        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
            if (profile != null) {
                TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)UIUtil.getTemplateContextType(profile));
            }
            SubstitutionShortInfoHandler.install((Editor)editor, StructuralSearchDialog.this.myFilterPanel, variableName -> {
                if (variableName.endsWith("$replacement")) {
                    variableName = StringUtil.trimEnd((String)variableName, (String)"$replacement");
                    assert (StructuralSearchDialog.this.myConfiguration instanceof ReplaceConfiguration);
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddReplacementVariable(variableName, StructuralSearchDialog.this.myConfiguration));
                } else {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, StructuralSearchDialog.this.myConfiguration));
                }
                if (StructuralSearchDialog.this.isFilterPanelVisible()) {
                    StructuralSearchDialog.this.myConfiguration.setCurrentVariableName((String)variableName);
                }
            }, StructuralSearchDialog.this.myDisposable, this.myReplace);
            editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
            this.getDocument().putUserData(STRUCTURAL_SEARCH_ERROR_CALLBACK, () -> {
                if (this.getClientProperty("JComponent.outline") == null) {
                    StructuralSearchDialog.this.initValidation();
                }
            });
            TextCompletionUtil.installCompletionHint((EditorEx)editor);
            editor.putUserData(STRUCTURAL_SEARCH_DIALOG, (Object)StructuralSearchDialog.this);
            editor.setEmbeddedIntoDialogWrapper(true);
            EditorEx editorEx = editor;
            if (editorEx == null) {
                MyEditorTextField.$$$reportNull$$$0(0);
            }
            return editorEx;
        }

        protected void updateBorder(@NotNull EditorEx editor) {
            if (editor == null) {
                MyEditorTextField.$$$reportNull$$$0(1);
            }
            this.setupBorder(editor);
            JScrollPane scrollPane = editor.getScrollPane();
            scrollPane.setBorder(new ErrorBorder(scrollPane.getBorder()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$MyEditorTextField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$MyEditorTextField";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBorder";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        SwitchAction() {
            this.init();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchAction.$$$reportNull$$$0(0);
            }
            StructuralSearchDialog.this.storeDimensions();
            StructuralSearchDialog.this.myReplace = !StructuralSearchDialog.this.myReplace;
            StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
            StructuralSearchDialog.this.myReplacePanel.setVisible(StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.updateColors();
            StructuralSearchDialog.this.setUseLastConfiguration(true);
            StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
            Dimension size = DimensionService.getInstance().getSize(StructuralSearchDialog.this.myReplace ? StructuralSearchDialog.REPLACE_DIMENSION_SERVICE_KEY : StructuralSearchDialog.SEARCH_DIMENSION_SERVICE_KEY, e.getProject());
            if (size != null) {
                StructuralSearchDialog.this.setSize(StructuralSearchDialog.this.getSize().width, size.height);
            } else {
                StructuralSearchDialog.this.pack();
            }
            this.init();
        }

        private void init() {
            this.getTemplatePresentation().setText(SSRBundle.messagePointer(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet searchShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet replaceShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet shortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{searchShortcutSet, replaceShortcutSet}) : new CompositeShortcutSet(new ShortcutSet[]{replaceShortcutSet, searchShortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)shortcutSet, StructuralSearchDialog.this.getRootPane());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction", "actionPerformed"));
        }
    }

    private static class ErrorBorder
    implements Border {
        private final Border myErrorBorder;

        ErrorBorder(Border errorBorder) {
            this.myErrorBorder = errorBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            EditorTextField editorTextField = (EditorTextField)ComponentUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            Object object = editorTextField.getClientProperty((Object)"JComponent.outline");
            if ("error".equals(object) || "warning".equals(object)) {
                this.myErrorBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myErrorBorder.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

