/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import java.util.UUID;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class SingleUseDaemonClient
extends DaemonClient {
    public static final String MESSAGE = "To honour the JVM settings for this build a single-use Daemon process will be forked.";
    private static final Logger LOGGER = Logging.getLogger(SingleUseDaemonClient.class);
    private final DocumentationRegistry documentationRegistry;

    public SingleUseDaemonClient(DaemonConnector connector, OutputEventListener outputEventListener, ExplainingSpec<DaemonContext> compatibilitySpec, InputStream buildStandardInput, ExecutorFactory executorFactory, IdGenerator<UUID> idGenerator, DocumentationRegistry documentationRegistry, ProcessEnvironment processEnvironment) {
        super(connector, outputEventListener, compatibilitySpec, buildStandardInput, executorFactory, idGenerator, processEnvironment);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters parameters, BuildRequestContext buildRequestContext) {
        LOGGER.lifecycle("To honour the JVM settings for this build a single-use Daemon process will be forked. See {}.", new Object[]{this.documentationRegistry.getDocumentationFor("gradle_daemon", "sec:disabling_the_daemon")});
        DaemonClientConnection daemonConnection = this.getConnector().startSingleUseDaemon();
        Build build = new Build((UUID)this.getIdGenerator().generateId(), daemonConnection.getDaemon().getToken(), action, buildRequestContext.getClient(), buildRequestContext.getStartTime(), buildRequestContext.isInteractive(), parameters);
        return this.executeBuild(build, daemonConnection, buildRequestContext.getCancellationToken(), buildRequestContext.getEventConsumer());
    }
}

