/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.GetterFieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GetterProcessor
extends AbstractClassProcessor {
    public GetterProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Getter");
    }

    private GetterFieldProcessor getGetterFieldProcessor() {
        return (GetterFieldProcessor)ApplicationManager.getApplication().getService(GetterFieldProcessor.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        boolean result;
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GetterProcessor.$$$reportNull$$$0(2);
        }
        boolean bl = result = this.validateAnnotationOnRightType(psiClass, builder) && this.validateVisibility(psiAnnotation);
        if (PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "lazy", false)) {
            builder.addWarning(LombokBundle.message("inspection.message.lazy.not.supported.for.getter.on.type", new Object[0]));
        }
        return result;
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            GetterProcessor.$$$reportNull$$$0(4);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            builder.addError(LombokBundle.message("inspection.message.getter.only.supported.on.class.enum.or.field.type", new Object[0]));
            result = false;
        }
        return result;
    }

    private boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(5);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        String methodVisibility;
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(6);
        }
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(7);
        }
        if (target == null) {
            GetterProcessor.$$$reportNull$$$0(8);
        }
        if ((methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null) {
            target.addAll(this.createFieldGetters(psiClass, methodVisibility));
        }
    }

    @NotNull
    public Collection<PsiMethod> createFieldGetters(@NotNull PsiClass psiClass, @NotNull String methodModifier) {
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(9);
        }
        if (methodModifier == null) {
            GetterProcessor.$$$reportNull$$$0(10);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        Collection<PsiField> getterFields = this.filterGetterFields(psiClass);
        GetterFieldProcessor fieldProcessor = this.getGetterFieldProcessor();
        for (PsiField getterField : getterFields) {
            result.add(fieldProcessor.createGetterMethod(getterField, psiClass, methodModifier));
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            GetterProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private Collection<PsiField> filterGetterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GetterProcessor.$$$reportNull$$$0(12);
        }
        ArrayList<PsiField> getterFields = new ArrayList<PsiField>();
        Collection<PsiMethod> classMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        this.filterToleratedElements(classMethods);
        GetterFieldProcessor fieldProcessor = this.getGetterFieldProcessor();
        for (PsiField psiField : psiClass.getFields()) {
            boolean createGetter = true;
            PsiModifierList modifierList = psiField.getModifierList();
            if (null != modifierList) {
                createGetter = !modifierList.hasModifierProperty("static");
                createGetter &= PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, fieldProcessor.getSupportedAnnotationClasses());
                createGetter &= !psiField.getName().startsWith("$");
                AccessorsInfo accessorsInfo = AccessorsInfo.build(psiField);
                Collection<String> methodNames = LombokUtils.toAllGetterNames(accessorsInfo, psiField.getName(), PsiType.BOOLEAN.equals((Object)psiField.getType()));
                for (String methodName : methodNames) {
                    createGetter &= !PsiMethodUtil.hasSimilarMethod(classMethods, methodName, 0);
                }
            }
            if (!createGetter) continue;
            getterFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = getterFields;
        if (arrayList == null) {
            GetterProcessor.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            GetterProcessor.$$$reportNull$$$0(14);
        }
        if (psiAnnotation == null) {
            GetterProcessor.$$$reportNull$$$0(15);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(this.filterGetterFields(containingClass)).contains(psiField.getName())) {
            return LombokPsiElementUsage.READ;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/GetterProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/GetterProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldGetters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filterGetterFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFieldGetters";
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterGetterFields";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

