/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.reporter;

import com.intellij.diagnostic.ReportMessages;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.PluginUpdateStatus;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.reporter.ITNReporterCompat;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter$WhenMappings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J?\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter;", "Lorg/jetbrains/kotlin/idea/reporter/ITNReporterCompat;", "()V", "hasLatestVersion", "", "hasUpdate", "showDialog", "", "parent", "Ljava/awt/Component;", "message", "", "title", "options", "", "defaultOptionIndex", "icon", "Ljavax/swing/Icon;", "(Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;ILjavax/swing/Icon;)I", "showErrorInRelease", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "submitCompat", "events", "additionalInfo", "parentComponent", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "([Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/util/Consumer;)Z", "Companion", "kotlin.idea"})
public final class KotlinReportSubmitter
extends ITNReporterCompat {
    private boolean hasUpdate;
    private boolean hasLatestVersion;
    private static final String KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY = "kotlin.fatal.error.notification";
    private static final String IDEA_FATAL_ERROR_NOTIFICATION_PROPERTY = "idea.fatal.error.notification";
    private static final String DISABLED_VALUE = "disabled";
    private static final String ENABLED_VALUE = "enabled";
    private static final String KOTLIN_PLUGIN_RELEASE_DATE = "kotlin.plugin.releaseDate";
    private static final Logger LOG;
    private static volatile ThreeState isFatalErrorReportingDisabledInRelease;
    private static final Lazy isIdeaAndKotlinRelease$delegate;
    private static final int NUMBER_OF_REPORTING_DAYS_FROM_RELEASE = 7;
    private static final Lazy RELEASE_DATE_FORMATTER$delegate;
    @NotNull
    public static final Companion Companion;

    public boolean showErrorInRelease(@NotNull IdeaLoggingEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$isApplicationInternalMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) {
            return true;
        }
        boolean $i$f$isUnitTestMode = false;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isUnitTestMode()) {
            return true;
        }
        if (this.hasUpdate) {
            return false;
        }
        boolean kotlinNotificationEnabled = Intrinsics.areEqual((Object)DISABLED_VALUE, (Object)System.getProperty(KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY, ENABLED_VALUE)) ^ true;
        if (!kotlinNotificationEnabled) {
            return false;
        }
        if (!KotlinReportSubmitter.Companion.isIdeaAndKotlinRelease()) {
            return true;
        }
        switch (KotlinReportSubmitter$WhenMappings.$EnumSwitchMapping$0[isFatalErrorReportingDisabledInRelease.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                if (!KotlinReportSubmitter.Companion.isFatalErrorReportingDisabledWithUpdate()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (!KotlinReportSubmitter.Companion.isFatalErrorReportingDisabledWithUpdate()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    public boolean submitCompat(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @Nullable Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> consumer2) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        if (this.hasUpdate) {
            boolean $i$f$isApplicationInternalMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isInternal()) {
                return super.submitCompat(events, additionalInfo, parentComponent, consumer2);
            }
            return true;
        }
        if (this.hasLatestVersion) {
            return super.submitCompat(events, additionalInfo, parentComponent, consumer2);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parentComponent));
        if (KotlinIdePlugin.INSTANCE.getHasPatchedVersion()) {
            ReportMessages.GROUP.createNotification(KotlinBundle.message("reporter.text.can.t.report.exception.from.patched.plugin", new Object[0]), NotificationType.INFORMATION).setImportant(false).notify(project2);
            return true;
        }
        KotlinPluginUpdater.Companion.getInstance().runUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)new Function1<PluginUpdateStatus, Boolean>(this, events, additionalInfo, parentComponent, consumer2){
            final /* synthetic */ KotlinReportSubmitter this$0;
            final /* synthetic */ IdeaLoggingEvent[] $events;
            final /* synthetic */ String $additionalInfo;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Consumer $consumer;

            public final boolean invoke(@NotNull PluginUpdateStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                if (status instanceof PluginUpdateStatus.Update) {
                    KotlinReportSubmitter.access$setHasUpdate$p(this.this$0, true);
                    boolean $i$f$isApplicationInternalMode = false;
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isInternal()) {
                        KotlinReportSubmitter.access$submitCompat$s1620081364(this.this$0, this.$events, this.$additionalInfo, this.$parentComponent, this.$consumer);
                    }
                    Object[] objectArray = new Object[2];
                    objectArray[0] = KotlinIdePlugin.INSTANCE.getVersion();
                    String string = ((PluginUpdateStatus.Update)status).getPluginDescriptor().getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"status.pluginDescriptor.version");
                    objectArray[1] = string;
                    int rc = this.this$0.showDialog(this.$parentComponent, KotlinBundle.message("reporter.message.text.you.re.running.kotlin.plugin.version", objectArray), KotlinBundle.message("reporter.title.update.kotlin.plugin", new Object[0]), new String[]{KotlinBundle.message("reporter.button.text.update", new Object[0]), KotlinBundle.message("reporter.button.text.ignore", new Object[0])}, 0, Messages.getInformationIcon());
                    if (rc == 0) {
                        KotlinPluginUpdater.installPluginUpdate$default(KotlinPluginUpdater.Companion.getInstance(), (PluginUpdateStatus.Update)status, null, null, null, 14, null);
                    }
                } else {
                    KotlinReportSubmitter.access$setHasLatestVersion$p(this.this$0, true);
                    KotlinReportSubmitter.access$submitCompat$s1620081364(this.this$0, this.$events, this.$additionalInfo, this.$parentComponent, this.$consumer);
                }
                return false;
            }
            {
                this.this$0 = kotlinReportSubmitter;
                this.$events = ideaLoggingEventArray;
                this.$additionalInfo = string;
                this.$parentComponent = component2;
                this.$consumer = consumer2;
                super(1);
            }
        }));
        return true;
    }

    public final int showDialog(@Nullable Component parent2, @Nls @NotNull String message2, @Nls @NotNull String title, @NotNull String[] options2, int defaultOptionIndex, @Nullable Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return parent2 != null ? Messages.showDialog((Component)parent2, (String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon2) : Messages.showDialog((String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon2);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinReportSubmitter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026ortSubmitter::class.java)");
        LOG = logger;
        isFatalErrorReportingDisabledInRelease = ThreeState.UNSURE;
        isIdeaAndKotlinRelease$delegate = LazyKt.lazy((Function0)Companion.isIdeaAndKotlinRelease.2.INSTANCE);
        RELEASE_DATE_FORMATTER$delegate = LazyKt.lazy((Function0)Companion.RELEASE_DATE_FORMATTER.2.INSTANCE);
    }

    public static final /* synthetic */ boolean access$getHasUpdate$p(KotlinReportSubmitter $this) {
        return $this.hasUpdate;
    }

    public static final /* synthetic */ void access$setHasUpdate$p(KotlinReportSubmitter $this, boolean bl) {
        $this.hasUpdate = bl;
    }

    public static final /* synthetic */ boolean access$submitCompat$s1620081364(KotlinReportSubmitter $this, IdeaLoggingEvent[] events, String additionalInfo, Component parentComponent, Consumer consumer2) {
        return super.submitCompat(events, additionalInfo, parentComponent, (Consumer<? super SubmittedReportInfo>)consumer2);
    }

    public static final /* synthetic */ boolean access$getHasLatestVersion$p(KotlinReportSubmitter $this) {
        return $this.hasLatestVersion;
    }

    public static final /* synthetic */ void access$setHasLatestVersion$p(KotlinReportSubmitter $this, boolean bl) {
        $this.hasLatestVersion = bl;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\u0012\u0010\u001e\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0002J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter$Companion;", "", "()V", "DISABLED_VALUE", "", "ENABLED_VALUE", "IDEA_FATAL_ERROR_NOTIFICATION_PROPERTY", "KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY", "KOTLIN_PLUGIN_RELEASE_DATE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NUMBER_OF_REPORTING_DAYS_FROM_RELEASE", "", "RELEASE_DATE_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getRELEASE_DATE_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "RELEASE_DATE_FORMATTER$delegate", "Lkotlin/Lazy;", "isFatalErrorReportingDisabledInRelease", "Lcom/intellij/util/ThreeState;", "isIdeaAndKotlinRelease", "", "()Z", "isIdeaAndKotlinRelease$delegate", "isFatalErrorReportingDisabled", "releaseDate", "Ljava/time/LocalDate;", "isFatalErrorReportingDisabledWithUpdate", "isFatalErrorReportingWithDefault", "readStoredPluginReleaseDate", "setupReportingFromRelease", "", "writePluginReleaseValue", "date", "kotlin.idea"})
    public static final class Companion {
        private final boolean isIdeaAndKotlinRelease() {
            Lazy lazy = isIdeaAndKotlinRelease$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            return (Boolean)lazy.getValue();
        }

        public final void setupReportingFromRelease() {
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                return;
            }
            if (!this.isIdeaAndKotlinRelease()) {
                return;
            }
            LocalDate currentPluginReleaseDate = this.readStoredPluginReleaseDate();
            if (currentPluginReleaseDate != null) {
                isFatalErrorReportingDisabledInRelease = this.isFatalErrorReportingDisabled(currentPluginReleaseDate) ? ThreeState.YES : ThreeState.NO;
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)setupReportingFromRelease.1.INSTANCE);
        }

        private final ThreeState isFatalErrorReportingWithDefault(LocalDate releaseDate) {
            return releaseDate != null ? (this.isFatalErrorReportingDisabled(releaseDate) ? ThreeState.YES : ThreeState.NO) : ThreeState.YES;
        }

        private final boolean isFatalErrorReportingDisabledWithUpdate() {
            LocalDate currentPluginReleaseDate = this.readStoredPluginReleaseDate();
            isFatalErrorReportingDisabledInRelease = this.isFatalErrorReportingWithDefault(currentPluginReleaseDate);
            return isFatalErrorReportingDisabledInRelease == ThreeState.YES;
        }

        private final boolean isFatalErrorReportingDisabled(LocalDate releaseDate) {
            return ChronoUnit.DAYS.between(releaseDate, LocalDate.now()) > (long)7;
        }

        private final DateTimeFormatter getRELEASE_DATE_FORMATTER() {
            Lazy lazy = RELEASE_DATE_FORMATTER$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            return (DateTimeFormatter)lazy.getValue();
        }

        private final LocalDate readStoredPluginReleaseDate() {
            String string = PropertiesComponent.getInstance().getValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE);
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertiesComponent.getI\u2026EASE_DATE) ?: return null");
            String pluginVersionToReleaseDate = string;
            LocalDate parsedDate2 = (LocalDate)((Function0)new Function0<LocalDate>(pluginVersionToReleaseDate){
                final /* synthetic */ String $pluginVersionToReleaseDate;

                @Nullable
                public final LocalDate invoke() {
                    LocalDate localDate;
                    List parts2 = StringsKt.split$default((CharSequence)this.$pluginVersionToReleaseDate, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                    if (parts2.size() != 2) {
                        return null;
                    }
                    String pluginVersion = (String)parts2.get(0);
                    if (Intrinsics.areEqual((Object)pluginVersion, (Object)KotlinIdePlugin.INSTANCE.getVersion()) ^ true) {
                        return null;
                    }
                    try {
                        String dateString = (String)parts2.get(1);
                        localDate = LocalDate.parse(dateString, org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter$Companion.access$getRELEASE_DATE_FORMATTER$p(KotlinReportSubmitter.Companion));
                    }
                    catch (DateTimeParseException e) {
                        localDate = null;
                    }
                    return localDate;
                }
                {
                    this.$pluginVersionToReleaseDate = string;
                    super(0);
                }
            }).invoke();
            if (parsedDate2 == null) {
                PropertiesComponent.getInstance().setValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE, null);
            }
            return parsedDate2;
        }

        private final void writePluginReleaseValue(LocalDate date) {
            String currentKotlinVersion = KotlinIdePlugin.INSTANCE.getVersion();
            String dateStr = this.getRELEASE_DATE_FORMATTER().format(date);
            PropertiesComponent.getInstance().setValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE, currentKotlinVersion + ":" + dateStr);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$writePluginReleaseValue(Companion $this, LocalDate date) {
            $this.writePluginReleaseValue(date);
        }

        public static final /* synthetic */ ThreeState access$isFatalErrorReportingWithDefault(Companion $this, LocalDate releaseDate) {
            return $this.isFatalErrorReportingWithDefault(releaseDate);
        }

        public static final /* synthetic */ DateTimeFormatter access$getRELEASE_DATE_FORMATTER$p(Companion $this) {
            return $this.getRELEASE_DATE_FORMATTER();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

