/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "createFixes", "", "Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection$SetVersionQuickFix;", "project", "Lorg/jetbrains/idea/maven/project/MavenProject;", "versionElement", "Lcom/intellij/util/xml/GenericDomValue;", "", "versions", "SetVersionQuickFix", "kotlin.maven"})
public final class DifferentMavenStdlibVersionInspection
extends DomElementsInspection<MavenDomProjectModel> {
    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        Object fixes2;
        Iterable $this$forEach$iv;
        Iterable $this$filterTo$iv$iv;
        String pluginVersion;
        Iterator it;
        void $this$mapTo$iv$iv;
        if (domFileElement == null || holder == null) {
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"domFileElement.file");
        XmlFile file2 = xmlFile;
        Module module2 = domFileElement.getModule();
        if (module2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"domFileElement.module ?: return");
        Module module3 = module2;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module3.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module3);
        if (mavenProject == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject, (String)"manager.findProject(module) ?: return");
        MavenProject project2 = mavenProject;
        List list2 = project2.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"project.findDependencies\u2026.KOTLIN_JAVA_STDLIB_NAME)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
            String string = v5.getVersion();
            collection.add(string);
        }
        List stdlibVersion = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        MavenPlugin mavenPlugin = project2.findPlugin("org.jetbrains.kotlin", "kotlin-maven-plugin");
        String string = pluginVersion = mavenPlugin != null ? mavenPlugin.getVersion() : null;
        if (pluginVersion == null || stdlibVersion.isEmpty() || Intrinsics.areEqual((Object)((String)CollectionsKt.singleOrNull((List)stdlibVersion)), (Object)pluginVersion)) {
            return;
        }
        PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        Iterable $this$filter$iv = pomFile2.findKotlinPlugins();
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        it = $this$filterTo$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            MavenDomPlugin it2 = (MavenDomPlugin)element$iv$iv;
            boolean bl = false;
            MavenDomPlugin mavenDomPlugin = it2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomPlugin, (String)"it");
            GenericDomValue genericDomValue = mavenDomPlugin.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"it.version");
            if (!(Intrinsics.areEqual((Object)genericDomValue.getStringValue(), (Object)((String)CollectionsKt.singleOrNull((List)stdlibVersion))) ^ true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<SetVersionQuickFix> list3;
            MavenDomPlugin plugin;
            block18: {
                block17: {
                    String element$iv$iv;
                    plugin = (MavenDomPlugin)element$iv;
                    boolean bl = false;
                    MavenDomPlugin mavenDomPlugin = plugin;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenDomPlugin, (String)"plugin");
                    GenericDomValue genericDomValue = mavenDomPlugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"plugin.version");
                    list3 = genericDomValue.getStringValue();
                    if (list3 == null) break block17;
                    String version2 = element$iv$iv = list3;
                    boolean bl2 = false;
                    GenericDomValue genericDomValue2 = plugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue2, (String)"plugin.version");
                    list3 = this.createFixes(project2, (GenericDomValue<String>)genericDomValue2, CollectionsKt.plus((Collection)stdlibVersion, (Object)version2));
                    if (list3 != null) break block18;
                }
                list3 = CollectionsKt.emptyList();
            }
            fixes2 = list3;
            DomElement domElement = (DomElement)plugin.getVersion();
            Object[] objectArray = new Object[2];
            GenericDomValue genericDomValue = plugin.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"plugin.version");
            objectArray[0] = genericDomValue;
            objectArray[1] = CollectionsKt.joinToString$default((Iterable)stdlibVersion, (CharSequence)",", (CharSequence)"", (CharSequence)"", (int)0, null, null, (int)56, null);
            String string2 = KotlinMavenBundle.message("version.different.plugin.library", objectArray);
            Collection $this$toTypedArray$iv = (Collection)fixes2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            SetVersionQuickFix[] setVersionQuickFixArray = thisCollection$iv.toArray(new SetVersionQuickFix[0]);
            Intrinsics.checkNotNull((Object)setVersionQuickFixArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            LocalQuickFix[] localQuickFixArray = setVersionQuickFixArray;
            holder.createProblem(domElement, HighlightSeverity.WARNING, string2, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
        $this$forEach$iv = PomFile.findDependencies$default(pomFile2, new MavenId("org.jetbrains.kotlin", "kotlin-stdlib", null), null, 2, null);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            MavenDomDependency it3 = (MavenDomDependency)element$iv$iv;
            boolean bl3 = false;
            GenericDomValue genericDomValue = it3.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"it.version");
            if (!(Intrinsics.areEqual((Object)genericDomValue.getStringValue(), (Object)pluginVersion) ^ true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<SetVersionQuickFix> list4;
            MavenDomDependency dependency;
            block20: {
                block19: {
                    String element$iv$iv;
                    dependency = (MavenDomDependency)element$iv;
                    boolean bl4 = false;
                    GenericDomValue genericDomValue = dependency.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"dependency.version");
                    list4 = genericDomValue.getStringValue();
                    if (list4 == null) break block19;
                    String version3 = element$iv$iv = list4;
                    boolean bl5 = false;
                    GenericDomValue genericDomValue3 = dependency.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)genericDomValue3, (String)"dependency.version");
                    list4 = this.createFixes(project2, (GenericDomValue<String>)genericDomValue3, CollectionsKt.listOf((Object[])new String[]{version3, pluginVersion}));
                    if (list4 != null) break block20;
                }
                list4 = CollectionsKt.emptyList();
            }
            fixes2 = list4;
            DomElement domElement = (DomElement)dependency.getVersion();
            Object[] objectArray = new Object[2];
            objectArray[0] = pluginVersion;
            GenericDomValue genericDomValue = dependency.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)genericDomValue, (String)"dependency.version");
            objectArray[1] = genericDomValue;
            String string3 = KotlinMavenBundle.message("version.different.plugin.library", objectArray);
            Collection $this$toTypedArray$iv = (Collection)fixes2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            SetVersionQuickFix[] setVersionQuickFixArray = thisCollection$iv.toArray(new SetVersionQuickFix[0]);
            Intrinsics.checkNotNull((Object)setVersionQuickFixArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            LocalQuickFix[] localQuickFixArray = setVersionQuickFixArray;
            holder.createProblem(domElement, HighlightSeverity.WARNING, string3, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<SetVersionQuickFix> createFixes(MavenProject project2, GenericDomValue<String> versionElement, List<String> versions) {
        Object object;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Object maxElem$iv;
        Object v0;
        Iterable $this$maxByOrNull$iv = versions;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                String p1 = (String)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)new MavenVersionComparable(p1);
                do {
                    Object e$iv = iterator$iv.next();
                    String p12 = (String)e$iv;
                    $i$a$-unknown-DifferentMavenStdlibVersionInspection$createFixes$bestVersion$1 = false;
                    Comparable v$iv = (Comparable)new MavenVersionComparable(p12);
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        String bestVersion = v0;
        if (Intrinsics.areEqual((Object)bestVersion, (Object)versionElement.getStringValue())) {
            return CollectionsKt.emptyList();
        }
        Set<Map.Entry<Object, Object>> set2 = project2.getProperties().entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"project.properties.entries");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        maxElem$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)bestVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = "${" + it.getKey() + "}";
            collection.add(object);
        }
        List properties2 = (List)destination$iv$iv;
        $this$map$iv = properties2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new SetVersionQuickFix(versionElement, (String)it, bestVersion);
            collection.add(object);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new SetVersionQuickFix(versionElement, bestVersion, null));
    }

    public DifferentMavenStdlibVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentMavenStdlibVersionInspection$SetVersionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "versionElement", "Lcom/intellij/util/xml/GenericDomValue;", "", "newVersion", "versionResolved", "(Lcom/intellij/util/xml/GenericDomValue;Ljava/lang/String;Ljava/lang/String;)V", "getNewVersion", "()Ljava/lang/String;", "getVersionElement", "()Lcom/intellij/util/xml/GenericDomValue;", "getVersionResolved", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class SetVersionQuickFix
    implements LocalQuickFix {
        @NotNull
        private final GenericDomValue<String> versionElement;
        @NotNull
        private final String newVersion;
        @Nullable
        private final String versionResolved;

        @NotNull
        public String getName() {
            String string = this.versionResolved;
            return string == null ? KotlinMavenBundle.message("fix.set.version.name", this.newVersion) : KotlinMavenBundle.message("fix.set.version.name1", this.newVersion, this.versionResolved);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.set.version.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.versionElement.setValue((Object)this.newVersion);
        }

        @NotNull
        public final GenericDomValue<String> getVersionElement() {
            return this.versionElement;
        }

        @NotNull
        public final String getNewVersion() {
            return this.newVersion;
        }

        @Nullable
        public final String getVersionResolved() {
            return this.versionResolved;
        }

        public SetVersionQuickFix(@NotNull GenericDomValue<String> versionElement, @NotNull String newVersion, @Nullable String versionResolved) {
            Intrinsics.checkNotNullParameter(versionElement, (String)"versionElement");
            Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
            this.versionElement = versionElement;
            this.newVersion = newVersion;
            this.versionResolved = versionResolved;
        }
    }
}

