/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.FloatingPointLiteralPrecisionQuickFix;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.stubs.ConstantValueKind;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/FloatingPointLiteralPrecisionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "FLOAT_LITERAL", "Lorg/jetbrains/kotlin/psi/stubs/elements/KtConstantExpressionElementType;", "FORMATTING_CHARACTERS_REGEX", "Lkotlin/text/Regex;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class FloatingPointLiteralPrecisionInspection
extends AbstractKotlinInspection {
    private final KtConstantExpressionElementType FLOAT_LITERAL = KtConstantExpressionElementType.Companion.kindToConstantElementType(ConstantValueKind.FLOAT_CONSTANT);
    private final Regex FORMATTING_CHARACTERS_REGEX = new Regex("[_fF]");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.expressionVisitor((Function1)((Function1)new Function1<KtExpression, Unit>(this, holder){
            final /* synthetic */ FloatingPointLiteralPrecisionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final void invoke(@NotNull KtExpression it) {
                block11: {
                    block13: {
                        block12: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (!(it instanceof KtConstantExpression) || !Intrinsics.areEqual((Object)((KtConstantExpression)it).getElementType(), (Object)FloatingPointLiteralPrecisionInspection.access$getFLOAT_LITERAL$p(this.this$0))) break block11;
                            v0 = KtDfaHelpersKt.getKotlinType(it);
                            v1 = isFloat = v0 != null ? TypeUtilsKt.isFloat((KotlinType)v0) : false;
                            if (!isFloat) ** GOTO lbl-1000
                            v2 = ((KtConstantExpression)it).getText();
                            if (v2 != null ? StringsKt.endsWith$default((CharSequence)v2, (char)'F', (boolean)false, (int)2, null) : false) {
                                v3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = uppercaseSuffix = false;
                            }
                            if ((v4 = ((KtConstantExpression)it).getText()) == null) break block12;
                            var5_4 = v4;
                            var6_6 /* !! */  = FloatingPointLiteralPrecisionInspection.access$getFORMATTING_CHARACTERS_REGEX$p(this.this$0);
                            v4 = var6_6 /* !! */ .replace(var5_4, var7_7 = "");
                            if (v4 != null) break block13;
                        }
                        return;
                    }
                    literal = v4;
                    try {
                        if (isFloat) {
                            var6_6 /* !! */  = literal;
                            v5 = String.valueOf(Float.parseFloat((String)var6_6 /* !! */ ));
                        } else {
                            var6_6 /* !! */  = literal;
                            v5 = String.valueOf(Double.parseDouble((String)var6_6 /* !! */ ));
                        }
                        parseResult = v5;
                        roundedValue = new BigDecimal(parseResult);
                        exactValue = new BigDecimal(literal);
                        if (exactValue.compareTo(roundedValue) != 0) {
                            replacementText = isFloat != false ? parseResult + (uppercaseSuffix != false ? "F" : "f") : parseResult;
                            this.$holder.registerProblem((PsiElement)it, KotlinBundle.message("floating.point.literal.precision.inspection", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new FloatingPointLiteralPrecisionQuickFix(replacementText)});
                        }
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
            }
            {
                this.this$0 = floatingPointLiteralPrecisionInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ KtConstantExpressionElementType access$getFLOAT_LITERAL$p(FloatingPointLiteralPrecisionInspection $this) {
        return $this.FLOAT_LITERAL;
    }

    public static final /* synthetic */ Regex access$getFORMATTING_CHARACTERS_REGEX$p(FloatingPointLiteralPrecisionInspection $this) {
        return $this.FORMATTING_CHARACTERS_REGEX;
    }
}

