/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.utils.DebugInfoUtil;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.highlighter.AbstractBindingContextAwareHighlightingPassBase;
import org.jetbrains.kotlin.idea.highlighter.DebugInfoHighlightingPass;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass;", "Lorg/jetbrains/kotlin/idea/highlighter/AbstractBindingContextAwareHighlightingPassBase;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "annotator", "Lcom/intellij/lang/annotation/Annotator;", "getAnnotator", "()Lcom/intellij/lang/annotation/Annotator;", "DebugInfoAnnotator", "Factory", "Registrar", "kotlin.core"})
public final class DebugInfoHighlightingPass
extends AbstractBindingContextAwareHighlightingPassBase {
    @Override
    @NotNull
    protected Annotator getAnnotator() {
        return new DebugInfoAnnotator();
    }

    public DebugInfoHighlightingPass(@NotNull KtFile file2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(file2, document);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$DebugInfoAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "(Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass;)V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "kotlin.core"})
    private final class DebugInfoAnnotator
    implements Annotator {
        public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (element3 instanceof KtFile && !(element3 instanceof KtCodeFragment)) {
                var $fun$errorAnnotation$1 = new Function3<PsiElement, String, TextAttributesKey, Unit>(holder){
                    final /* synthetic */ AnnotationHolder $holder;

                    public final void invoke(@NotNull PsiElement expression2, @NotNull String message2, @Nullable TextAttributesKey textAttributes) {
                        AnnotationBuilder annotationBuilder;
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                        AnnotationBuilder it = annotationBuilder = this.$holder.newAnnotation(HighlightSeverity.ERROR, "[DEBUG] " + message2).range(expression2.getTextRange());
                        boolean bl = false;
                        TextAttributesKey textAttributesKey = textAttributes;
                        if (textAttributesKey != null) {
                            TextAttributesKey textAttributesKey2;
                            TextAttributesKey ta = textAttributesKey2 = textAttributesKey;
                            boolean bl2 = false;
                            it.textAttributes(ta);
                        }
                        annotationBuilder.create();
                    }

                    public static /* synthetic */ void invoke$default(annotate.1 var0, PsiElement psiElement2, String string, TextAttributesKey textAttributesKey, int n, Object object) {
                        if ((n & 4) != 0) {
                            textAttributesKey = KotlinHighlightingColors.DEBUG_INFO;
                        }
                        var0.invoke(psiElement2, string, textAttributesKey);
                    }
                    {
                        this.$holder = annotationHolder2;
                        super(3);
                    }
                };
                try {
                    DebugInfoUtil.INSTANCE.markDebugAnnotations(element3, DebugInfoHighlightingPass.this.bindingContext(), new DebugInfoUtil.DebugInfoReporter($fun$errorAnnotation$1){
                        final /* synthetic */ annotate.1 $errorAnnotation$1;

                        public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.$errorAnnotation$1.invoke((PsiElement)expression2, "Resolved to error element", KotlinHighlightingColors.RESOLVED_TO_ERROR);
                        }

                        public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            annotate.1.invoke$default(this.$errorAnnotation$1, (PsiElement)expression2, "Reference is not resolved to anything, but is not marked unresolved", null, 4, null);
                        }

                        public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
                            annotate.1.invoke$default(this.$errorAnnotation$1, (PsiElement)expression2, "Reference marked as unresolved is actually resolved to " + target2, null, 4, null);
                        }
                        {
                            this.$errorAnnotation$1 = $captured_local_variable$0;
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable e) {
                    $fun$errorAnnotation$1.invoke(element3, e.getClass().getCanonicalName() + ": " + e.getMessage(), null);
                    e.printStackTrace();
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Factory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.core"})
    public static final class Factory
    implements TextEditorHighlightingPassFactory {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (!(file2 instanceof KtFile)) return null;
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                boolean $i$f$isApplicationInternalMode = false;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isInternal()) return null;
                if (!KotlinIdePlugin.INSTANCE.isSnapshot()) {
                    if (!KotlinIdePlugin.INSTANCE.isDev()) return null;
                }
            }
            if (!ProjectRootsUtil.isInProjectOrLibSource$default((PsiElement)file2, false, 2, null)) return null;
            boolean bl = true;
            boolean useDebugInfoPass = bl;
            if (!useDebugInfoPass) return null;
            KtFile ktFile = (KtFile)file2;
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            TextEditorHighlightingPass textEditorHighlightingPass = new DebugInfoHighlightingPass(ktFile, document);
            return textEditorHighlightingPass;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new Factory(), new int[]{4}, null, false, -1);
        }
    }
}

