/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.similarity;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesProvider;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.findUsages.similarity.KotlinSimilarityFeaturesExtractor;
import org.jetbrains.kotlin.idea.findUsages.similarity.KotlinUsageSimilarityFeaturesProvider;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/similarity/KotlinUsageSimilarityFeaturesProvider;", "Lcom/intellij/usages/similarity/features/UsageSimilarityFeaturesProvider;", "()V", "getContext", "Lcom/intellij/psi/PsiElement;", "element", "getFeatures", "Lcom/intellij/usages/similarity/bag/Bag;", "usage", "isAvailable", "", "usageTarget", "Lcom/intellij/usages/PsiElementUsageTarget;", "kotlin.idea"})
public final class KotlinUsageSimilarityFeaturesProvider
implements UsageSimilarityFeaturesProvider {
    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public Bag getFeatures(@NotNull PsiElement usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Bag properties2 = new Bag();
        if (!Registry.is((String)"similarity.find.usages.kotlin.clustering.enable")) {
            return properties2;
        }
        PsiElement statement2 = this.getContext(usage);
        if (statement2 != null) {
            properties2.addAll(new KotlinSimilarityFeaturesExtractor(statement2).getFeatures());
        }
        return properties2;
    }

    @RequiresReadLock
    public boolean isAvailable(@NotNull PsiElementUsageTarget usageTarget) {
        Intrinsics.checkNotNullParameter((Object)usageTarget, (String)"usageTarget");
        return usageTarget.getElement() instanceof KtFunction;
    }

    @Nullable
    public final PsiElement getContext(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return PsiTreeUtil.findFirstParent((PsiElement)element3, (boolean)false, (Condition)getContext.1.INSTANCE);
    }
}

