/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinLambdaMethodFilterKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u0013*\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilter;", "Lcom/intellij/debugger/engine/BreakpointStepMethodFilter;", "lambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "callingExpressionLines", "Lcom/intellij/util/Range;", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaInfo;)V", "firstStatementPosition", "Lcom/intellij/debugger/SourcePosition;", "lambdaPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "lastStatementLine", "getBreakpointPosition", "getCallingExpressionLines", "getLastStatementLine", "isTargetLambdaName", "", "name", "", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "matchesExpression", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.jvm-debugger.core"})
public final class KotlinLambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final SmartPsiElementPointer<KtFunction> lambdaPtr;
    private final SourcePosition firstStatementPosition;
    private final int lastStatementLine;
    private final Range<Integer> callingExpressionLines;
    private final KotlinLambdaInfo lambdaInfo;

    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.firstStatementPosition;
    }

    public int getLastStatementLine() {
        return this.lastStatementLine;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        KtFunction ktFunction = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.lambdaPtr);
        if (ktFunction == null) {
            return true;
        }
        KtFunction lambda2 = ktFunction;
        if (this.lambdaInfo.isInline()) {
            return DebuggerUtilKt.isInsideInlineArgument(lambda2, location2, process2);
        }
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return true;
        }
        Method method2 = method;
        if (method2.isBridge()) {
            return false;
        }
        String string = method2.name();
        if (string == null) {
            return false;
        }
        String methodName2 = string;
        return this.isTargetLambdaName(methodName2) && this.matchesExpression(location2, process2, lambda2.getBodyExpression());
    }

    private final boolean matchesExpression(Location $this$matchesExpression, DebugProcessImpl process2, KtExpression bodyExpression) {
        SourcePosition sourcePosition2 = process2.getPositionManager().getSourcePosition($this$matchesExpression);
        if (sourcePosition2 == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"process.positionManager.\u2026tion(this) ?: return true");
        SourcePosition sourcePosition3 = sourcePosition2;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtBlockExpression>(sourcePosition3){
            final /* synthetic */ SourcePosition $sourcePosition;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final KtBlockExpression invoke() {
                void $this$parentOfType$iv;
                PsiElement psiElement2 = this.$sourcePosition.getElementAt();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"sourcePosition.elementAt");
                PsiElement psiElement3 = psiElement2;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                return (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtBlockExpression.class, (boolean)false);
            }
            {
                this.$sourcePosition = sourcePosition2;
                super(0);
            }
        });
        if (ktBlockExpression == null) {
            return true;
        }
        KtBlockExpression blockAt2 = ktBlockExpression;
        return blockAt2 == bodyExpression;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.lambdaInfo.isInline() ? new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)) : this.callingExpressionLines;
    }

    public final boolean isTargetLambdaName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String actualName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(name2, this.lambdaInfo.isNameMangledInBytecode());
        if (this.lambdaInfo.isSuspend()) {
            return Intrinsics.areEqual((Object)actualName, (Object)"invokeSuspend");
        }
        return Intrinsics.areEqual((Object)actualName, (Object)this.lambdaInfo.getMethodName()) || DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(actualName);
    }

    /*
     * WARNING - void declaration
     */
    public KotlinLambdaMethodFilter(@NotNull KtFunction lambda2, @Nullable Range<Integer> callingExpressionLines, @NotNull KotlinLambdaInfo lambdaInfo) {
        void firstPosition;
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)lambdaInfo, (String)"lambdaInfo");
        this.callingExpressionLines = callingExpressionLines;
        this.lambdaInfo = lambdaInfo;
        this.lambdaPtr = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)lambda2));
        Pair<SourcePosition, SourcePosition> pair = KotlinLambdaMethodFilterKt.findFirstAndLastStatementPositions((KtDeclarationWithBody)lambda2);
        SourcePosition sourcePosition2 = (SourcePosition)pair.component1();
        SourcePosition lastPosition = (SourcePosition)pair.component2();
        this.firstStatementPosition = firstPosition;
        SourcePosition sourcePosition3 = lastPosition;
        this.lastStatementLine = sourcePosition3 != null ? sourcePosition3.getLine() : -1;
    }
}

