/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.Location;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;

public class DebuggerSteppingHelper {
    public static DebugProcessImpl.ResumeCommand createStepOverCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final SourcePosition sourcePosition2) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0);
            }

            public void contextAction() {
                Location location2;
                StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                Location location3 = location2 = frameProxy == null ? null : SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                if (location2 != null) {
                    try {
                        KotlinSteppingCommandProviderKt.getStepOverAction(location2, sourcePosition2, suspendContext, frameProxy).createCommand(debugProcess, suspendContext, ignoreBreakpoints).contextAction(suspendContext);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                debugProcess.createStepOutCommand(suspendContext).contextAction();
            }
        };
    }

    public static DebugProcessImpl.ResumeCommand createStepOverCommandForSuspendSwitch(SuspendContextImpl suspendContext) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepOverCommand(debugProcessImpl, suspendContext, false, null, -1){
            {
                DebugProcessImpl debugProcessImpl = x0;
                Objects.requireNonNull(debugProcessImpl);
                super(debugProcessImpl, arg0, arg1, arg2, arg3);
            }

            @NotNull
            public RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, @Nullable RequestHint parentHint) {
                RequestHint hint = new RequestHint(stepThread, suspendContext, -1, 2, this.myMethodFilter, parentHint){

                    public int getNextStepDepth(SuspendContextImpl context2) {
                        StackFrameProxyImpl frameProxy = context2.getFrameProxy();
                        if (frameProxy != null && DebuggerUtilKt.isOnSuspensionPoint(frameProxy)) {
                            return 2;
                        }
                        return super.getNextStepDepth(context2);
                    }
                };
                hint.setIgnoreFilters(suspendContext.getDebugProcess().getSession().shouldIgnoreSteppingFilters());
                RequestHint requestHint = hint;
                if (requestHint == null) {
                    2.$$$reportNull$$$0(0);
                }
                return requestHint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/debugger/stepping/DebuggerSteppingHelper$2", "getHint"));
            }
        };
    }

    public static DebugProcessImpl.ResumeCommand createStepOutCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0);
            }

            public void contextAction() {
                Location location2;
                StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                Location location3 = location2 = frameProxy == null ? null : SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                if (location2 != null) {
                    try {
                        KotlinSteppingCommandProviderKt.getStepOutAction(location2, frameProxy).createCommand(debugProcess, suspendContext, ignoreBreakpoints).contextAction(suspendContext);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                debugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints).contextAction();
            }
        };
    }

    public static DebugProcessImpl.ResumeCommand createStepIntoCommand(final @NotNull SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final @Nullable MethodFilter methodFilter) {
        DebugProcessImpl debugProcess;
        if (suspendContext == null) {
            DebuggerSteppingHelper.$$$reportNull$$$0(0);
        }
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0);
            }

            public void contextAction() {
                try {
                    new KotlinStepAction.KotlinStepInto(methodFilter).createCommand(debugProcess, suspendContext, ignoreBreakpoints).contextAction(suspendContext);
                }
                catch (Exception e) {
                    debugProcess.createStepIntoCommand(suspendContext, ignoreBreakpoints, methodFilter).contextAction();
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "org/jetbrains/kotlin/idea/debugger/stepping/DebuggerSteppingHelper", "createStepIntoCommand"));
    }
}

