/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiMethod;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.builder.LightMemberOrigin;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\tH\u0002\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"getMethodDescriptorInReadActionInSmartMode", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint$MethodDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "document", "Lcom/intellij/openapi/editor/Document;", "resolveJvmMethodFromKotlinDeclaration", "Lcom/intellij/psi/PsiMethod;", "getMethodDescriptor", "getSourceOrigin", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "hasAppropriateKotlinOrigin", "", "kotlin.jvm-debugger.core"})
public final class KotlinFunctionBreakpointKt {
    @Nullable
    public static final MethodBreakpoint.MethodDescriptor getMethodDescriptor(@NotNull SourcePosition $this$getMethodDescriptor, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$getMethodDescriptor, (String)"$this$getMethodDescriptor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (MethodBreakpoint.MethodDescriptor)DumbService.getInstance((Project)project2).runReadActionInSmartMode(new Computable($this$getMethodDescriptor, project2){
            final /* synthetic */ SourcePosition $this_getMethodDescriptor;
            final /* synthetic */ Project $project;

            public final MethodBreakpoint.MethodDescriptor compute() {
                Object object;
                MethodBreakpoint.MethodDescriptor descriptor2;
                Document document = PsiDocumentManager.getInstance((Project)this.$project).getDocument(this.$this_getMethodDescriptor.getFile());
                if (document == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026eadActionInSmartMode null");
                Document document2 = document;
                MethodBreakpoint.MethodDescriptor methodDescriptor = descriptor2 = KotlinFunctionBreakpointKt.access$getMethodDescriptorInReadActionInSmartMode(this.$project, this.$this_getMethodDescriptor, document2);
                if (methodDescriptor != null) {
                    MethodBreakpoint.MethodDescriptor methodDescriptor2;
                    MethodBreakpoint.MethodDescriptor it = methodDescriptor2 = methodDescriptor;
                    boolean bl = false;
                    object = it.methodName != null && it.methodSignature != null ? methodDescriptor2 : null;
                } else {
                    object = null;
                }
                return object;
            }
            {
                this.$this_getMethodDescriptor = sourcePosition2;
                this.$project = project2;
            }
        });
    }

    private static final MethodBreakpoint.MethodDescriptor getMethodDescriptorInReadActionInSmartMode(Project project2, SourcePosition sourcePosition2, Document document) {
        PsiMethod psiMethod = KotlinFunctionBreakpointKt.resolveJvmMethodFromKotlinDeclaration(project2, sourcePosition2);
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        if (!KotlinFunctionBreakpointKt.hasAppropriateKotlinOrigin(method, sourcePosition2, document)) {
            return null;
        }
        return KotlinFunctionBreakpointKt.getMethodDescriptor(method);
    }

    private static final boolean hasAppropriateKotlinOrigin(PsiMethod $this$hasAppropriateKotlinOrigin, SourcePosition sourcePosition2, Document document) {
        KtLightMethod ktLightMethod;
        PsiMethod $this$safeAs$iv = $this$hasAppropriateKotlinOrigin;
        boolean $i$f$safeAs = false;
        PsiMethod psiMethod = $this$safeAs$iv;
        if (!(psiMethod instanceof KtLightMethod)) {
            psiMethod = null;
        }
        if ((ktLightMethod = (KtLightMethod)psiMethod) == null || (ktLightMethod = KotlinFunctionBreakpointKt.getSourceOrigin(ktLightMethod)) == null) {
            return true;
        }
        KtLightMethod kotlinOrigin = ktLightMethod;
        int offset2 = kotlinOrigin.getTextOffset();
        return DocumentUtil.isValidOffset((int)offset2, (Document)document) && document.getLineNumber(offset2) >= sourcePosition2.getLine();
    }

    private static final MethodBreakpoint.MethodDescriptor getMethodDescriptor(PsiMethod $this$getMethodDescriptor) {
        MethodBreakpoint.MethodDescriptor methodDescriptor;
        try {
            MethodBreakpoint.MethodDescriptor descriptor2 = new MethodBreakpoint.MethodDescriptor();
            descriptor2.methodName = JVMNameUtil.getJVMMethodName((PsiMethod)$this$getMethodDescriptor);
            descriptor2.methodSignature = JVMNameUtil.getJVMSignature((PsiMethod)$this$getMethodDescriptor);
            descriptor2.isStatic = $this$getMethodDescriptor.hasModifierProperty("static");
        }
        catch (IndexNotReadyException ignored) {
            methodDescriptor = null;
        }
        return methodDescriptor;
    }

    private static final KtDeclaration getSourceOrigin(KtLightMethod $this$getSourceOrigin) {
        LightMemberOrigin lightMemberOrigin = $this$getSourceOrigin.getLightMemberOrigin();
        if (lightMemberOrigin == null) {
            return null;
        }
        LightMemberOrigin lightMemberOrigin2 = lightMemberOrigin;
        KtDeclaration ktDeclaration = lightMemberOrigin2.getAuxiliaryOriginalElement();
        if (ktDeclaration == null) {
            ktDeclaration = lightMemberOrigin2.getOriginalElement();
        }
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration originalElement = ktDeclaration;
        KtDeclaration sourceOrigin = SourceNavigationHelper.INSTANCE.getNavigationElement(originalElement);
        if (sourceOrigin.getContainingFile() instanceof KtClsFile) {
            return null;
        }
        return sourceOrigin;
    }

    private static final PsiMethod resolveJvmMethodFromKotlinDeclaration(Project project2, SourcePosition sourcePosition2) {
        Object v4;
        block5: {
            KtDeclaration ktDeclaration = (KtDeclaration)PositionUtil.getPsiElementAt((Project)project2, KtDeclaration.class, (SourcePosition)sourcePosition2);
            if (ktDeclaration == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktDeclaration, (String)"PositionUtil.getPsiEleme\u2026ePosition) ?: return null");
            KtDeclaration declaration2 = ktDeclaration;
            if (declaration2 instanceof KtClass) {
                KtPrimaryConstructor constructor2 = ((KtClass)declaration2).getPrimaryConstructor();
                if (constructor2 == null) {
                    Object[] lightClass;
                    KtDeclaration $this$safeAs$iv = declaration2;
                    boolean $i$f$safeAs = false;
                    KtDeclaration ktDeclaration2 = $this$safeAs$iv;
                    if (!(ktDeclaration2 instanceof KtClassOrObject)) {
                        ktDeclaration2 = null;
                    }
                    KtClassOrObject ktClassOrObject = (KtClassOrObject)ktDeclaration2;
                    Object[] objectArray = lightClass = ktClassOrObject != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)ktClassOrObject) : null;
                    return lightClass != null && (objectArray = objectArray.getConstructors()) != null ? (PsiMethod)ArraysKt.firstOrNull((Object[])objectArray) : null;
                }
                declaration2 = (KtDeclaration)constructor2;
            }
            KtDeclaration originalDeclaration = SourceNavigationHelper.INSTANCE.getOriginalElement(declaration2);
            Iterable $this$firstIsInstanceOrNull$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)originalDeclaration));
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof PsiMethod)) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        return v4;
    }

    public static final /* synthetic */ MethodBreakpoint.MethodDescriptor access$getMethodDescriptorInReadActionInSmartMode(Project project2, SourcePosition sourcePosition2, Document document) {
        return KotlinFunctionBreakpointKt.getMethodDescriptorInReadActionInSmartMode(project2, sourcePosition2, document);
    }
}

