/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0019\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\f\u001a\u0014\u0010\r\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0001\u001a\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\f\u001a!\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0007\u00a8\u0006\u0014"}, d2={"containsLineBreakInRange", "", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getLineCount", "", "Lcom/intellij/psi/PsiElement;", "getLineCountInRange", "getLineEndOffset", "Lcom/intellij/psi/PsiFile;", "line", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "getLineNumber", "start", "getLineStartOffset", "skipWhitespace", "(Lcom/intellij/psi/PsiFile;IZ)Ljava/lang/Integer;", "isMultiLine", "isOneLiner", "kotlin.core"})
public final class PsiLinesUtilsKt {
    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $this$getLineStartOffset, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineStartOffset, (String)"$this$getLineStartOffset");
        return PsiLinesUtilsKt.getLineStartOffset($this$getLineStartOffset, line, true);
    }

    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $this$getLineStartOffset, int line, boolean skipWhitespace) {
        Document doc;
        Intrinsics.checkNotNullParameter((Object)$this$getLineStartOffset, (String)"$this$getLineStartOffset");
        FileViewProvider fileViewProvider = $this$getLineStartOffset.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            document = doc = PsiDocumentManager.getInstance((Project)$this$getLineStartOffset.getProject()).getDocument($this$getLineStartOffset);
        }
        if (doc != null && line >= 0 && line < doc.getLineCount()) {
            int startOffset = doc.getLineStartOffset(line);
            PsiElement psiElement2 = $this$getLineStartOffset.findElementAt(startOffset);
            if (psiElement2 == null) {
                return startOffset;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"findElementAt(startOffset) ?: return startOffset");
            PsiElement element3 = psiElement2;
            if (skipWhitespace && (element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment)) {
                PsiElement psiElement3 = PsiTreeUtil.skipSiblingsForward((PsiElement)element3, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                return psiElement3 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement3) : startOffset;
            }
            return startOffset;
        }
        return null;
    }

    @Nullable
    public static final Integer getLineEndOffset(@NotNull PsiFile $this$getLineEndOffset, int line) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$getLineEndOffset, (String)"$this$getLineEndOffset");
        FileViewProvider fileViewProvider = $this$getLineEndOffset.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"viewProvider");
        Document document2 = fileViewProvider.getDocument();
        if (document2 == null) {
            document2 = PsiDocumentManager.getInstance((Project)$this$getLineEndOffset.getProject()).getDocument($this$getLineEndOffset);
        }
        Document document3 = document = document2;
        return document3 != null ? Integer.valueOf(document3.getLineEndOffset(line)) : null;
    }

    public static final int getLineNumber(@NotNull PsiElement $this$getLineNumber, boolean start2) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$getLineNumber, (String)"$this$getLineNumber");
        PsiFile psiFile2 = $this$getLineNumber.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"containingFile");
        FileViewProvider fileViewProvider = psiFile2.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"containingFile.viewProvider");
        Document document2 = fileViewProvider.getDocument();
        if (document2 == null) {
            document2 = PsiDocumentManager.getInstance((Project)$this$getLineNumber.getProject()).getDocument($this$getLineNumber.getContainingFile());
        }
        Document document3 = document = document2;
        return document3 != null ? document3.getLineNumber(start2 ? PsiUtilsKt.getStartOffset((PsiElement)$this$getLineNumber) : PsiUtilsKt.getEndOffset((PsiElement)$this$getLineNumber)) : 0;
    }

    public static /* synthetic */ int getLineNumber$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return PsiLinesUtilsKt.getLineNumber(psiElement2, bl);
    }

    public static final int getLineCount(@NotNull PsiElement $this$getLineCount) {
        Document doc;
        Document document;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getLineCount, (String)"$this$getLineCount");
        PsiFile psiFile2 = $this$getLineCount.getContainingFile();
        if (psiFile2 != null) {
            object = psiFile2;
            PsiFile file2 = object;
            boolean bl = false;
            document = PsiDocumentManager.getInstance((Project)$this$getLineCount.getProject()).getDocument(file2);
        } else {
            document = doc = null;
        }
        if (doc != null) {
            TextRange spaceRange;
            TextRange textRange = $this$getLineCount.getTextRange();
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            TextRange textRange2 = spaceRange = textRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"spaceRange");
            if (textRange2.getEndOffset() <= doc.getTextLength() && spaceRange.getStartOffset() < spaceRange.getEndOffset()) {
                int startLine = doc.getLineNumber(spaceRange.getStartOffset());
                int endLine = doc.getLineNumber(spaceRange.getEndOffset());
                return endLine - startLine + 1;
            }
        }
        String string = $this$getLineCount.getText();
        if (string == null) {
            object = "Cannot count number of lines";
            throw new IllegalStateException(object.toString());
        }
        return StringUtil.getLineBreakCount((CharSequence)string) + 1;
    }

    public static final boolean isMultiLine(@NotNull PsiElement $this$isMultiLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiLine, (String)"$this$isMultiLine");
        return PsiLinesUtilsKt.getLineCount($this$isMultiLine) > 1;
    }

    public static final boolean isOneLiner(@NotNull PsiElement $this$isOneLiner) {
        Intrinsics.checkNotNullParameter((Object)$this$isOneLiner, (String)"$this$isOneLiner");
        return PsiLinesUtilsKt.getLineCount($this$isOneLiner) == 1;
    }

    public static final int getLineCountInRange(@NotNull Document $this$getLineCountInRange, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineCountInRange, (String)"$this$getLineCountInRange");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        int n = $this$getLineCountInRange.getLineNumber(textRange.getStartOffset()) - $this$getLineCountInRange.getLineNumber(textRange.getEndOffset());
        return Math.abs(n);
    }

    public static final boolean containsLineBreakInRange(@NotNull Document $this$containsLineBreakInRange, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)$this$containsLineBreakInRange, (String)"$this$containsLineBreakInRange");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return PsiLinesUtilsKt.getLineCountInRange($this$containsLineBreakInRange, textRange) != 0;
    }
}

