/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinAbstractHintsProvider;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinInlayHintToggleActionKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayHintToggleAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "hintTypes", "", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "[Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "lastOptionName", "", "findElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "kotlin.idea"})
public final class KotlinInlayHintToggleAction
implements IntentionAction,
HighPriorityAction {
    private final HintType[] hintTypes = new HintType[]{HintType.RANGES, HintType.PROPERTY_HINT, HintType.LOCAL_VARIABLE_HINT, HintType.FUNCTION_HINT, HintType.PARAMETER_TYPE_HINT, HintType.PARAMETER_HINT, HintType.LAMBDA_RETURN_EXPRESSION, HintType.LAMBDA_IMPLICIT_PARAMETER_RECEIVER, HintType.SUSPENDING_CALL};
    @IntentionName
    private String lastOptionName = "";

    @NotNull
    public String getText() {
        return this.lastOptionName;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("hints.types", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.lastOptionName = "";
        for (PsiElement element3 = this.findElement(editor2, file2); element3 != null; element3 = element3.getParent()) {
            for (HintType hintType : this.hintTypes) {
                Pair pair;
                if (!hintType.isApplicable(element3)) continue;
                Pair pair2 = KotlinInlayHintToggleActionKt.findSetting$default(hintType, project2, null, 4, null);
                if (pair2 == null) continue;
                Pair it = pair = pair2;
                boolean bl = false;
                boolean enabled2 = ((KotlinAbstractHintsProvider.HintsSettings)it.getSecond()).isEnabled(hintType);
                this.lastOptionName = enabled2 ? hintType.getHideDescription() : hintType.getShowDescription();
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        for (PsiElement element3 = this.findElement(editor2, file2); element3 != null; element3 = element3.getParent()) {
            for (HintType hintType : this.hintTypes) {
                if (!KotlinInlayHintToggleActionKt.toggleHintSetting$default(hintType, project2, element3, null, 8, null)) continue;
                return;
            }
        }
    }

    private final PsiElement findElement(Editor editor2, PsiFile file2) {
        PsiFile psiFile2 = file2;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset2 = caretModel.getOffset();
        return ktFile2.findElementAt(offset2 - 1);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

