/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayGroup;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.chain.AbstractCallChainHintsProvider;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeInsight.hints.InlayInfoDetail;
import org.jetbrains.kotlin.idea.codeInsight.hints.InlayInfoDetails;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinAbstractHintsProvider;
import org.jetbrains.kotlin.idea.parameterInfo.HintsTypeRenderer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0002H\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J,\u0010+\u001a\u00020,*\u00020\u00032\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0004H\u0014J\u000e\u00102\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0014J\f\u00103\u001a\u00020.*\u00020\u0002H\u0014J\u0016\u00104\u001a\u0004\u0018\u00010\u0003*\u00020.2\u0006\u00101\u001a\u00020\u0004H\u0014J\u000e\u00105\u001a\u0004\u0018\u00010.*\u00020.H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\t\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinCallChainHintsProvider;", "Lcom/intellij/codeInsight/hints/chain/AbstractCallChainHintsProvider;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "dotQualifiedClass", "Ljava/lang/Class;", "getDotQualifiedClass", "()Ljava/lang/Class;", "group", "Lcom/intellij/codeInsight/hints/InlayGroup;", "getGroup", "()Lcom/intellij/codeInsight/hints/InlayGroup;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/codeInsight/hints/chain/AbstractCallChainHintsProvider$Settings;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "previewText", "getPreviewText", "createFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "document", "Lcom/intellij/openapi/editor/Document;", "getCaseDescription", "case", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable$Case;", "getProperty", "getTypeComputationContext", "topmostDotQualifiedExpression", "isLanguageSupported", "", "language", "Lcom/intellij/lang/Language;", "getInlayPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "expression", "Lcom/intellij/psi/PsiElement;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "context", "getParentDotQualifiedExpression", "getReceiver", "getType", "skipParenthesesAndPostfixOperatorsDown", "kotlin.idea"})
public final class KotlinCallChainHintsProvider
extends AbstractCallChainHintsProvider<KtQualifiedExpression, KotlinType, BindingContext> {
    @NotNull
    private final SettingsKey<AbstractCallChainHintsProvider.Settings> key = new SettingsKey("kotlin.call.chains.hints");

    @NotNull
    public InlayGroup getGroup() {
        return InlayGroup.TYPES_GROUP;
    }

    @NotNull
    public String getPreviewText() {
        return "fun doSomething(list: List<Int>) {\n    list.filter { it % 2 == 0 }\n        .map { it * 2 }\n        .takeIf { list ->\n            list.all { it % 2 == 0 }\n        }\n        ?.map { \"item: $it\" }\n        ?.forEach { println(it) }\n}\n\nclass List<T> {\n    fun filter(pred: (T) -> Boolean) : List<T> = TODO()\n    fun <R> map(op: (T) -> R) : List<R> = TODO()\n    fun all(op: (T) -> Boolean) : Boolean = TODO()\n    fun forEach(op: (T) -> Unit) : Unit = TODO()\n}\nfun <T> T.takeIf(predicate: (T) -> Boolean): T? = TODO()";
    }

    @NotNull
    public String getDescription() {
        return KotlinBundle.message("inlay.kotlin.call.chains.hints", new Object[0]);
    }

    public boolean isLanguageSupported(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return Intrinsics.areEqual((Object)language2, (Object)KotlinLanguage.INSTANCE);
    }

    @NotNull
    public String getProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = KotlinBundle.INSTANCE.getMessage(key, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KotlinBundle.getMessage(key)");
        return string;
    }

    @Nullable
    public String getCaseDescription(@NotNull ImmediateConfigurable.Case case_) {
        Intrinsics.checkNotNullParameter((Object)case_, (String)"case");
        return case_.getExtendedDescription();
    }

    @NotNull
    public PsiFile createFile(@NotNull Project project2, @NotNull FileType fileType, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return (PsiFile)KotlinAbstractHintsProvider.Companion.createKtFile$kotlin_idea(project2, document, fileType);
    }

    @NotNull
    protected InlayPresentation getInlayPresentation(@NotNull KotlinType $this$getInlayPresentation, @NotNull PsiElement expression2, @NotNull PresentationFactory factory2, @NotNull Project project2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlayPresentation, (String)"$this$getInlayPresentation");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement2 = expression2;
        if (!(psiElement2 instanceof KtElement)) {
            psiElement2 = null;
        }
        KtElement ktElement = (KtElement)psiElement2;
        if (ktElement == null) {
            String string = "Only Kotlin psi are possible";
            throw new IllegalStateException(string.toString());
        }
        List<InlayInfoDetail> inlayInfoDetails = HintsTypeRenderer.Companion.getInlayHintsTypeRenderer$kotlin_idea(context2, ktElement).renderTypeIntoInlayInfo($this$getInlayPresentation);
        TextRange textRange = ((KtElement)expression2).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"expression.textRange");
        return KotlinAbstractHintsProvider.Companion.getInlayPresentationForInlayInfoDetails(expression2, null, new InlayInfoDetails(new InlayInfo("", textRange.getEndOffset()), inlayInfoDetails), factory2, project2, (InlayHintsProvider)this);
    }

    @NotNull
    protected BindingContext getTypeComputationContext(@NotNull KtQualifiedExpression topmostDotQualifiedExpression) {
        Intrinsics.checkNotNullParameter((Object)topmostDotQualifiedExpression, (String)"topmostDotQualifiedExpression");
        return ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)topmostDotQualifiedExpression, BodyResolveMode.PARTIAL_NO_ADDITIONAL);
    }

    @Nullable
    protected KotlinType getType(@NotNull PsiElement $this$getType, @NotNull BindingContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getType, (String)"$this$getType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement2 = $this$getType;
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement2;
        if (ktExpression == null) {
            return null;
        }
        KotlinType kotlinType = context2.getType(ktExpression);
        if (kotlinType != null) {
            KotlinType kotlinType2;
            KotlinType it = kotlinType2 = kotlinType;
            boolean bl = false;
            KotlinType kotlinType3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"it");
            object = !KotlinTypeKt.isError((KotlinType)kotlinType3) ? kotlinType2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    protected Class<KtQualifiedExpression> getDotQualifiedClass() {
        return KtQualifiedExpression.class;
    }

    @NotNull
    protected PsiElement getReceiver(@NotNull KtQualifiedExpression $this$getReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"$this$getReceiver");
        return (PsiElement)$this$getReceiver.getReceiverExpression();
    }

    @NotNull
    public SettingsKey<AbstractCallChainHintsProvider.Settings> getKey() {
        return this.key;
    }

    @Nullable
    protected KtQualifiedExpression getParentDotQualifiedExpression(@NotNull KtQualifiedExpression $this$getParentDotQualifiedExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getParentDotQualifiedExpression, (String)"$this$getParentDotQualifiedExpression");
        PsiElement expr = $this$getParentDotQualifiedExpression.getParent();
        while (expr instanceof KtPostfixExpression || expr instanceof KtParenthesizedExpression || expr instanceof KtArrayAccessExpression || expr instanceof KtCallExpression) {
            expr = expr.getParent();
        }
        PsiElement psiElement2 = expr;
        if (!(psiElement2 instanceof KtQualifiedExpression)) {
            psiElement2 = null;
        }
        return (KtQualifiedExpression)psiElement2;
    }

    @Nullable
    protected PsiElement skipParenthesesAndPostfixOperatorsDown(@NotNull PsiElement $this$skipParenthesesAndPostfixOperatorsDown) {
        Intrinsics.checkNotNullParameter((Object)$this$skipParenthesesAndPostfixOperatorsDown, (String)"$this$skipParenthesesAndPostfixOperatorsDown");
        PsiElement expr = $this$skipParenthesesAndPostfixOperatorsDown;
        while (true) {
            PsiElement psiElement2;
            PsiElement psiElement3;
            if ((psiElement3 = expr) instanceof KtPostfixExpression) {
                psiElement2 = (PsiElement)((KtPostfixExpression)expr).getBaseExpression();
            } else if (psiElement3 instanceof KtParenthesizedExpression) {
                psiElement2 = (PsiElement)((KtParenthesizedExpression)expr).getExpression();
            } else if (psiElement3 instanceof KtArrayAccessExpression) {
                psiElement2 = (PsiElement)((KtArrayAccessExpression)expr).getArrayExpression();
            } else {
                if (!(psiElement3 instanceof KtCallExpression)) break;
                psiElement2 = (PsiElement)((KtCallExpression)expr).getCalleeExpression();
            }
            expr = psiElement2;
        }
        return expr;
    }
}

