/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.ImplicitPackagePrefixCache;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService$checkPendingChanges$;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheServiceKt;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.NotNullableUserDataProperty;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u0003012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0015\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\"J\r\u0010#\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b$J\u0016\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\nJ\u0014\u0010(\u001a\u00020\f*\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J/\u0010+\u001a\u00020\u0018\"\u0004\b\u0000\u0010,*\b\u0012\u0004\u0012\u0002H,0-2\u0014\b\u0004\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u00020\u00180/H\u0082\bRs\u0010\u0005\u001ag\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b\u0012F\u0012D\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0006 \t*!\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0006\u0018\u00010\u0006\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/name/FqName;", "", "implicitPackagePrefixCache", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "pendingKtFileChanges", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "pendingVFileChanges", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "projectScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "useStrongMapForCaching", "checkPendingChanges", "", "clear", "dispose", "getImplicitPackagePrefix", "sourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "invalidateCacheForModuleSourceInfo", "moduleSourceInfo", "notifyPackageChange", "file", "notifyPackageChange$kotlin_core", "onTooComplexChange", "onTooComplexChange$kotlin_core", "packageExists", "packageFqName", "moduleInfo", "containedInOrContains", "root", "", "processPending", "T", "", "body", "Lkotlin/Function1;", "Companion", "PackageCacheBulkFileListener", "PackageCacheModuleRootListener", "kotlin.core"})
public final class PerModulePackageCacheService
implements Disposable {
    private final ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> cache;
    private final ImplicitPackagePrefixCache implicitPackagePrefixCache;
    private final boolean useStrongMapForCaching;
    private final Set<VFileEvent> pendingVFileChanges;
    private final Set<KtFile> pendingKtFileChanges;
    private final GlobalSearchScope projectScope;
    private final Project project;
    public static final int FULL_DROP_THRESHOLD = 1000;
    private static final Logger LOG;
    @NotNull
    private static final NotNullableUserDataProperty DEBUG_LOG_ENABLE_PerModulePackageCache$delegate;
    @NotNull
    public static final Companion Companion;

    public final void onTooComplexChange$kotlin_core() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clear() {
        PerModulePackageCacheService perModulePackageCacheService;
        PerModulePackageCacheService perModulePackageCacheService2 = perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService2) {
            boolean bl = false;
            this.pendingVFileChanges.clear();
            this.pendingKtFileChanges.clear();
            this.cache.clear();
            this.implicitPackagePrefixCache.clear$kotlin_core();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$kotlin_core(@NotNull VFileEvent file2) {
        PerModulePackageCacheService perModulePackageCacheService;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService2 = perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService2) {
            boolean bl = false;
            Collection collection = this.pendingVFileChanges;
            VFileEvent vFileEvent = file2;
            collection.add(vFileEvent);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$kotlin_core(@NotNull KtFile file2) {
        PerModulePackageCacheService perModulePackageCacheService;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService2 = perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService2) {
            boolean bl = false;
            Collection collection = this.pendingKtFileChanges;
            KtFile ktFile = file2;
            collection.add(ktFile);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void invalidateCacheForModuleSourceInfo(ModuleSourceInfo moduleSourceInfo) {
        PerModulePackageCacheServiceKt.debugIfEnabled$default(LOG, this.project, false, (Function0)new Function0<String>(moduleSourceInfo){
            final /* synthetic */ ModuleSourceInfo $moduleSourceInfo;

            @NotNull
            public final String invoke() {
                return "Invalidated cache for " + this.$moduleSourceInfo;
            }
            {
                this.$moduleSourceInfo = moduleSourceInfo;
                super(0);
            }
        }, 2, null);
        ConcurrentMap concurrentMap = (ConcurrentMap)this.cache.get(moduleSourceInfo.getModule());
        if (concurrentMap == null) {
            return;
        }
        ConcurrentMap perSourceInfoData = concurrentMap;
        ConcurrentMap concurrentMap2 = (ConcurrentMap)perSourceInfoData.get(moduleSourceInfo);
        if (concurrentMap2 == null) {
            return;
        }
        ConcurrentMap dataForSourceInfo = concurrentMap2;
        dataForSourceInfo.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkPendingChanges() {
        PerModulePackageCacheService perModulePackageCacheService;
        PerModulePackageCacheService perModulePackageCacheService2 = perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService2) {
            boolean bl = false;
            if (this.pendingVFileChanges.size() + this.pendingKtFileChanges.size() >= 1000) {
                this.onTooComplexChange$kotlin_core();
            } else {
                Collection $this$processPending$iv;
                Collection collection = this.pendingVFileChanges;
                PerModulePackageCacheService this_$iv = this;
                boolean $i$f$processPending = false;
                $this$processPending$iv.removeIf(new Predicate(this){
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.this$0 = perModulePackageCacheService;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean test(T value2) {
                        block11: {
                            try {
                                VFileEvent event = (VFileEvent)value2;
                                boolean bl = false;
                                VirtualFile virtualFile2 = event.getFile();
                                if (virtualFile2 == null) {
                                    break block11;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file ?: return@processPending");
                                VirtualFile vfile = virtualFile2;
                                if (vfile.isDirectory() || !vfile.isValid()) {
                                    Map map2 = PerModulePackageCacheService.access$getCache$p(this.this$0);
                                    Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                                    while (iterator.hasNext()) {
                                        boolean bl2;
                                        void module2;
                                        ConcurrentMap data;
                                        block12: {
                                            Map.Entry<K, V> entry;
                                            Map.Entry<K, V> entry2 = entry = iterator.next();
                                            map2 = (Module)entry2.getKey();
                                            entry2 = entry;
                                            data = (ConcurrentMap)entry2.getValue();
                                            void v1 = module2;
                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"module");
                                            String[] sourceRootUrls = ProjectUtil.getRootManager((Module)v1).getSourceRootUrls();
                                            Intrinsics.checkNotNullExpressionValue((Object)sourceRootUrls, (String)"sourceRootUrls");
                                            String[] $this$any$iv = sourceRootUrls;
                                            boolean $i$f$any = false;
                                            int n = $this$any$iv.length;
                                            for (int i = 0; i < n; ++i) {
                                                String element$iv;
                                                String url = element$iv = $this$any$iv[i];
                                                boolean bl3 = false;
                                                String string = url;
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
                                                if (!PerModulePackageCacheService.access$containedInOrContains(this.this$0, vfile, string)) continue;
                                                bl2 = true;
                                                break block12;
                                            }
                                            bl2 = false;
                                        }
                                        if (!bl2) continue;
                                        PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>((Module)module2){
                                            final /* synthetic */ Module $module;
                                            {
                                                this.$module = module2;
                                                super(0);
                                            }

                                            @NotNull
                                            public final String invoke() {
                                                return "Invalidated cache for " + this.$module;
                                            }
                                        }, 2, null);
                                        data.clear();
                                    }
                                } else {
                                    IdeaModuleInfo ideaModuleInfo;
                                    IdeaModuleInfo infoByVirtualFile = GetModuleInfoKt.getModuleInfoByVirtualFile(PerModulePackageCacheService.access$getProject$p(this.this$0), vfile);
                                    if (infoByVirtualFile == null || !(infoByVirtualFile instanceof ModuleSourceInfo)) {
                                        PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(vfile, infoByVirtualFile){
                                            final /* synthetic */ VirtualFile $vfile;
                                            final /* synthetic */ IdeaModuleInfo $infoByVirtualFile;
                                            {
                                                this.$vfile = virtualFile2;
                                                this.$infoByVirtualFile = ideaModuleInfo;
                                                super(0);
                                            }

                                            @NotNull
                                            public final String invoke() {
                                                return "Skip " + this.$vfile + " as it has mismatched ModuleInfo=" + this.$infoByVirtualFile;
                                            }
                                        }, 2, null);
                                    }
                                    if (!((ideaModuleInfo = infoByVirtualFile) instanceof ModuleSourceInfo)) {
                                        ideaModuleInfo = null;
                                    }
                                    ModuleSourceInfo moduleSourceInfo = (ModuleSourceInfo)ideaModuleInfo;
                                    if (moduleSourceInfo != null) {
                                        ModuleSourceInfo moduleSourceInfo2;
                                        ModuleSourceInfo it = moduleSourceInfo2 = moduleSourceInfo;
                                        boolean bl4 = false;
                                        PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                    }
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$kotlin_core(event);
                            }
                            catch (ProcessCanceledException pce) {
                                throw (Throwable)pce;
                            }
                            catch (Exception exc) {
                                PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                            }
                        }
                        return true;
                    }
                });
                $this$processPending$iv = this.pendingKtFileChanges;
                this_$iv = this;
                $i$f$processPending = false;
                $this$processPending$iv.removeIf(new Predicate(this){
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.this$0 = perModulePackageCacheService;
                    }

                    public final boolean test(T value2) {
                        try {
                            KtFile file2 = (KtFile)value2;
                            boolean bl = false;
                            if (file2.getVirtualFile() != null && !PerModulePackageCacheService.access$getProjectScope$p(this.this$0).contains(file2.getVirtualFile())) {
                                PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(file2, this){
                                    final /* synthetic */ KtFile $file;
                                    final /* synthetic */ checkPendingChanges$$inlined$synchronized$lambda$2 this$0;
                                    {
                                        this.$file = ktFile;
                                        this.this$0 = var2_2;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        Boolean bl;
                                        KtFile ktFile = this.$file;
                                        VirtualFile virtualFile2 = this.$file.getVirtualFile();
                                        if (virtualFile2 != null) {
                                            VirtualFile virtualFile3;
                                            VirtualFile it = virtualFile3 = virtualFile2;
                                            KtFile ktFile2 = ktFile;
                                            boolean bl2 = false;
                                            Boolean bl3 = !PerModulePackageCacheService.access$getProjectScope$p(this.this$0.this$0).contains(it);
                                            ktFile = ktFile2;
                                            bl = bl3;
                                        } else {
                                            bl = null;
                                        }
                                        return "Skip " + ktFile + " without vFile, or not in scope: " + bl;
                                    }
                                }, 2, null);
                            } else {
                                IdeaModuleInfo nullableModuleInfo = GetModuleInfoKt.getNullableModuleInfo((PsiElement)file2);
                                IdeaModuleInfo ideaModuleInfo = nullableModuleInfo;
                                if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                                    ideaModuleInfo = null;
                                }
                                ModuleSourceInfo moduleSourceInfo = (ModuleSourceInfo)ideaModuleInfo;
                                if (moduleSourceInfo != null) {
                                    ModuleSourceInfo moduleSourceInfo2;
                                    ModuleSourceInfo it = moduleSourceInfo2 = moduleSourceInfo;
                                    boolean bl2 = false;
                                    PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                }
                                if (nullableModuleInfo == null || !(nullableModuleInfo instanceof ModuleSourceInfo)) {
                                    PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(file2, nullableModuleInfo){
                                        final /* synthetic */ KtFile $file;
                                        final /* synthetic */ IdeaModuleInfo $nullableModuleInfo;
                                        {
                                            this.$file = ktFile;
                                            this.$nullableModuleInfo = ideaModuleInfo;
                                            super(0);
                                        }

                                        @NotNull
                                        public final String invoke() {
                                            return "Skip " + this.$file + " as it has mismatched ModuleInfo=" + this.$nullableModuleInfo;
                                        }
                                    }, 2, null);
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$kotlin_core(file2);
                            }
                        }
                        catch (ProcessCanceledException pce) {
                            throw (Throwable)pce;
                        }
                        catch (Exception exc) {
                            PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                        }
                        return true;
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> void processPending(Collection<T> $this$processPending, Function1<? super T, Unit> body2) {
        int $i$f$processPending = 0;
        $this$processPending.removeIf(new Predicate(body2){
            final /* synthetic */ Function1 $body;

            public final boolean test(T value2) {
                try {
                    this.$body.invoke(value2);
                }
                catch (ProcessCanceledException pce) {
                    throw (Throwable)pce;
                }
                catch (Exception exc) {
                    PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                }
                return true;
            }
            {
                this.$body = function1;
            }
        });
    }

    private final boolean containedInOrContains(VirtualFile $this$containedInOrContains, String root) {
        return VfsUtilCore.isEqualOrAncestor((String)$this$containedInOrContains.getUrl(), (String)root) || $this$containedInOrContains.isDirectory() && VfsUtilCore.isEqualOrAncestor((String)root, (String)$this$containedInOrContains.getUrl());
    }

    public final boolean packageExists(@NotNull FqName packageFqName, @NotNull ModuleSourceInfo moduleInfo) {
        ConcurrentMap cacheForCurrentModuleInfo;
        ConcurrentMap perSourceInfoCache;
        ConcurrentMap default$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Module module2 = moduleInfo.getModule();
        this.checkPendingChanges();
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(module2);
        if (object == null) {
            ConcurrentMap concurrentMap;
            boolean bl = false;
            default$iv = concurrentMap = this.useStrongMapForCaching ? (ConcurrentMap)new ConcurrentHashMap() : CollectionFactory.createConcurrentSoftMap();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(module2, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ConcurrentMap concurrentMap = perSourceInfoCache = (ConcurrentMap)object;
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"perSourceInfoCache");
        ConcurrentMap $this$getOrPut$iv2 = concurrentMap;
        boolean $i$f$getOrPut2 = false;
        Object object2 = $this$getOrPut$iv2.get(moduleInfo);
        if (object2 == null) {
            boolean bl = false;
            ConcurrentMap concurrentMap2 = this.useStrongMapForCaching ? (ConcurrentMap)new ConcurrentHashMap() : CollectionFactory.createConcurrentSoftMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"if (useStrongMapForCachi\u2026createConcurrentSoftMap()");
            ConcurrentMap default$iv2 = default$iv = concurrentMap2;
            boolean bl3 = false;
            object2 = $this$getOrPut$iv2.putIfAbsent(moduleInfo, default$iv2);
            if (object2 == null) {
                object2 = default$iv2;
            }
        }
        $this$getOrPut$iv2 = cacheForCurrentModuleInfo = (ConcurrentMap)object2;
        $i$f$getOrPut2 = false;
        Object object3 = $this$getOrPut$iv2.get(packageFqName);
        if (object3 == null) {
            Boolean bl;
            boolean bl4 = false;
            boolean packageExists2 = PackageIndexUtil.INSTANCE.packageExists(packageFqName, moduleInfo.contentScope());
            PerModulePackageCacheServiceKt.debugIfEnabled$default(LOG, this.project, false, (Function0)new Function0<String>(packageExists2, this, packageFqName, moduleInfo){
                final /* synthetic */ boolean $packageExists;
                final /* synthetic */ PerModulePackageCacheService this$0;
                final /* synthetic */ FqName $packageFqName$inlined;
                final /* synthetic */ ModuleSourceInfo $moduleInfo$inlined;
                {
                    this.$packageExists = bl;
                    this.this$0 = perModulePackageCacheService;
                    this.$packageFqName$inlined = fqName2;
                    this.$moduleInfo$inlined = moduleSourceInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Computed cache value for " + this.$packageFqName$inlined + " in " + this.$moduleInfo$inlined + " is " + this.$packageExists;
                }
            }, 2, null);
            Boolean default$iv3 = bl = Boolean.valueOf(packageExists2);
            boolean bl5 = false;
            object3 = $this$getOrPut$iv2.putIfAbsent(packageFqName, default$iv3);
            if (object3 == null) {
                object3 = default$iv3;
            }
        }
        return (Boolean)object3;
    }

    @NotNull
    public final FqName getImplicitPackagePrefix(@NotNull VirtualFile sourceRoot) {
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        this.checkPendingChanges();
        return this.implicitPackagePrefixCache.getPrefix(sourceRoot);
    }

    public void dispose() {
        this.clear();
    }

    public PerModulePackageCacheService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026tMap<FqName, Boolean>>>()");
        this.cache = concurrentMap;
        this.implicitPackagePrefixCache = new ImplicitPackagePrefixCache(this.project);
        this.useStrongMapForCaching = Registry.is((String)"kotlin.cache.packages.strong.map", (boolean)false);
        this.pendingVFileChanges = new LinkedHashSet();
        this.pendingKtFileChanges = new LinkedHashSet();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
        this.projectScope = globalSearchScope;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(this::class.java)");
        LOG = logger;
        Key key = Key.create((String)"debug.PerModulePackageCache");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"debug.PerModulePackageCache\")");
        DEBUG_LOG_ENABLE_PerModulePackageCache$delegate = new NotNullableUserDataProperty(key, (Object)false);
    }

    public static final /* synthetic */ ConcurrentMap access$getCache$p(PerModulePackageCacheService $this) {
        return $this.cache;
    }

    public static final /* synthetic */ boolean access$containedInOrContains(PerModulePackageCacheService $this, VirtualFile $this$access_u24containedInOrContains, String root) {
        return $this.containedInOrContains($this$access_u24containedInOrContains, root);
    }

    public static final /* synthetic */ Project access$getProject$p(PerModulePackageCacheService $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$invalidateCacheForModuleSourceInfo(PerModulePackageCacheService $this, ModuleSourceInfo moduleSourceInfo) {
        $this.invalidateCacheForModuleSourceInfo(moduleSourceInfo);
    }

    public static final /* synthetic */ ImplicitPackagePrefixCache access$getImplicitPackagePrefixCache$p(PerModulePackageCacheService $this) {
        return $this.implicitPackagePrefixCache;
    }

    public static final /* synthetic */ GlobalSearchScope access$getProjectScope$p(PerModulePackageCacheService $this) {
        return $this.projectScope;
    }

    public static final /* synthetic */ void access$setDEBUG_LOG_ENABLE_PerModulePackageCache$cp(NotNullableUserDataProperty notNullableUserDataProperty) {
        DEBUG_LOG_ENABLE_PerModulePackageCache$delegate = notNullableUserDataProperty;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u001c\u0010\u000f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheBulkFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "", "isRelevant", "", "event", "onEvents", "isAfter", "kotlin.core"})
    public static final class PackageCacheBulkFileListener
    implements BulkFileListener {
        private final Project project;

        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.onEvents(events, false);
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.onEvents(events, true);
        }

        private final boolean isRelevant(VFileEvent event) {
            boolean bl;
            VFileEvent vFileEvent = event;
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                bl = false;
            } else if (vFileEvent instanceof VFileCreateEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileMoveEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileDeleteEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileContentChangeEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileCopyEvent) {
                bl = true;
            } else {
                LOG.warn("Unknown vfs event: " + event.getClass());
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final void onEvents(@NotNull List<? extends VFileEvent> events, boolean isAfter) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            PerModulePackageCacheService service2 = Companion.getInstance(this.project);
            PsiManagerEx psiManagerEx = PsiManagerEx.getInstanceEx((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"PsiManagerEx.getInstanceEx(project)");
            FileManager fileManager = psiManagerEx.getFileManager();
            Intrinsics.checkNotNullExpressionValue((Object)fileManager, (String)"PsiManagerEx.getInstanceEx(project).fileManager");
            FileManager fileManager2 = fileManager;
            if (events.size() >= 1000) {
                service2.onTooComplexChange$kotlin_core();
            } else {
                void $this$forEach$iv;
                Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){

                    public final boolean invoke(@NotNull VFileEvent p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return PackageCacheBulkFileListener.access$isRelevant((PackageCacheBulkFileListener)this.receiver, p1);
                    }
                })), (Function1)onEvents.2.INSTANCE), (Function1)onEvents.3.INSTANCE), (Function1)((Function1)new Function1<VFileEvent, Boolean>(isAfter, fileManager2){
                    final /* synthetic */ boolean $isAfter;
                    final /* synthetic */ FileManager $fileManager;

                    public final boolean invoke(@NotNull VFileEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it instanceof VFileContentChangeEvent ? this.$isAfter && this.$fileManager.findCachedViewProvider(((VFileContentChangeEvent)it).getFile()) == null : true;
                    }
                    {
                        this.$isAfter = bl;
                        this.$fileManager = fileManager;
                        super(1);
                    }
                })), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){
                    final /* synthetic */ PackageCacheBulkFileListener this$0;

                    public final boolean invoke(@NotNull VFileEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object origin = it.getRequestor();
                        return origin instanceof Project ? Intrinsics.areEqual((Object)origin, (Object)PackageCacheBulkFileListener.access$getProject$p(this.this$0)) : (origin instanceof PsiManager ? Intrinsics.areEqual((Object)((PsiManager)origin).getProject(), (Object)PackageCacheBulkFileListener.access$getProject$p(this.this$0)) : true);
                    }
                    {
                        this.this$0 = packageCacheBulkFileListener;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    service2.notifyPackageChange$kotlin_core(event);
                }
            }
        }

        public PackageCacheBulkFileListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        public static final /* synthetic */ boolean access$isRelevant(PackageCacheBulkFileListener $this, VFileEvent event) {
            return $this.isRelevant(event);
        }

        public static final /* synthetic */ Project access$getProject$p(PackageCacheBulkFileListener $this) {
            return $this.project;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheModuleRootListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "rootsChanged", "", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "kotlin.core"})
    public static final class PackageCacheModuleRootListener
    implements ModuleRootListener {
        private final Project project;

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Companion.getInstance(this.project).onTooComplexChange$kotlin_core();
        }

        public PackageCacheModuleRootListener(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion;", "", "()V", "FULL_DROP_THRESHOLD", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "", "DEBUG_LOG_ENABLE_PerModulePackageCache", "Lcom/intellij/openapi/project/Project;", "getDEBUG_LOG_ENABLE_PerModulePackageCache", "(Lcom/intellij/openapi/project/Project;)Z", "setDEBUG_LOG_ENABLE_PerModulePackageCache", "(Lcom/intellij/openapi/project/Project;Z)V", "DEBUG_LOG_ENABLE_PerModulePackageCache$delegate", "Lorg/jetbrains/kotlin/psi/NotNullableUserDataProperty;", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "project", "kotlin.core"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "DEBUG_LOG_ENABLE_PerModulePackageCache", "getDEBUG_LOG_ENABLE_PerModulePackageCache(Lcom/intellij/openapi/project/Project;)Z", 0))};
        }

        @NotNull
        public final PerModulePackageCacheService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(PerModulePackageCacheService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (PerModulePackageCacheService)object;
        }

        public final boolean getDEBUG_LOG_ENABLE_PerModulePackageCache(@NotNull Project $this$DEBUG_LOG_ENABLE_PerModulePackageCache) {
            Intrinsics.checkNotNullParameter((Object)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, (String)"$this$DEBUG_LOG_ENABLE_PerModulePackageCache");
            return (Boolean)DEBUG_LOG_ENABLE_PerModulePackageCache$delegate.getValue((UserDataHolder)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, $$delegatedProperties[0]);
        }

        public final void setDEBUG_LOG_ENABLE_PerModulePackageCache(@NotNull Project $this$DEBUG_LOG_ENABLE_PerModulePackageCache, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, (String)"$this$DEBUG_LOG_ENABLE_PerModulePackageCache");
            DEBUG_LOG_ENABLE_PerModulePackageCache$delegate.setValue((UserDataHolder)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, $$delegatedProperties[0], (Object)bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

