/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.psi;

import com.google.common.collect.HashMultimap;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference2;
import kotlin.jvm.internal.PropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.psi.KotlinStubUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinUserDataUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0005H\u0007R_\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004*\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/KotlinPsiHeuristics;", "", "()V", "aliasImportMap", "Lcom/google/common/collect/HashMultimap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/psi/KtFile;", "getAliasImportMap", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lcom/google/common/collect/HashMultimap;", "aliasImportMap$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getImportAliases", "", "file", "names", "isProbablyNothing", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "type", "Lorg/jetbrains/kotlin/psi/KtUserType;", "unwrapImportAlias", "", "aliasName", "kotlin.base.psi"})
public final class KotlinPsiHeuristics {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final ReadOnlyProperty aliasImportMap$delegate;
    @NotNull
    public static final KotlinPsiHeuristics INSTANCE;

    static {
        KotlinPsiHeuristics kotlinPsiHeuristics;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property2((PropertyReference2)new PropertyReference2Impl(KotlinPsiHeuristics.class, "aliasImportMap", "getAliasImportMap(Lorg/jetbrains/kotlin/psi/KtFile;)Lcom/google/common/collect/HashMultimap;", 0))};
        INSTANCE = kotlinPsiHeuristics = new KotlinPsiHeuristics();
        aliasImportMap$delegate = KotlinUserDataUtils.userDataCached("ALIAS_IMPORT_MAP_KEY", aliasImportMap.2.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> unwrapImportAlias(@NotNull KtFile file2, @NotNull String aliasName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)aliasName, (String)"aliasName");
        Set set2 = INSTANCE.getAliasImportMap(file2).get((Object)aliasName);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"file.aliasImportMap[aliasName]");
        return set2;
    }

    @JvmStatic
    @NotNull
    public static final Collection<String> unwrapImportAlias(@NotNull KtUserType type2, @NotNull String aliasName) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)aliasName, (String)"aliasName");
        PsiFileStub<?> psiFileStub = KotlinStubUtils.getContainingKotlinFileStub((StubBasedPsiElementBase)type2);
        Object object = psiFileStub != null ? (PsiFile)psiFileStub.getPsi() : null;
        if (!(object instanceof KtFile)) {
            object = null;
        }
        KtFile ktFile = (KtFile)object;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        return KotlinPsiHeuristics.unwrapImportAlias(file2, aliasName);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<String> getImportAliases(@NotNull KtFile file2, @NotNull Set<String> names) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        LinkedHashSet result2 = new LinkedHashSet();
        for (Map.Entry entry : INSTANCE.getAliasImportMap(file2).entries()) {
            void aliasName;
            Object object = entry;
            String string = (String)object.getKey();
            object = entry;
            String name2 = (String)object.getValue();
            if (!names.contains(name2)) continue;
            object = result2;
            object.add(aliasName);
        }
        return result2;
    }

    private final HashMultimap<String, String> getAliasImportMap(KtFile $this$aliasImportMap) {
        return (HashMultimap)aliasImportMap$delegate.getValue((Object)$this$aliasImportMap, $$delegatedProperties[0]);
    }

    @JvmStatic
    public static final boolean isProbablyNothing(@NotNull KtTypeReference typeReference2) {
        Intrinsics.checkNotNullParameter((Object)typeReference2, (String)"typeReference");
        KtTypeElement ktTypeElement = typeReference2.getTypeElement();
        if (!(ktTypeElement instanceof KtUserType)) {
            ktTypeElement = null;
        }
        KtUserType ktUserType2 = (KtUserType)ktTypeElement;
        if (ktUserType2 == null) {
            return false;
        }
        KtUserType userType2 = ktUserType2;
        return KotlinPsiHeuristics.isProbablyNothing(userType2);
    }

    @JvmStatic
    public static final boolean isProbablyNothing(@NotNull KtUserType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        String referencedName = type2.getReferencedName();
        if (Intrinsics.areEqual((Object)referencedName, (Object)"Nothing")) {
            return true;
        }
        PsiFileStub<?> psiFileStub = KotlinStubUtils.getContainingKotlinFileStub((StubBasedPsiElementBase)type2);
        Object object = psiFileStub != null ? (PsiFile)psiFileStub.getPsi() : null;
        if (!(object instanceof KtFile)) {
            object = null;
        }
        KtFile ktFile = (KtFile)object;
        if (ktFile == null) {
            return false;
        }
        KtFile file2 = ktFile;
        return INSTANCE.getAliasImportMap(file2).get((Object)referencedName).contains("Nothing");
    }

    private KotlinPsiHeuristics() {
    }
}

