/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;

public class Workspace3Reader
implements WorkspaceReader {
    private final WorkspaceRepository myRepository = new WorkspaceRepository();
    private final MavenWorkspaceMap myWorkspaceMap;

    public Workspace3Reader(MavenWorkspaceMap workspaceMap) {
        this.myWorkspaceMap = workspaceMap;
    }

    public WorkspaceRepository getRepository() {
        return this.myRepository;
    }

    public File findArtifact(Artifact artifact) {
        MavenWorkspaceMap.Data resolved = this.myWorkspaceMap.findFileAndOriginalId(new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        if (resolved == null) {
            return null;
        }
        return resolved.getFile(artifact.getExtension());
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public List<String> findVersions(Artifact artifact) {
        ArrayList<String> res = new ArrayList<String>();
        for (MavenId id : this.myWorkspaceMap.getAvailableIds()) {
            String version;
            if (!Workspace3Reader.equals(id.getArtifactId(), artifact.getArtifactId()) || !Workspace3Reader.equals(id.getGroupId(), artifact.getGroupId()) || (version = id.getVersion()) == null) continue;
            res.add(version);
        }
        return res;
    }
}

