/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.api.DaemonStoppedException;
import org.gradle.launcher.daemon.server.api.DaemonUnavailableException;

public class DaemonStateCoordinator
implements Stoppable,
DaemonStateControl {
    public static final String DAEMON_WILL_STOP_MESSAGE = "Daemon will be stopped at the end of the build ";
    public static final String DAEMON_STOPPING_IMMEDIATELY_MESSAGE = "Daemon is stopping immediately ";
    private static final Logger LOGGER = Logging.getLogger(DaemonStateCoordinator.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long cancelTimeoutMs;
    private DaemonStateControl.State state = DaemonStateControl.State.Idle;
    private final Timer idleTimer;
    private String currentCommandExecution;
    private Object result;
    private String stopReason;
    private volatile DefaultBuildCancellationToken cancellationToken;
    private final ManagedExecutor executor;
    private final Runnable onStartCommand;
    private final Runnable onFinishCommand;
    private final Runnable onCancelCommand;

    public DaemonStateCoordinator(ExecutorFactory executorFactory, Runnable onStartCommand, Runnable onFinishCommand, Runnable onCancelCommand) {
        this(executorFactory, onStartCommand, onFinishCommand, onCancelCommand, 10000L);
    }

    DaemonStateCoordinator(ExecutorFactory executorFactory, Runnable onStartCommand, Runnable onFinishCommand, Runnable onCancelCommand, long cancelTimeoutMs) {
        this.executor = executorFactory.create("Daemon worker");
        this.onStartCommand = onStartCommand;
        this.onFinishCommand = onFinishCommand;
        this.onCancelCommand = onCancelCommand;
        this.cancelTimeoutMs = cancelTimeoutMs;
        this.idleTimer = Time.startTimer();
        this.updateCancellationToken();
    }

    private void setState(DaemonStateControl.State state2) {
        this.state = state2;
        this.condition.signalAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean awaitStop() {
        this.lock.lock();
        try {
            while (true) {
                switch (this.state) {
                    case Idle: 
                    case Busy: {
                        LOGGER.debug("daemon is running. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Canceled: {
                        LOGGER.debug("cancel requested.");
                        this.cancelNow();
                        break;
                    }
                    case Broken: {
                        throw new IllegalStateException("This daemon is in a broken state.");
                    }
                    case StopRequested: {
                        LOGGER.debug("daemon stop has been requested. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Stopped: {
                        LOGGER.debug("daemon has stopped.");
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void requestStop(String reason) {
        if (this.state != DaemonStateControl.State.StopRequested && this.state != DaemonStateControl.State.Stopped) {
            LOGGER.lifecycle(DAEMON_WILL_STOP_MESSAGE + reason);
            this.lock.lock();
            try {
                if (this.state == DaemonStateControl.State.Busy) {
                    LOGGER.debug("Stop as soon as idle requested. The daemon is busy: {}", this.state == DaemonStateControl.State.Busy);
                    this.beginStopping();
                } else {
                    this.stopNow(reason);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void requestForcefulStop(String reason) {
        LOGGER.lifecycle(DAEMON_STOPPING_IMMEDIATELY_MESSAGE + reason);
        this.stopNow(reason);
    }

    @Override
    public void stop() {
        this.stopNow("service stop");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stopNow(String reason) {
        this.lock.lock();
        try {
            switch (this.state) {
                case Idle: 
                case Busy: 
                case Canceled: 
                case Broken: 
                case StopRequested: {
                    LOGGER.debug("Marking daemon stopped due to {}. The daemon is running a build: {}", reason, this.state == DaemonStateControl.State.Busy);
                    this.stopReason = reason;
                    this.setState(DaemonStateControl.State.Stopped);
                    return;
                }
                case Stopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void beginStopping() {
        switch (this.state) {
            case Idle: 
            case Busy: 
            case Canceled: 
            case Broken: {
                this.setState(DaemonStateControl.State.StopRequested);
                break;
            }
            case StopRequested: 
            case Stopped: {
                break;
            }
            default: {
                throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
            }
        }
    }

    @Override
    public BuildCancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    private void updateCancellationToken() {
        this.cancellationToken = new DefaultBuildCancellationToken();
        this.cancellationToken.addCallback(this.onCancelCommand);
    }

    @Override
    public void requestCancel() {
        this.lock.lock();
        try {
            if (this.state == DaemonStateControl.State.Busy) {
                this.setState(DaemonStateControl.State.Canceled);
            } else if (this.state == DaemonStateControl.State.StopRequested) {
                this.requestForcefulStop("the build was canceled after a stop was requested");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void cancelBuild() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void cancelNow() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void runCommand(final Runnable command, String commandDisplayName) throws DaemonUnavailableException {
        this.onStartCommand(commandDisplayName);
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        command.run();
                        DaemonStateCoordinator.this.onCommandSuccessful();
                    }
                    catch (Throwable t) {
                        DaemonStateCoordinator.this.onCommandFailed(t);
                    }
                }
            });
            this.waitForCommandCompletion();
        }
        finally {
            this.onFinishCommand();
        }
    }

    private void waitForCommandCompletion() {
        this.lock.lock();
        try {
            while ((this.state == DaemonStateControl.State.Busy || this.state == DaemonStateControl.State.Canceled || this.state == DaemonStateControl.State.StopRequested) && this.result == null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            LOGGER.debug("Command execution: finished waiting for {}. Result {} with state {}", new Object[]{this.currentCommandExecution, this.result, this.state});
            if (this.result instanceof Throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.result);
            }
            if (this.result != null) {
                return;
            }
            switch (this.state) {
                case Stopped: {
                    throw new DaemonStoppedException(this.stopReason);
                }
                case Broken: {
                    throw new DaemonUnavailableException("This daemon is broken and will stop.");
                }
            }
            throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onCommandFailed(Throwable failure) {
        this.lock.lock();
        try {
            this.result = failure;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onCommandSuccessful() {
        this.lock.lock();
        try {
            this.result = this;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onStartCommand(String commandDisplayName) {
        this.lock.lock();
        try {
            switch (this.state) {
                case Broken: {
                    throw new DaemonUnavailableException("This daemon is in a broken state and will stop.");
                }
                case StopRequested: {
                    throw new DaemonUnavailableException("This daemon is currently stopping.");
                }
                case Stopped: {
                    throw new DaemonUnavailableException("This daemon has stopped.");
                }
                case Busy: 
                case Canceled: {
                    throw new DaemonUnavailableException(String.format("This daemon is currently executing: %s", this.currentCommandExecution));
                }
            }
            LOGGER.debug("Command execution: started {} after {} minutes of idle", commandDisplayName, this.getIdleMinutes());
            try {
                this.setState(DaemonStateControl.State.Busy);
                this.onStartCommand.run();
                this.currentCommandExecution = commandDisplayName;
                this.result = null;
                this.updateActivityTimestamp();
                this.updateCancellationToken();
                this.condition.signalAll();
            }
            catch (Throwable throwable) {
                this.setState(DaemonStateControl.State.Broken);
                throw UncheckedException.throwAsUncheckedException(throwable);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onFinishCommand() {
        this.lock.lock();
        try {
            LOGGER.debug("Command execution: completed {}", this.currentCommandExecution);
            this.currentCommandExecution = null;
            this.result = null;
            this.stopReason = null;
            this.updateActivityTimestamp();
            switch (this.state) {
                case Idle: 
                case Busy: 
                case Canceled: {
                    try {
                        this.onFinishCommand.run();
                        this.setState(DaemonStateControl.State.Idle);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.setState(DaemonStateControl.State.Broken);
                        throw UncheckedException.throwAsUncheckedException(throwable);
                    }
                }
                case StopRequested: {
                    this.stopNow("command completed and stop requested");
                    return;
                }
                case Stopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + (Object)((Object)this.state));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateActivityTimestamp() {
        LOGGER.debug("resetting idle timer");
        this.idleTimer.reset();
    }

    private double getIdleMinutes() {
        this.lock.lock();
        try {
            double d = this.idleTimer.getElapsedMillis() / 1000L / 60L;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getIdleMillis() {
        if (this.state == DaemonStateControl.State.Idle) {
            return this.idleTimer.getElapsedMillis();
        }
        return 0L;
    }

    boolean isWillRefuseNewCommands() {
        return this.state != DaemonStateControl.State.Idle && this.state != DaemonStateControl.State.Busy;
    }

    @Override
    public DaemonStateControl.State getState() {
        return this.state;
    }
}

