/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultProjectDependencyMetadata
implements ForcingDependencyMetadata {
    private final ProjectComponentSelector selector;
    private final DependencyMetadata delegate;
    private final boolean isTransitive;

    public DefaultProjectDependencyMetadata(ProjectComponentSelector selector, DependencyMetadata delegate) {
        this.selector = selector;
        this.delegate = delegate;
        this.isTransitive = delegate.isTransitive();
    }

    @Override
    public ProjectComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return Collections.emptyList();
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target.equals(this.selector)) {
            return this;
        }
        return this.delegate.withTarget(target);
    }

    @Override
    public DependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts2) {
        if (target.equals(this.selector) && this.delegate.getArtifacts().equals(artifacts2)) {
            return this;
        }
        return this.delegate.withTargetAndArtifacts(target, artifacts2);
    }

    @Override
    public boolean isChanging() {
        return this.delegate.isChanging();
    }

    @Override
    public boolean isConstraint() {
        return this.delegate.isConstraint();
    }

    @Override
    public boolean isEndorsingStrictVersions() {
        return this.delegate.isEndorsingStrictVersions();
    }

    @Override
    public String getReason() {
        return this.delegate.getReason();
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema, Collection<? extends Capability> explicitRequestedCapabilities) {
        return this.delegate.selectConfigurations(consumerAttributes, targetComponent, consumerSchema, explicitRequestedCapabilities);
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.delegate.getArtifacts();
    }

    @Override
    public DependencyMetadata withReason(String reason) {
        return this.delegate.withReason(reason);
    }

    @Override
    public boolean isForce() {
        if (this.delegate instanceof ForcingDependencyMetadata) {
            return ((ForcingDependencyMetadata)this.delegate).isForce();
        }
        return false;
    }

    @Override
    public ForcingDependencyMetadata forced() {
        if (this.delegate instanceof ForcingDependencyMetadata) {
            return ((ForcingDependencyMetadata)this.delegate).forced();
        }
        return this;
    }
}

