/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.callsite.AbstractCallSite;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.wrappers.Wrapper;
import org.gradle.internal.classpath.AccessTrackingEnvMap;
import org.gradle.internal.classpath.AccessTrackingProperties;

public class Instrumented {
    private static final Listener NO_OP = new Listener(){

        @Override
        public void systemPropertyQueried(String key, @Nullable Object value, String consumer) {
        }

        @Override
        public void envVariableQueried(String key, @Nullable String value, String consumer) {
        }
    };
    private static final AtomicReference<Listener> LISTENER = new AtomicReference<Listener>(NO_OP);

    public static void setListener(Listener listener2) {
        LISTENER.set(listener2);
    }

    public static void discardListener() {
        Instrumented.setListener(NO_OP);
    }

    public static void groovyCallSites(CallSiteArray array) {
        block16: for (CallSite callSite : array.array) {
            switch (callSite.getName()) {
                case "getProperty": {
                    array.array[callSite.getIndex()] = new SystemPropertyCallSite(callSite);
                    continue block16;
                }
                case "properties": {
                    array.array[callSite.getIndex()] = new SystemPropertiesCallSite(callSite);
                    continue block16;
                }
                case "getInteger": {
                    array.array[callSite.getIndex()] = new IntegerSystemPropertyCallSite(callSite);
                    continue block16;
                }
                case "getLong": {
                    array.array[callSite.getIndex()] = new LongSystemPropertyCallSite(callSite);
                    continue block16;
                }
                case "getBoolean": {
                    array.array[callSite.getIndex()] = new BooleanSystemPropertyCallSite(callSite);
                    continue block16;
                }
                case "getenv": {
                    array.array[callSite.getIndex()] = new GetEnvCallSite(callSite);
                }
            }
        }
    }

    public static String systemProperty(String key, String consumer) {
        return Instrumented.systemProperty(key, null, consumer);
    }

    public static String systemProperty(String key, @Nullable String defaultValue, String consumer) {
        String value = System.getProperty(key);
        Instrumented.systemPropertyQueried(key, value, consumer);
        return value == null ? defaultValue : value;
    }

    public static Properties systemProperties(String consumer) {
        return new AccessTrackingProperties(System.getProperties(), (k, v) -> Instrumented.systemPropertyQueried(Instrumented.convertToString(k), Instrumented.convertToString(v), consumer));
    }

    public static Integer getInteger(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key);
    }

    public static Integer getInteger(String key, int defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Integer.getInteger(key, defaultValue);
    }

    public static Long getLong(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key);
    }

    public static Long getLong(String key, long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static Long getLong(String key, Long defaultValue, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Long.getLong(key, defaultValue);
    }

    public static boolean getBoolean(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, consumer);
        return Boolean.getBoolean(key);
    }

    public static String getenv(String key, String consumer) {
        String value = System.getenv(key);
        Instrumented.envVariableQueried(key, value, consumer);
        return value;
    }

    public static Map<String, String> getenv(String consumer) {
        return new AccessTrackingEnvMap((key, value) -> Instrumented.envVariableQueried(Instrumented.convertToString(key), value, consumer));
    }

    private static void envVariableQueried(String key, String value, String consumer) {
        Instrumented.listener().envVariableQueried(key, value, consumer);
    }

    private static void systemPropertyQueried(String key, String consumer) {
        Instrumented.systemPropertyQueried(key, System.getProperty(key), consumer);
    }

    private static void systemPropertyQueried(String key, @Nullable String value, String consumer) {
        Instrumented.listener().systemPropertyQueried(key, value, consumer);
    }

    private static Listener listener() {
        return LISTENER.get();
    }

    private static Object unwrap(Object obj) {
        if (obj instanceof Wrapper) {
            return ((Wrapper)obj).unwrap();
        }
        return obj;
    }

    private static String convertToString(Object arg) {
        if (arg instanceof CharSequence) {
            return ((CharSequence)arg).toString();
        }
        return (String)arg;
    }

    private static class GetEnvCallSite
    extends AbstractCallSite {
        public GetEnvCallSite(CallSite prev) {
            super(prev);
        }

        public Object call(Object receiver) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.getenv(this.array.owner.getName());
            }
            return super.call(receiver);
        }

        public Object call(Object receiver, Object arg1) throws Throwable {
            if (receiver.equals(System.class) && arg1 instanceof CharSequence) {
                return Instrumented.getenv(Instrumented.convertToString(arg1), this.array.owner.getName());
            }
            return super.call(receiver, arg1);
        }
    }

    private static class SystemPropertiesCallSite
    extends AbstractCallSite {
        public SystemPropertiesCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object callGetProperty(Object receiver) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperties(this.array.owner.getName());
            }
            return super.callGetProperty(receiver);
        }
    }

    private static class SystemPropertyCallSite
    extends AbstractCallSite {
        public SystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(System.class)) {
                return Instrumented.systemProperty(arg1.toString(), Instrumented.convertToString(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    private static class BooleanSystemPropertyCallSite
    extends AbstractCallSite {
        public BooleanSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Boolean.class)) {
                return Instrumented.getBoolean(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }
    }

    private static class LongSystemPropertyCallSite
    extends AbstractCallSite {
        public LongSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Long.class)) {
                return Instrumented.getLong(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(Long.class)) {
                return Instrumented.getLong(arg1.toString(), (Long)Instrumented.unwrap(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    private static class IntegerSystemPropertyCallSite
    extends AbstractCallSite {
        public IntegerSystemPropertyCallSite(CallSite callSite) {
            super(callSite);
        }

        public Object call(Object receiver, Object arg) throws Throwable {
            if (receiver.equals(Integer.class)) {
                return Instrumented.getInteger(arg.toString(), this.array.owner.getName());
            }
            return super.call(receiver, arg);
        }

        public Object call(Object receiver, Object arg1, Object arg2) throws Throwable {
            if (receiver.equals(Integer.class)) {
                return Instrumented.getInteger(arg1.toString(), (Integer)Instrumented.unwrap(arg2), this.array.owner.getName());
            }
            return super.call(receiver, arg1, arg2);
        }
    }

    public static interface Listener {
        public void systemPropertyQueried(String var1, @Nullable Object var2, String var3);

        public void envVariableQueried(String var1, @Nullable String var2, String var3);
    }
}

