/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.lang.ref.WeakReference;

public class ScriptCacheKey {
    private final String className;
    private final WeakReference<ClassLoader> classLoader;
    private final String dslId;

    ScriptCacheKey(String className, ClassLoader classLoader, String dslId) {
        this.className = className;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.dslId = dslId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptCacheKey key = (ScriptCacheKey)o;
        return this.classLoader.get() != null && key.classLoader.get() != null && ((ClassLoader)this.classLoader.get()).equals(key.classLoader.get()) && this.className.equals(key.className) && this.dslId.equals(key.dslId);
    }

    public int hashCode() {
        ClassLoader loader = (ClassLoader)this.classLoader.get();
        int result2 = this.className.hashCode();
        result2 = 31 * result2 + (loader != null ? loader.hashCode() : 1);
        result2 = 31 * result2 + this.dslId.hashCode();
        return result2;
    }
}

