/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.function.Function;
import org.gradle.BuildResult;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.deployment.internal.DefaultDeploymentRegistry;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildOperationFiringBuildTreeWorkExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleControllerFactory;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.DefaultBuildTreeFinishExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.composite.IncludedRootBuild;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.util.Path;

class DefaultRootBuildState
extends AbstractCompositeParticipantBuildState
implements RootBuildState,
Stoppable {
    private final ListenerManager listenerManager;
    private final BuildTreeLifecycleController buildTreeLifecycleController;
    private boolean completed;

    DefaultRootBuildState(BuildDefinition buildDefinition, BuildTreeState buildTree, ListenerManager listenerManager) {
        super(buildTree, buildDefinition, null);
        this.listenerManager = listenerManager;
        BuildScopeServices buildScopeServices = this.getBuildServices();
        BuildLifecycleController buildLifecycleController = this.getBuildController();
        ExceptionAnalyser exceptionAnalyser = buildScopeServices.get(ExceptionAnalyser.class);
        BuildOperationExecutor buildOperationExecutor = buildScopeServices.get(BuildOperationExecutor.class);
        BuildStateRegistry buildStateRegistry2 = buildScopeServices.get(BuildStateRegistry.class);
        BuildTreeLifecycleControllerFactory buildTreeLifecycleControllerFactory = buildScopeServices.get(BuildTreeLifecycleControllerFactory.class);
        BuildOperationFiringBuildTreeWorkExecutor workExecutor = new BuildOperationFiringBuildTreeWorkExecutor(new DefaultBuildTreeWorkExecutor(), buildOperationExecutor);
        DefaultBuildTreeFinishExecutor finishExecutor = new DefaultBuildTreeFinishExecutor(buildStateRegistry2, exceptionAnalyser, buildLifecycleController);
        this.buildTreeLifecycleController = buildTreeLifecycleControllerFactory.createRootBuildController(buildLifecycleController, workExecutor, finishExecutor);
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return DefaultBuildIdentifier.ROOT;
    }

    @Override
    public Path getIdentityPath() {
        return Path.ROOT;
    }

    @Override
    public boolean isImplicitBuild() {
        return false;
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
    }

    @Override
    public File getBuildRootDir() {
        return this.getBuildController().getGradle().getServices().get(BuildLayout.class).getRootDirectory();
    }

    @Override
    public IncludedBuildInternal getModel() {
        return new IncludedRootBuild(this);
    }

    @Override
    public void stop() {
        this.getBuildController().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Function<? super BuildTreeLifecycleController, T> action) {
        if (this.completed) {
            throw new IllegalStateException("Cannot run more than one action for a build.");
        }
        try {
            T t;
            RootBuildLifecycleListener buildLifecycleListener = this.listenerManager.getBroadcaster(RootBuildLifecycleListener.class);
            buildLifecycleListener.afterStart();
            try {
                GradleInternal gradle = this.getBuildController().getGradle();
                final DefaultDeploymentRegistry deploymentRegistry = gradle.getServices().get(DefaultDeploymentRegistry.class);
                gradle.addBuildListener(new InternalBuildAdapter(){

                    @Override
                    public void buildFinished(BuildResult result2) {
                        deploymentRegistry.buildFinished(result2);
                    }
                });
                t = action.apply(this.buildTreeLifecycleController);
                buildLifecycleListener.beforeComplete();
            }
            catch (Throwable throwable) {
                buildLifecycleListener.beforeComplete();
                throw throwable;
            }
            return t;
        }
        finally {
            this.completed = true;
        }
    }

    @Override
    public StartParameterInternal getStartParameter() {
        return this.getBuildController().getGradle().getStartParameter();
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return Path.ROOT;
    }

    @Override
    public Path calculateIdentityPathForProject(Path path) {
        return path;
    }

    @Override
    protected void ensureChildBuildConfigured() {
    }
}

