/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.publish.internal.PublicationArtifactInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;

public class MavenNormalizedPublication {
    private final String name;
    private final ModuleComponentIdentifier coordinates;
    private final String packaging;
    private final MavenArtifact pomArtifact;
    private final MavenArtifact mainArtifact;
    private final Set<MavenArtifact> allArtifacts;

    public MavenNormalizedPublication(String name, MavenProjectIdentity projectIdentity, String packaging, MavenArtifact pomArtifact, MavenArtifact mainArtifact, Set<MavenArtifact> allArtifacts) {
        this.name = name;
        this.coordinates = DefaultModuleComponentIdentifier.newId(DefaultModuleIdentifier.newId(projectIdentity.getGroupId().get(), projectIdentity.getArtifactId().get()), projectIdentity.getVersion().get());
        this.packaging = packaging;
        this.pomArtifact = pomArtifact;
        this.mainArtifact = mainArtifact;
        this.allArtifacts = allArtifacts;
    }

    public String getName() {
        return this.name;
    }

    public ModuleComponentIdentifier getProjectIdentity() {
        return this.coordinates;
    }

    public String getGroupId() {
        return this.coordinates.getGroup();
    }

    public String getArtifactId() {
        return this.coordinates.getModule();
    }

    public String getVersion() {
        return this.coordinates.getVersion();
    }

    public String getPackaging() {
        return this.packaging;
    }

    @Deprecated
    public File getPomFile() {
        return this.pomArtifact.getFile();
    }

    public MavenArtifact getPomArtifact() {
        return this.pomArtifact;
    }

    public MavenArtifact getMainArtifact() {
        if (this.mainArtifact != null && !((PublicationArtifactInternal)((Object)this.mainArtifact)).shouldBePublished()) {
            throw new IllegalStateException("Artifact " + this.mainArtifact.getFile().getName() + " wasn't produced by this build.");
        }
        return this.mainArtifact;
    }

    public Set<MavenArtifact> getAdditionalArtifacts() {
        return this.allArtifacts.stream().filter(artifact -> artifact != this.pomArtifact && artifact != this.mainArtifact).collect(Collectors.toSet());
    }

    public Set<MavenArtifact> getAllArtifacts() {
        return this.allArtifacts;
    }
}

