/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.temp;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.temp.TempFiles;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GFileUtils;

public class DefaultTemporaryFileProvider
implements TemporaryFileProvider,
Serializable {
    private final Factory<File> baseDirFactory;

    public DefaultTemporaryFileProvider(Factory<File> fileFactory) {
        this.baseDirFactory = fileFactory;
    }

    @Override
    public File newTemporaryFile(String ... path) {
        return FileUtils.canonicalize(new File(this.baseDirFactory.create(), CollectionUtils.join("/", path)));
    }

    @Override
    public File createTemporaryFile(String prefix, @Nullable String suffix, String ... path) {
        File dir = this.newTemporaryFile(path);
        GFileUtils.mkdirs(dir);
        try {
            return TempFiles.createTempFile(prefix, suffix, dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public File createTemporaryDirectory(String prefix, @Nullable String suffix, String ... path) {
        File dir = this.newTemporaryFile(path);
        GFileUtils.mkdirs(dir);
        try {
            File tmpDir = TempFiles.createTempFile(prefix, suffix, dir);
            if (!tmpDir.delete()) {
                throw new UncheckedIOException("Failed to delete file: " + tmpDir);
            }
            if (!tmpDir.mkdir()) {
                throw new UncheckedIOException("Failed to make directory: " + tmpDir);
            }
            return tmpDir;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

