/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import org.gradle.api.Action;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.ReproducibleFileVisitor;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.DefaultFileCopyDetails;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;

public class CopyFileVisitorImpl
implements ReproducibleFileVisitor {
    private final CopySpecResolver copySpecResolver;
    private final CopyActionProcessingStreamAction action;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final FileSystem fileSystem;
    private final boolean reproducibleFileOrder;

    public CopyFileVisitorImpl(CopySpecResolver spec, CopyActionProcessingStreamAction action, Instantiator instantiator, ObjectFactory objectFactory, FileSystem fileSystem, boolean reproducibleFileOrder) {
        this.copySpecResolver = spec;
        this.action = action;
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.fileSystem = fileSystem;
        this.reproducibleFileOrder = reproducibleFileOrder;
    }

    @Override
    public void visitDir(FileVisitDetails dirDetails) {
        this.processDir(dirDetails);
    }

    @Override
    public void visitFile(FileVisitDetails fileDetails) {
        this.processFile(fileDetails);
    }

    private void processDir(FileVisitDetails visitDetails) {
        DefaultFileCopyDetails details = this.createDefaultFileCopyDetails(visitDetails);
        this.action.processFile(details);
    }

    private void processFile(FileVisitDetails visitDetails) {
        DefaultFileCopyDetails details = this.createDefaultFileCopyDetails(visitDetails);
        for (Action<? super FileCopyDetails> action : this.copySpecResolver.getAllCopyActions()) {
            action.execute(details);
            if (!details.isExcluded()) continue;
            return;
        }
        this.action.processFile(details);
    }

    private DefaultFileCopyDetails createDefaultFileCopyDetails(FileVisitDetails visitDetails) {
        return this.instantiator.newInstance(DefaultFileCopyDetails.class, visitDetails, this.copySpecResolver, this.objectFactory, this.fileSystem);
    }

    @Override
    public boolean isReproducibleFileOrder() {
        return this.reproducibleFileOrder;
    }
}

