/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import java.util.Map;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.AbstractResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.resource.ExternalResourceName;

public class IvyResourcePattern
extends AbstractResourcePattern
implements ResourcePattern {
    public IvyResourcePattern(String pattern) {
        super(pattern);
    }

    public IvyResourcePattern(URI baseUri, String pattern) {
        super(baseUri, pattern);
    }

    public String toString() {
        return "Ivy pattern '" + this.getPattern() + "'";
    }

    @Override
    public ExternalResourceName getLocation(ModuleComponentArtifactMetadata artifact) {
        Map<String, String> attributes = this.toAttributes(artifact);
        return this.getBase().getRoot().resolve(this.substituteTokens(this.getBase().getPath(), attributes));
    }

    @Override
    public ExternalResourceName toVersionListPattern(ModuleIdentifier module, IvyArtifactName artifact) {
        Map<String, String> attributes = this.toAttributes(module, artifact);
        return this.getBase().getRoot().resolve(this.substituteTokens(this.getBase().getPath(), attributes));
    }

    @Override
    public ExternalResourceName toModulePath(ModuleIdentifier module) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExternalResourceName toModuleVersionPath(ModuleComponentIdentifier componentIdentifier) {
        ImmutableMap attributes = ImmutableMap.of((Object)"organisation", (Object)componentIdentifier.getGroup(), (Object)"module", (Object)componentIdentifier.getModule(), (Object)"artifact", (Object)componentIdentifier.getModule(), (Object)"revision", (Object)componentIdentifier.getVersion());
        ExternalResourceName resolve = this.getBase().getRoot().resolve(this.substituteTokens(this.getPathWithoutArtifactPart(), (Map<String, String>)attributes));
        return resolve;
    }

    protected String getPathWithoutArtifactPart() {
        String path = this.getBase().getPath();
        int i = path.lastIndexOf(47);
        if (i > 0) {
            i = path.indexOf("/[artifact]", i);
        }
        if (i < 0) {
            throw new UnsupportedOperationException("Cannot locate module version for non standard Ivy layout.");
        }
        return path.substring(0, i);
    }
}

