/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Collection;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.model.ComponentConfigurationIdentifier;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DefaultLocalComponentMetadataBuilder
implements LocalComponentMetadataBuilder {
    private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;

    public DefaultLocalComponentMetadataBuilder(LocalConfigurationMetadataBuilder configurationMetadataBuilder) {
        this.configurationMetadataBuilder = configurationMetadataBuilder;
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(final BuildableLocalComponentMetadata metaData, final ConfigurationInternal configuration2) {
        BuildableLocalConfigurationMetadata configurationMetadata = this.createConfiguration(metaData, configuration2);
        metaData.addDependenciesAndExcludesForConfiguration(configuration2, this.configurationMetadataBuilder);
        final ComponentConfigurationIdentifier configurationIdentifier = new ComponentConfigurationIdentifier(metaData.getId(), configuration2.getName());
        configuration2.collectVariants(new ConfigurationInternal.VariantVisitor(){

            @Override
            public void visitArtifacts(Collection<? extends PublishArtifact> artifacts2) {
                metaData.addArtifacts(configuration2.getName(), artifacts2);
            }

            @Override
            public void visitOwnVariant(DisplayName displayName, ImmutableAttributes attributes, Collection<? extends Capability> capabilities, Collection<? extends PublishArtifact> artifacts2) {
                metaData.addVariant(configuration2.getName(), configuration2.getName(), configurationIdentifier, displayName, attributes, ImmutableCapabilities.of(capabilities), artifacts2);
            }

            @Override
            public void visitChildVariant(String name, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends Capability> capabilities, Collection<? extends PublishArtifact> artifacts2) {
                metaData.addVariant(configuration2.getName(), configuration2.getName() + "-" + name, new NestedVariantIdentifier(configurationIdentifier, name), displayName, attributes, ImmutableCapabilities.of(capabilities), artifacts2);
            }
        });
        return configurationMetadata;
    }

    private BuildableLocalConfigurationMetadata createConfiguration(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration2) {
        configuration2.preventFromFurtherMutation();
        ImmutableSet<String> hierarchy = Configurations.getNames(configuration2.getHierarchy());
        ImmutableSet<String> extendsFrom = Configurations.getNames(configuration2.getExtendsFrom());
        ImmutableCapabilities capabilities = ImmutableCapabilities.copyAsImmutable(Configurations.collectCapabilities(configuration2, Sets.newHashSet(), Sets.newHashSet()));
        return metaData.addConfiguration(configuration2.getName(), configuration2.getDescription(), (Set<String>)extendsFrom, hierarchy, configuration2.isVisible(), configuration2.isTransitive(), configuration2.getAttributes().asImmutable(), configuration2.isCanBeConsumed(), configuration2.getConsumptionDeprecation(), configuration2.isCanBeResolved(), capabilities, configuration2.getConsistentResolutionConstraints());
    }

    private static class NestedVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final VariantResolveMetadata.Identifier parent;
        private final String name;

        public NestedVariantIdentifier(VariantResolveMetadata.Identifier parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            return this.parent.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NestedVariantIdentifier other = (NestedVariantIdentifier)obj;
            return this.parent.equals(other.parent) && this.name.equals(other.name);
        }
    }
}

