/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.StringUtils;

public final class Message {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static boolean showedInfo = false;
    private static MessageLogger defaultLogger = new DefaultMessageLogger(2);

    public static MessageLogger getDefaultLogger() {
        return defaultLogger;
    }

    public static void setDefaultLogger(MessageLogger logger2) {
        Checks.checkNotNull(logger2, "logger");
        defaultLogger = logger2;
    }

    private static MessageLogger getLogger() {
        return IvyContext.getContext().getMessageLogger();
    }

    public static void showInfo() {
        if (!showedInfo) {
            Message.info(":: Apache Ivy " + Ivy.getIvyVersion() + " - " + Ivy.getIvyDate() + " :: " + Ivy.getIvyHomeURL() + " ::");
            showedInfo = true;
        }
    }

    public static void debug(String msg) {
        Message.getLogger().debug(msg);
    }

    public static void verbose(String msg) {
        Message.getLogger().verbose(msg);
    }

    public static void info(String msg) {
        Message.getLogger().info(msg);
    }

    public static void rawinfo(String msg) {
        Message.getLogger().rawinfo(msg);
    }

    public static void deprecated(String msg) {
        Message.getLogger().deprecated(msg);
    }

    public static void warn(String msg) {
        Message.getLogger().warn(msg);
    }

    public static void error(String msg) {
        Message.getLogger().error(msg);
    }

    public static void log(int logLevel, String msg) {
        switch (logLevel) {
            case 4: {
                Message.debug(msg);
                break;
            }
            case 3: {
                Message.verbose(msg);
                break;
            }
            case 2: {
                Message.info(msg);
                break;
            }
            case 1: {
                Message.warn(msg);
                break;
            }
            case 0: {
                Message.error(msg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level " + logLevel);
            }
        }
    }

    public static List<String> getProblems() {
        return Message.getLogger().getProblems();
    }

    public static void sumupProblems() {
        Message.getLogger().sumupProblems();
    }

    public static void progress() {
        Message.getLogger().progress();
    }

    public static void endProgress() {
        Message.getLogger().endProgress();
    }

    public static void endProgress(String msg) {
        Message.getLogger().endProgress(msg);
    }

    public static boolean isShowProgress() {
        return Message.getLogger().isShowProgress();
    }

    public static void setShowProgress(boolean progress2) {
        Message.getLogger().setShowProgress(progress2);
    }

    private Message() {
    }

    public static void debug(String message2, Throwable t) {
        if (t == null) {
            Message.debug(message2);
        } else {
            Message.debug(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void verbose(String message2, Throwable t) {
        if (t == null) {
            Message.verbose(message2);
        } else {
            Message.verbose(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void info(String message2, Throwable t) {
        if (t == null) {
            Message.info(message2);
        } else {
            Message.info(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void warn(String message2, Throwable t) {
        if (t == null) {
            Message.warn(message2);
        } else {
            Message.warn(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void error(String message2, Throwable t) {
        if (t == null) {
            Message.error(message2);
        } else {
            Message.error(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void debug(Throwable t) {
        Message.debug(StringUtils.getStackTrace(t));
    }
}

