/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.check;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.ivy.core.check.CheckEngineSettings;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class CheckEngine {
    private CheckEngineSettings settings;
    private ResolveEngine resolveEngine;

    public CheckEngine(CheckEngineSettings settings2, ResolveEngine resolveEngine) {
        this.settings = settings2;
        this.resolveEngine = resolveEngine;
    }

    public boolean check(URL ivyFile, String resolvername) {
        try {
            boolean result2 = true;
            ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this.settings, ivyFile, this.settings.doValidate());
            if (resolvername != null) {
                DependencyResolver resolver2 = this.settings.getResolver(resolvername);
                HashSet<Artifact> artifacts = new HashSet<Artifact>();
                for (String string2 : md.getConfigurationsNames()) {
                    artifacts.addAll(Arrays.asList(md.getArtifacts(string2)));
                }
                for (Artifact artifact : artifacts) {
                    if (resolver2.exists(artifact)) continue;
                    Message.info("declared publication not found: " + artifact);
                    result2 = false;
                }
            }
            ResolveData data2 = new ResolveData(this.resolveEngine, new ResolveOptions());
            for (DependencyDescriptor dd : md.getDependencies()) {
                for (String masterConf : dd.getModuleConfigurations()) {
                    if ("*".equals(masterConf.trim()) || md.getConfiguration(masterConf) != null) continue;
                    Message.info("dependency required in non existing conf for " + ivyFile + " \n\tin " + dd + ": " + masterConf);
                    result2 = false;
                }
                DependencyResolver dependencyResolver = this.settings.getResolver(dd.getDependencyRevisionId());
                ResolvedModuleRevision rmr = dependencyResolver.getDependency(dd, data2);
                if (rmr == null) {
                    Message.info("dependency not found in " + ivyFile + ":\n\t" + dd);
                    result2 = false;
                    continue;
                }
                for (String depConf : dd.getDependencyConfigurations(md.getConfigurationsNames())) {
                    if (!Arrays.asList(rmr.getDescriptor().getConfigurationsNames()).contains(depConf)) {
                        Message.info("dependency configuration is missing for " + ivyFile + "\n\tin " + dd + ": " + depConf);
                        result2 = false;
                    }
                    for (Artifact art : rmr.getDescriptor().getArtifacts(depConf)) {
                        if (dependencyResolver.exists(art)) continue;
                        Message.info("dependency artifact is missing for " + ivyFile + "\n\t in " + dd + ": " + art);
                        result2 = false;
                    }
                }
            }
            return result2;
        }
        catch (ParseException e) {
            Message.info("parse problem on " + ivyFile, e);
            return false;
        }
        catch (IOException e) {
            Message.info("io problem on " + ivyFile, e);
            return false;
        }
        catch (Exception e) {
            Message.info("problem on " + ivyFile, e);
            return false;
        }
    }
}

