/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.LocalDate;

public class LocalDateSerializer
extends JodaDateSerializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT, 0);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format2) {
        this(format2, 0);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format2, int shapeOverride) {
        super(LocalDate.class, format2, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalDateSerializer withFormat(JacksonJodaDateFormat formatter2, int shapeOverride) {
        return new LocalDateSerializer(formatter2, shapeOverride);
    }

    public void serialize(LocalDate value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        if (this._serializationShape(provider2) == 1) {
            gen.writeString(this._format.createFormatter(provider2).print(value2));
            return;
        }
        gen.writeStartArray();
        gen.writeNumber(value2.year().get());
        gen.writeNumber(value2.monthOfYear().get());
        gen.writeNumber(value2.dayOfMonth().get());
        gen.writeEndArray();
    }
}

