/*
 * Decompiled with CFR 0.152.
 */
package circlet.pipelines.api;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\n\u0010\u000b\u001a\u00060\u0003j\u0002`\f\u001a.\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\u0014\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0003*\u00020\u0003H\u0002\u001a\n\u0010\u0018\u001a\u00020\u0003*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"notAllowedSymbols", "Lkotlin/text/Regex;", "containerLogFileName", "", "projectKey", "jobName", "stepName", "executionNumber", "", "evaluationLogFileName", "repoName", "commitHash", "Lcirclet/pipelines/common/api/CommitHash;", "internalServiceLogFileName", "serviceType", "jobLogFileName", "serviceLogFileName", "serviceName", "stepActionLogFileName", "actionDisplayName", "sanImg", "sanJob", "sanPr", "sanStep", "sanitizeFilePath", "pipelines-api"})
public final class LogFileNamesKt {
    @NotNull
    private static final Regex notAllowedSymbols = new Regex("[^\\w]");

    @NotNull
    public static final String jobLogFileName(@NotNull String projectKey, @NotNull String jobName, long executionNumber2) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        return LogFileNamesKt.sanPr(projectKey) + '_' + LogFileNamesKt.sanJob(jobName) + '_' + executionNumber2 + "_logs";
    }

    @NotNull
    public static final String evaluationLogFileName(@NotNull String repoName, @NotNull String commitHash) {
        Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        return LogFileNamesKt.sanPr(repoName) + '_' + LogFileNamesKt.sanitizeFilePath(StringsKt.take((String)commitHash, (int)8)) + "_dsl-eval_logs";
    }

    @NotNull
    public static final String containerLogFileName(@NotNull String projectKey, @NotNull String jobName, @NotNull String stepName, long executionNumber2) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter((Object)stepName, (String)"stepName");
        return LogFileNamesKt.sanPr(projectKey) + '_' + LogFileNamesKt.sanJob(jobName) + '_' + executionNumber2 + '_' + LogFileNamesKt.sanStep(stepName) + "_logs";
    }

    @NotNull
    public static final String stepActionLogFileName(@NotNull String projectKey, @NotNull String jobName, @NotNull String stepName, @NotNull String actionDisplayName, long executionNumber2) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter((Object)stepName, (String)"stepName");
        Intrinsics.checkNotNullParameter((Object)actionDisplayName, (String)"actionDisplayName");
        return LogFileNamesKt.sanPr(projectKey) + '_' + LogFileNamesKt.sanJob(jobName) + '_' + executionNumber2 + '_' + LogFileNamesKt.sanStep(stepName) + '_' + actionDisplayName + "_logs";
    }

    @NotNull
    public static final String internalServiceLogFileName(@NotNull String projectKey, @NotNull String jobName, @NotNull String stepName, @NotNull String serviceType, long executionNumber2) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter((Object)stepName, (String)"stepName");
        Intrinsics.checkNotNullParameter((Object)serviceType, (String)"serviceType");
        return LogFileNamesKt.sanPr(projectKey) + '_' + LogFileNamesKt.sanJob(jobName) + '_' + executionNumber2 + '_' + LogFileNamesKt.sanStep(stepName) + '_' + LogFileNamesKt.sanitizeFilePath(StringsKt.take((String)serviceType, (int)20)) + "_logs";
    }

    @NotNull
    public static final String serviceLogFileName(@NotNull String projectKey, @NotNull String jobName, @NotNull String stepName, @NotNull String serviceName, long executionNumber2) {
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter((Object)stepName, (String)"stepName");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return LogFileNamesKt.sanPr(projectKey) + '_' + LogFileNamesKt.sanJob(jobName) + '_' + executionNumber2 + '_' + LogFileNamesKt.sanStep(stepName) + '_' + LogFileNamesKt.sanImg(serviceName) + "_logs";
    }

    @NotNull
    public static final String sanitizeFilePath(@NotNull String $this$sanitizeFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$sanitizeFilePath, (String)"<this>");
        CharSequence charSequence = $this$sanitizeFilePath;
        Regex regex2 = notAllowedSymbols;
        String string2 = "-";
        return regex2.replace(charSequence, string2);
    }

    private static final String sanPr(String $this$sanPr) {
        return LogFileNamesKt.sanitizeFilePath(StringsKt.take((String)$this$sanPr, (int)20));
    }

    private static final String sanJob(String $this$sanJob) {
        return LogFileNamesKt.sanitizeFilePath(StringsKt.take((String)$this$sanJob, (int)100));
    }

    private static final String sanStep(String $this$sanStep) {
        return LogFileNamesKt.sanitizeFilePath(StringsKt.take((String)$this$sanStep, (int)100));
    }

    private static final String sanImg(String $this$sanImg) {
        return LogFileNamesKt.sanitizeFilePath(StringsKt.take((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)$this$sanImg, (String)"/", null, (int)2, null), (String)":", null, (int)2, null), (int)100));
    }
}

