/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ikv;

import com.intellij.util.lang.ByteBufferCleaner;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ikv.RecSplitEvaluator;
import org.jetbrains.ikv.RecSplitSettings;
import org.jetbrains.ikv.UniversalHash;

@ApiStatus.Internal
public abstract class Ikv<T>
implements AutoCloseable {
    public final RecSplitEvaluator<T> evaluator;
    protected ByteBuffer mappedBuffer;

    public ByteBuffer getMappedBufferAt(int position) {
        return this.mappedBuffer.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN).position(position);
    }

    private Ikv(RecSplitEvaluator<T> evaluator, ByteBuffer mappedBuffer) {
        this.evaluator = evaluator;
        this.mappedBuffer = mappedBuffer;
    }

    @NotNull
    public static <T> SizeAwareIkv<T> loadSizeAwareIkv(@NotNull Path file2, UniversalHash<T> hash) throws IOException {
        if (file2 == null) {
            Ikv.$$$reportNull$$$0(0);
        }
        return (SizeAwareIkv)Ikv.doLoadIkv(file2, hash, RecSplitSettings.DEFAULT_SETTINGS);
    }

    @NotNull
    public static <T> SizeUnawareIkv<T> loadSizeUnawareIkv(@NotNull Path file2, UniversalHash<T> hash) throws IOException {
        if (file2 == null) {
            Ikv.$$$reportNull$$$0(1);
        }
        return (SizeUnawareIkv)Ikv.doLoadIkv(file2, hash, RecSplitSettings.DEFAULT_SETTINGS);
    }

    @NotNull
    public static <T> Ikv<T> doLoadIkv(@NotNull Path file2, UniversalHash<T> hash, RecSplitSettings settings) throws IOException {
        ByteBuffer mappedBuffer;
        int fileSize;
        if (file2 == null) {
            Ikv.$$$reportNull$$$0(2);
        }
        try (FileChannel fileChannel = FileChannel.open(file2, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            fileSize = (int)fileChannel.size();
            try {
                mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            }
            catch (UnsupportedOperationException e) {
                mappedBuffer = ByteBuffer.allocate(fileSize);
                while (mappedBuffer.hasRemaining()) {
                    fileChannel.read(mappedBuffer);
                }
                mappedBuffer.rewind();
            }
        }
        mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        mappedBuffer.position(fileSize);
        return Ikv.loadIkv(mappedBuffer, hash, settings);
    }

    @NotNull
    public static <T> Ikv<T> loadIkv(@NotNull ByteBuffer mappedBuffer, @NotNull UniversalHash<T> hash, @NotNull RecSplitSettings settings) {
        if (mappedBuffer == null) {
            Ikv.$$$reportNull$$$0(3);
        }
        if (hash == null) {
            Ikv.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            Ikv.$$$reportNull$$$0(5);
        }
        int position = mappedBuffer.position() - 1 - 8;
        mappedBuffer.position(position);
        int entryCount = mappedBuffer.getInt();
        int keyDataSize = mappedBuffer.getInt();
        boolean withSize = mappedBuffer.get() == 1;
        int offsetAndSizePairsDataSize = entryCount * (withSize ? 8 : 4);
        mappedBuffer.position(position -= keyDataSize + offsetAndSizePairsDataSize);
        ByteBuffer keyData = mappedBuffer.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        keyData.limit(position + keyDataSize);
        mappedBuffer.position(position += keyDataSize);
        if (withSize) {
            long[] offsetAndSizePairs = new long[entryCount];
            mappedBuffer.asLongBuffer().get(offsetAndSizePairs);
            return new SizeAwareIkv<T>(new RecSplitEvaluator<T>(keyData, hash, settings), mappedBuffer, offsetAndSizePairs);
        }
        int[] valueOffsets = new int[entryCount];
        mappedBuffer.asIntBuffer().get(valueOffsets);
        return new SizeUnawareIkv<T>(new RecSplitEvaluator<T>(keyData, hash, settings), mappedBuffer, valueOffsets);
    }

    @Override
    public void close() throws Exception {
        ByteBuffer buffer = this.mappedBuffer;
        if (buffer != null) {
            this.mappedBuffer = null;
            ByteBufferCleaner.unmapBuffer(buffer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedBuffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/ikv/Ikv";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSizeAwareIkv";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSizeUnawareIkv";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doLoadIkv";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadIkv";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class SizeUnawareIkv<T>
    extends Ikv<T> {
        private final int[] offsets;

        private SizeUnawareIkv(RecSplitEvaluator<T> evaluator, ByteBuffer mappedBuffer, int[] offsets) {
            super(evaluator, mappedBuffer);
            this.offsets = offsets;
        }

        public ByteBuffer getUnboundedValue(T key) {
            int index = this.evaluator.evaluate(key);
            if (index < 0) {
                return null;
            }
            return this.mappedBuffer.asReadOnlyBuffer().position(this.offsets[index]).order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public static final class SizeAwareIkv<T>
    extends Ikv<T> {
        private final long[] offsetAndSizePairs;

        private SizeAwareIkv(RecSplitEvaluator<T> evaluator, ByteBuffer mappedBuffer, long[] offsetAndSizePairs) {
            super(evaluator, mappedBuffer);
            this.offsetAndSizePairs = offsetAndSizePairs;
        }

        public ByteBuffer getValue(T key) {
            int index = this.evaluator.evaluate(key);
            return index < 0 ? null : this.getByteBufferAt(index);
        }

        public int getIndex(T key) {
            return this.evaluator.evaluate(key);
        }

        public int getSizeAt(int index) {
            return (int)this.offsetAndSizePairs[index];
        }

        public ByteBuffer getByteBufferAt(int index) {
            long pair = this.offsetAndSizePairs[index];
            int start = (int)(pair >> 32);
            ByteBuffer buffer = this.mappedBuffer.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
            buffer.position(start);
            buffer.limit(start + (int)pair);
            return buffer;
        }

        public byte @NotNull [] getByteArrayAt(int index) {
            ByteBuffer buffer = this.getByteBufferAt(index);
            byte[] result = new byte[buffer.remaining()];
            buffer.get(result);
            if (result == null) {
                SizeAwareIkv.$$$reportNull$$$0(0);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ikv/Ikv$SizeAwareIkv", "getByteArrayAt"));
        }
    }
}

