/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.DirectByteBufferBackedInputStream;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.ZipFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.zip.ZipException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ikv.Ikv;
import org.jetbrains.ikv.RecSplitSettings;
import org.jetbrains.ikv.UniversalHash;
import org.jetbrains.xxh3.Xxh3;

@ApiStatus.Internal
public final class ImmutableZipFile
implements ZipFile {
    public static final int MIN_EOCD_SIZE = 22;
    public static final int EOCD = 101010256;
    private static final int INDEX_FORMAT_VERSION = 3;
    private static final int COMMENT_SIZE = 5;
    private final Ikv.SizeAwareIkv<String> ikv;
    private final int nameDataPosition;
    private volatile String[] names;
    public final long[] classPackages;
    public final long[] resourcePackages;
    private final long[] hashes;

    private ImmutableZipFile(Ikv.SizeAwareIkv<String> ikv, long[] hashes, long[] classPackages, long[] resourcePackages, int nameDataPosition) {
        this.ikv = ikv;
        this.hashes = hashes;
        this.nameDataPosition = nameDataPosition;
        this.classPackages = classPackages;
        this.resourcePackages = resourcePackages;
    }

    @NotNull
    public static ZipFile load(@NotNull Path file2) throws IOException {
        if (file2 == null) {
            ImmutableZipFile.$$$reportNull$$$0(0);
        }
        return ImmutableZipFile.load(file2, false);
    }

    @NotNull
    static ZipFile load(@NotNull Path file2, boolean forceNonIkv) throws IOException {
        ByteBuffer mappedBuffer;
        int fileSize;
        if (file2 == null) {
            ImmutableZipFile.$$$reportNull$$$0(1);
        }
        try (FileChannel fileChannel = FileChannel.open(file2, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            fileSize = (int)fileChannel.size();
            try {
                mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            }
            catch (UnsupportedOperationException e) {
                ByteBuffer buffer = ByteBuffer.allocate(fileSize);
                while (buffer.hasRemaining()) {
                    fileChannel.read(buffer);
                }
                buffer.rewind();
                mappedBuffer = buffer;
            }
            mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        try {
            return ImmutableZipFile.populateFromCentralDirectory(mappedBuffer, fileSize, forceNonIkv);
        }
        catch (IOException e) {
            throw new IOException(file2.toString(), e);
        }
    }

    private int getIndex(String path) {
        long hashCode = Xxh3.hash(path);
        int index = this.ikv.evaluator.evaluate(path, hashCode, UniversalHash.StringHash.INSTANCE);
        if (index < 0) {
            return -1;
        }
        if (this.hashes[index] != hashCode) {
            return -1;
        }
        return index;
    }

    public synchronized String[] getOrComputeNames() {
        String[] names = this.names;
        if (names != null) {
            return names;
        }
        byte[] tempNameBytes = new byte[4096];
        int entryCount = this.hashes.length;
        names = new String[entryCount];
        short[] nameLengthInBytes = new short[entryCount];
        ByteBuffer buffer = this.ikv.getMappedBufferAt(this.nameDataPosition);
        buffer.asShortBuffer().get(nameLengthInBytes);
        buffer.position(buffer.position() + entryCount * 2);
        for (int i = 0; i < entryCount; ++i) {
            short sizeInBytes = nameLengthInBytes[i];
            buffer.get(tempNameBytes, 0, sizeInBytes);
            names[i] = new String(tempNameBytes, 0, (int)sizeInBytes, StandardCharsets.UTF_8);
        }
        this.names = names;
        return names;
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> nameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        String[] names;
        if (dir == null) {
            ImmutableZipFile.$$$reportNull$$$0(2);
        }
        if (nameFilter == null) {
            ImmutableZipFile.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            ImmutableZipFile.$$$reportNull$$$0(4);
        }
        if ((names = this.names) == null) {
            names = this.getOrComputeNames();
        }
        int minNameLength = dir.length() + 2;
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            String name = names[i];
            if (name.length() < minNameLength || name.charAt(dir.length()) != '/' || !name.startsWith(dir) || !nameFilter.test(name)) continue;
            try (DirectByteBufferBackedInputStream stream = new DirectByteBufferBackedInputStream(this.ikv.getByteBufferAt(i), false);){
                consumer.accept(name, stream);
                continue;
            }
        }
    }

    @Override
    @Nullable
    public InputStream getInputStream(@NotNull String path) throws IOException {
        int index;
        if (path == null) {
            ImmutableZipFile.$$$reportNull$$$0(5);
        }
        if ((index = this.getIndex(path)) < 0) {
            return null;
        }
        return new DirectByteBufferBackedInputStream(this.ikv.getByteBufferAt(index), false);
    }

    @Override
    public byte @Nullable [] getData(@NotNull String path) throws IOException {
        int index;
        if (path == null) {
            ImmutableZipFile.$$$reportNull$$$0(6);
        }
        if ((index = this.getIndex(path)) < 0) {
            return null;
        }
        return this.ikv.getByteArrayAt(index);
    }

    @Override
    public ByteBuffer getByteBuffer(@NotNull String path) throws IOException {
        int index;
        if (path == null) {
            ImmutableZipFile.$$$reportNull$$$0(7);
        }
        if ((index = this.getIndex(path)) < 0) {
            return null;
        }
        return this.ikv.getByteBufferAt(index);
    }

    @Override
    @Nullable
    public ZipFile.ZipResource getResource(String path) {
        int index = this.getIndex(path);
        return index < 0 ? null : new MyZipResource(index, this.ikv, path);
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
    }

    @NotNull
    private static ZipFile populateFromCentralDirectory(ByteBuffer buffer, int fileSize, boolean forceNonIkv) throws IOException {
        byte commentVersion;
        int centralDirPosition;
        int centralDirSize;
        int entryCount;
        int offset;
        boolean finished = false;
        for (offset = fileSize - 22; offset >= 0; --offset) {
            if (buffer.getInt(offset) != 101010256) continue;
            finished = true;
            break;
        }
        if (!finished) {
            throw new ZipException("Archive is not a ZIP archive");
        }
        boolean isZip64 = true;
        if (buffer.getInt(offset - 20) == 117853008) {
            offset = (int)buffer.getLong(offset - 12);
            assert (buffer.getInt(offset) == 101075792);
        } else {
            isZip64 = false;
        }
        int indexDataEnd = -1;
        if (isZip64) {
            entryCount = (int)buffer.getLong(offset + 32);
            centralDirSize = (int)buffer.getLong(offset + 40);
            centralDirPosition = (int)buffer.getLong(offset + 48);
            int commentSize = (int)(buffer.getLong(offset + 4) + 12L) - 56;
            byte by = commentVersion = commentSize == 5 ? buffer.get(offset + 56) : (byte)0;
            if (commentVersion == 3) {
                indexDataEnd = buffer.getInt(offset + 56 + 1);
            }
        } else {
            entryCount = buffer.getShort(offset + 10) & 0xFFFF;
            centralDirSize = buffer.getInt(offset + 12);
            centralDirPosition = buffer.getInt(offset + 16);
            short commentSize = buffer.getShort(offset + 20);
            byte by = commentVersion = commentSize == 5 ? buffer.get(offset + 22) : (byte)0;
            if (commentVersion == 3) {
                indexDataEnd = buffer.getInt(offset + 22 + 1);
            }
        }
        if (forceNonIkv || commentVersion != 3 || entryCount == 0) {
            HashMapZipFile hashMapZipFile = HashMapZipFile.createHashMapZipFile(buffer, fileSize, entryCount, centralDirSize, centralDirPosition);
            if (hashMapZipFile == null) {
                ImmutableZipFile.$$$reportNull$$$0(8);
            }
            return hashMapZipFile;
        }
        buffer.position(indexDataEnd);
        Ikv.SizeAwareIkv ikv = (Ikv.SizeAwareIkv)Ikv.loadIkv(buffer, UniversalHash.StringHash.INSTANCE, RecSplitSettings.DEFAULT_SETTINGS);
        buffer.position(indexDataEnd);
        long[] classPackages = new long[buffer.getInt()];
        long[] resourcePackages = new long[buffer.getInt()];
        LongBuffer longBuffer = buffer.asLongBuffer();
        longBuffer.get(classPackages);
        longBuffer.get(resourcePackages);
        buffer.position(buffer.position() + longBuffer.position() * 8);
        long[] hashes = new long[buffer.getInt()];
        buffer.asLongBuffer().get(hashes);
        buffer.position(buffer.position() + hashes.length * 8);
        int nameDataPosition = buffer.position();
        buffer.clear();
        return new ImmutableZipFile(ikv, hashes, classPackages, resourcePackages, nameDataPosition);
    }

    @Override
    public void close() throws Exception {
        this.ikv.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ImmutableZipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ImmutableZipFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "populateFromCentralDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getByteBuffer";
                break;
            }
            case 8: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyZipResource
    implements ZipFile.ZipResource {
        private final int index;
        private final Ikv.SizeAwareIkv<String> ikv;
        private final String path;

        MyZipResource(int index, Ikv.SizeAwareIkv<String> ikv, String path) {
            this.index = index;
            this.ikv = ikv;
            this.path = path;
        }

        @Override
        public int getUncompressedSize() {
            return this.ikv.getSizeAt(this.index);
        }

        @Override
        @NotNull
        public String getPath() {
            String string2 = this.path;
            if (string2 == null) {
                MyZipResource.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public ByteBuffer getByteBuffer() {
            ByteBuffer byteBuffer = this.ikv.getByteBufferAt(this.index);
            if (byteBuffer == null) {
                MyZipResource.$$$reportNull$$$0(1);
            }
            return byteBuffer;
        }

        @Override
        public byte @NotNull [] getData() {
            byte[] byArray = this.ikv.getByteArrayAt(this.index);
            if (byArray == null) {
                MyZipResource.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        @Override
        @NotNull
        public InputStream getInputStream() {
            return new DirectByteBufferBackedInputStream(this.ikv.getByteBufferAt(this.index), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/lang/ImmutableZipFile$MyZipResource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getByteBuffer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

