/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.CutCopyPasteSupport;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.Painter;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class ResizeProcessor
extends EventProcessor {
    private final RadComponent myComponent;
    private final int myResizeMask;
    private Point myLastPoint;
    private Rectangle myBounds;
    private Rectangle myOriginalBounds;
    private final RadContainer myOriginalParent;
    private final GuiEditor myEditor;
    private final GridConstraints myOriginalConstraints;
    private RadComponent myResizedCopy;

    public ResizeProcessor(GuiEditor editor, RadComponent component, int resizeMask) {
        this.myEditor = editor;
        if (component.getParent() == null) {
            throw new IllegalArgumentException("parent is null for " + component);
        }
        this.myComponent = component;
        this.myOriginalParent = component.getParent();
        this.myOriginalConstraints = component.getConstraints();
        List<RadComponent> copyList = CutCopyPasteSupport.copyComponents(editor, Collections.singletonList(component));
        if (component.getParent().getLayoutManager().isGrid() && copyList != null) {
            this.myComponent.setResizing(true);
            Rectangle rc = SwingUtilities.convertRectangle(component.getParent().getDelegee(), component.getBounds(), this.myEditor.getDragLayer());
            component.setDragging(true);
            component.setSelected(false);
            this.myResizedCopy = copyList.get(0);
            this.myResizedCopy.setBounds(rc);
            this.myResizedCopy.setSelected(true);
            editor.getDragLayer().add(this.myResizedCopy.getDelegee());
        }
        this.myResizeMask = resizeMask;
        this.setCursor(this.getResizeCursor());
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.myLastPoint = e.getPoint();
            this.myBounds = this.myOriginalParent.getLayoutManager().isGrid() ? this.myResizedCopy.getBounds() : this.myComponent.getBounds();
            this.myOriginalBounds = new Rectangle(this.myBounds);
        } else if (e.getID() == 506) {
            Rectangle newBounds;
            int dx = e.getX() - this.myLastPoint.x;
            int dy = e.getY() - this.myLastPoint.y;
            if (this.myOriginalParent.getLayoutManager().isGrid()) {
                Point point = SwingUtilities.convertPoint(this.myEditor.getDragLayer(), e.getX(), e.getY(), this.myOriginalParent.getDelegee());
                this.putGridSpanFeedback(point);
            } else if (this.myOriginalParent.isXY()) {
                this.myEditor.getActiveDecorationLayer().removeFeedback();
                this.setCursor(this.getResizeCursor());
            } else {
                return;
            }
            GridConstraints constraints = this.myComponent.getConstraints();
            if ((this.myResizeMask & 1) != 0) {
                this.myBounds.x += dx;
                this.myBounds.width -= dx;
            }
            if ((this.myResizeMask & 2) != 0) {
                this.myBounds.width += dx;
            }
            if ((this.myResizeMask & 4) != 0) {
                this.myBounds.y += dy;
                this.myBounds.height -= dy;
            }
            if ((this.myResizeMask & 8) != 0) {
                this.myBounds.height += dy;
            }
            Dimension minSize = this.myComponent.getMinimumSize();
            Rectangle rectangle = newBounds = this.myOriginalParent.getLayoutManager().isGrid() ? this.myResizedCopy.getBounds() : this.myComponent.getBounds();
            if (this.myBounds.width >= minSize.width) {
                newBounds.x = this.myBounds.x;
                newBounds.width = this.myBounds.width;
            } else if ((this.myResizeMask & 1) != 0) {
                newBounds.x = newBounds.x + newBounds.width - minSize.width;
                newBounds.width = minSize.width;
            } else if ((this.myResizeMask & 2) != 0) {
                newBounds.width = minSize.width;
            }
            if (this.myBounds.height >= minSize.height) {
                newBounds.y = this.myBounds.y;
                newBounds.height = this.myBounds.height;
            } else if ((this.myResizeMask & 4) != 0) {
                newBounds.y = newBounds.y + newBounds.height - minSize.height;
                newBounds.height = minSize.height;
            } else if ((this.myResizeMask & 8) != 0) {
                newBounds.height = minSize.height;
            }
            Dimension size = newBounds.getSize();
            Util.adjustSize((Component)this.myComponent.getDelegee(), (GridConstraints)constraints, (Dimension)size);
            newBounds.width = size.width;
            newBounds.height = size.height;
            if (this.myOriginalParent.getLayoutManager().isGrid()) {
                this.myResizedCopy.setBounds(newBounds);
            } else if (this.myEditor.ensureEditable()) {
                this.myComponent.setBounds(newBounds);
            }
            this.myEditor.refresh();
            this.myLastPoint = e.getPoint();
        } else if (e.getID() == 502) {
            boolean modified = false;
            this.myComponent.getDelegee().setVisible(true);
            this.myComponent.setResizing(false);
            this.myComponent.setSelected(true);
            if (this.myResizedCopy != null) {
                this.myEditor.getDragLayer().remove(this.myResizedCopy.getDelegee());
            }
            if (this.myOriginalParent.getLayoutManager().isGrid() && this.myEditor.ensureEditable()) {
                Point point = SwingUtilities.convertPoint(this.myEditor.getDragLayer(), e.getX(), e.getY(), this.myOriginalParent.getDelegee());
                Rectangle rcGrid = ResizeProcessor.getGridSpanGridRect(this.myOriginalParent, this.myOriginalConstraints, point, this.myResizeMask);
                if (rcGrid != null && this.isGridSpanDropAllowed(rcGrid)) {
                    GridConstraints oldConstraints = (GridConstraints)this.myOriginalConstraints.clone();
                    this.myOriginalConstraints.setColumn(rcGrid.x);
                    this.myOriginalConstraints.setRow(rcGrid.y);
                    this.myOriginalConstraints.setColSpan(rcGrid.width);
                    this.myOriginalConstraints.setRowSpan(rcGrid.height);
                    this.myComponent.fireConstraintsChanged(oldConstraints);
                    modified = true;
                }
            } else {
                modified = true;
            }
            this.myEditor.getActiveDecorationLayer().removeFeedback();
            this.myComponent.setDragging(false);
            if (modified && this.myEditor.ensureEditable()) {
                this.myEditor.refreshAndSave(true);
            }
        }
    }

    private Cursor getResizeCursor() {
        return Cursor.getPredefinedCursor(Painter.getResizeCursor(this.myResizeMask));
    }

    private void putGridSpanFeedback(Point point) {
        Rectangle rcGrid = ResizeProcessor.getGridSpanGridRect(this.myOriginalParent, this.myOriginalConstraints, point, this.myResizeMask);
        if (rcGrid != null) {
            Rectangle rc = this.myOriginalParent.getGridLayoutManager().getGridCellRangeRect(this.myOriginalParent, rcGrid.y, rcGrid.x, rcGrid.y + rcGrid.height - 1, rcGrid.x + rcGrid.width - 1);
            String tooltip = UIDesignerBundle.message("resize.feedback", this.myComponent.getDisplayName(), rcGrid.height, rcGrid.width);
            this.myEditor.getActiveDecorationLayer().putFeedback(this.myOriginalParent.getDelegee(), rc, tooltip);
            this.setCursor(this.isGridSpanDropAllowed(rcGrid) ? this.getResizeCursor() : FormEditingUtil.getMoveNoDropCursor());
        } else {
            this.setCursor(this.getResizeCursor());
            this.myEditor.getActiveDecorationLayer().removeFeedback();
        }
    }

    @Nullable
    static Rectangle getGridSpanGridRect(RadContainer grid, GridConstraints originalConstraints, Point point, int resizeMask) {
        int colAtMouse;
        int rowAtMouse = (resizeMask & 0xC) != 0 ? grid.getGridRowAt(point.y) : -1;
        int n = colAtMouse = (resizeMask & 3) != 0 ? grid.getGridColumnAt(point.x) : -1;
        if (rowAtMouse != -1 || colAtMouse != -1) {
            int origStartCol = originalConstraints.getColumn();
            int origEndCol = originalConstraints.getColumn() + originalConstraints.getColSpan() - 1;
            int startCol = origStartCol;
            int endCol = origEndCol;
            if (colAtMouse >= 0) {
                if ((resizeMask & 1) != 0 && colAtMouse <= endCol) {
                    startCol = colAtMouse;
                } else if ((resizeMask & 2) != 0 && colAtMouse >= startCol) {
                    endCol = colAtMouse;
                }
            }
            int origStartRow = originalConstraints.getRow();
            int origEndRow = originalConstraints.getRow() + originalConstraints.getRowSpan() - 1;
            int startRow = origStartRow;
            int endRow = origEndRow;
            if (rowAtMouse >= 0) {
                if ((resizeMask & 4) != 0 && rowAtMouse <= endRow) {
                    startRow = rowAtMouse;
                } else if ((resizeMask & 8) != 0 && rowAtMouse >= startRow) {
                    endRow = rowAtMouse;
                }
            }
            return new Rectangle(startCol, startRow, endCol - startCol + 1, endRow - startRow + 1);
        }
        return null;
    }

    @Override
    protected boolean cancelOperation() {
        this.myComponent.setBounds(this.myOriginalBounds);
        this.myComponent.setResizing(false);
        this.myComponent.setDragging(false);
        if (this.myResizedCopy != null) {
            this.myEditor.getDragLayer().remove(this.myResizedCopy.getDelegee());
            this.myResizedCopy = null;
        }
        this.myEditor.refresh();
        return true;
    }

    private boolean isGridSpanDropAllowed(Rectangle rcGrid) {
        return this.myOriginalParent.findComponentInRect(rcGrid.y, rcGrid.x, rcGrid.height, rcGrid.width) == null;
    }
}

