/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateMainAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(GenerateMainAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GenerateMainAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LwRootContainer rootContainer;
        if (e == null) {
            GenerateMainAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        assert (editor != null);
        int offset = editor.getCaretModel().getOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiClass.class);
        assert (psiClass != null);
        if (!PsiUtil.hasDefaultConstructor((PsiClass)psiClass)) {
            Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("generate.main.no.default.constructor", new Object[0]), (String)UIDesignerBundle.message("generate.main.title", new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        List<PsiFile> boundForms = FormClassIndex.findFormsBoundToClass(project, psiClass.getQualifiedName());
        try {
            rootContainer = Utils.getRootContainer((String)boundForms.get(0).getText(), null);
        }
        catch (AlienFormFileException ex) {
            Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("generate.main.not.valid.form", new Object[0]), (String)UIDesignerBundle.message("generate.main.title", new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return;
        }
        if (rootContainer.getComponentCount() == 0) {
            Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("generate.main.empty.form", new Object[0]), (String)UIDesignerBundle.message("generate.main.title", new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        String rootBinding = rootContainer.getComponent(0).getBinding();
        if (rootBinding == null || psiClass.findFieldByName(rootBinding, true) == null) {
            Messages.showMessageDialog((Project)project, (String)UIDesignerBundle.message("generate.main.no.root.binding", new Object[0]), (String)UIDesignerBundle.message("generate.main.title", new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        @NonNls StringBuilder mainBuilder = new StringBuilder("public static void main(String[] args) { ");
        JavaCodeStyleManager csm = JavaCodeStyleManager.getInstance((Project)project);
        SuggestedNameInfo nameInfo = csm.suggestVariableName(VariableKind.LOCAL_VARIABLE, "frame", null, null);
        String varName = nameInfo.names[0];
        mainBuilder.append(JFrame.class.getName()).append(" ").append(varName).append("= new ").append(JFrame.class.getName());
        mainBuilder.append("(\"").append(psiClass.getName()).append("\");");
        mainBuilder.append(varName).append(".setContentPane(new ").append(psiClass.getQualifiedName()).append("().").append(rootBinding).append(");");
        mainBuilder.append(varName).append(".setDefaultCloseOperation(").append(JFrame.class.getName()).append(".EXIT_ON_CLOSE);");
        mainBuilder.append(varName).append(".pack();");
        mainBuilder.append(varName).append(".setVisible(true);");
        mainBuilder.append("}\n");
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                PsiMethod method = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory().createMethodFromText(mainBuilder.toString(), (PsiElement)file);
                List<PsiGenerationInfo> infos = Collections.singletonList(new PsiGenerationInfo((PsiMember)method));
                List resultMembers = GenerateMembersUtil.insertMembersAtOffset((PsiFile)file, (int)offset, infos);
                ((PsiGenerationInfo)resultMembers.get(0)).positionCaret(editor, false);
            }
            catch (IncorrectOperationException e1) {
                LOG.error((Throwable)e1);
            }
        }), null, null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateMainAction.$$$reportNull$$$0(2);
        }
        boolean enabled = GenerateMainAction.isActionEnabled(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
    }

    private static boolean isActionEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return false;
        }
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        if (PsiMethodUtil.findMainMethod((PsiClass)psiClass) != null) {
            return false;
        }
        return !FormClassIndex.findFormsBoundToClass(project, psiClass).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/actions/GenerateMainAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/actions/GenerateMainAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

