/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHEnterpriseServerMeta;
import org.jetbrains.plugins.github.util.GHEnterpriseServerMetadataLoader;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GHEServerVersionChecker;", "", "()V", "checkVersionSupported", "", "endpointUrl", "", "throwUnsupportedVersion", "currentMajor", "", "currentMinor", "intellij.vcs.github"})
public final class GHEServerVersionChecker {
    public final void checkVersionSupported(@NotNull String endpointUrl) {
        block7: {
            int minorVersion;
            int majorVersion;
            block6: {
                Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
                majorVersion = 0;
                minorVersion = 0;
                try {
                    boolean $i$f$service = false;
                    Class<GHEnterpriseServerMetadataLoader> serviceClass$iv = GHEnterpriseServerMetadataLoader.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    CompletableFuture<GHEnterpriseServerMeta> completableFuture = ((GHEnterpriseServerMetadataLoader)object).findRequestByEndpointUrl$intellij_vcs_github(endpointUrl);
                    if (completableFuture == null) {
                        return;
                    }
                    CompletableFuture<GHEnterpriseServerMeta> metadataRequest = completableFuture;
                    GHEnterpriseServerMeta gHEnterpriseServerMeta = (GHEnterpriseServerMeta)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)metadataRequest);
                    if (gHEnterpriseServerMeta == null) {
                        return;
                    }
                    GHEnterpriseServerMeta serverMeta = gHEnterpriseServerMeta;
                    List versionSplit = StringsKt.split$default((CharSequence)serverMeta.getInstalledVersion(), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                    String string = (String)versionSplit.get(0);
                    majorVersion = Integer.parseInt(string);
                    string = (String)versionSplit.get(1);
                    minorVersion = Integer.parseInt(string);
                }
                catch (Throwable e) {
                    throw (Throwable)new IllegalStateException("Could not determine GitHub Enterprise server version", e);
                }
                if (majorVersion > 2) {
                    return;
                }
                if (majorVersion >= 2) break block6;
                this.throwUnsupportedVersion(majorVersion, minorVersion);
                break block7;
            }
            if (majorVersion != 2 || minorVersion >= 21) break block7;
            this.throwUnsupportedVersion(majorVersion, minorVersion);
        }
    }

    private final void throwUnsupportedVersion(int currentMajor, int currentMinor) {
        String string = "Unsupported GitHub Enterprise server version " + currentMajor + "." + currentMinor + ". Earliest supported version is 2.21";
        throw new IllegalStateException(string.toString());
    }
}

