/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.accessor.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.io.NettyKt;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorReference;
import org.intellij.plugins.markdown.settings.DocumentLinksSafeState;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.accessor.MarkdownLinkOpener;
import org.intellij.plugins.markdown.util.MarkdownDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001a\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl;", "Lorg/intellij/plugins/markdown/ui/preview/accessor/MarkdownLinkOpener;", "()V", "actuallyBrowseExternalLink", "", "project", "Lcom/intellij/openapi/project/Project;", "uri", "Ljava/net/URI;", "createDoNotAskOption", "Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "isSafeLink", "", "link", "", "isSafeUri", "openExternalLink", "openLink", "Companion", "intellij.markdown.core"})
public final class MarkdownLinkOpenerImpl
implements MarkdownLinkOpener {
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    public void openLink(@Nullable Project project, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        URI uRI = Companion.createUri(link);
        if (uRI == null) {
            return;
        }
        URI uri = uRI;
        if (MarkdownLinkOpenerImpl.Companion.tryOpenInEditor(uri)) {
            return;
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(this, project, uri){
            final /* synthetic */ MarkdownLinkOpenerImpl this$0;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ URI $uri$inlined;
            {
                this.this$0 = markdownLinkOpenerImpl;
                this.$project$inlined = project;
                this.$uri$inlined = uRI;
            }

            public final void run() {
                boolean bl = false;
                MarkdownLinkOpenerImpl.access$openExternalLink(this.this$0, this.$project$inlined, this.$uri$inlined);
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
    }

    @Override
    public boolean isSafeLink(@Nullable Project project, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        URI uRI = Companion.createUri(link);
        if (uRI == null) {
            return false;
        }
        URI uri = uRI;
        return this.isSafeUri(project, uri);
    }

    private final boolean isSafeUri(Project project, URI uri) {
        String string = uri.getScheme();
        if (string == null) {
            return false;
        }
        String protocol = string;
        if (project != null) {
            DocumentLinksSafeState safeLinksState = DocumentLinksSafeState.Companion.getInstance(project);
            return safeLinksState.isProtocolAllowed(protocol);
        }
        return DocumentLinksSafeState.Companion.isHttpScheme(protocol) && MarkdownLinkOpenerImpl.Companion.isLocalHost(uri.getHost());
    }

    @RequiresEdt
    private final void openExternalLink(Project project, URI uri) {
        if (this.isSafeUri(project, uri)) {
            this.actuallyBrowseExternalLink(project, uri);
            return;
        }
        String string = MarkdownBundle.message("markdown.browse.external.link.open.confirmation.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026nfirmation.dialog.title\")");
        String string2 = MarkdownBundle.message("markdown.browse.external.link.open.confirmation.dialog.text", uri);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026mation.dialog.text\", uri)");
        String string3 = Messages.getOkButton();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Messages.getOkButton()");
        int dialogResult = MessageUtil.showOkCancelDialog$default((String)string, (String)string2, (String)string3, null, null, (DialogWrapper.DoNotAskOption)this.createDoNotAskOption(project, uri), (Project)project, (int)24, null);
        if (dialogResult == 0) {
            this.actuallyBrowseExternalLink(project, uri);
        }
    }

    @RequiresEdt
    private final void actuallyBrowseExternalLink(Project project, URI uri) {
        try {
            BrowserUtil.browse((URI)uri);
        }
        catch (Throwable exception) {
            logger.warn("Failed to browse external link!", exception);
            String string = MarkdownBundle.message("markdown.browse.external.link.failed.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026iled.notification.title\")");
            String string2 = MarkdownBundle.message("markdown.browse.external.link.failed.notification.content", uri);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026tification.content\", uri)");
            MarkdownNotifications.INSTANCE.showWarning(project, "markdown.links.external.open.failed", string, string2);
        }
    }

    private final DialogWrapper.DoNotAskOption createDoNotAskOption(Project project, URI uri) {
        if (project == null) {
            return null;
        }
        String protocol = uri.getScheme();
        if (protocol == null) {
            logger.error("Failed to obtain protocol for link: " + uri);
            return null;
        }
        return (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(project, protocol){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $protocol;

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected) {
                    DocumentLinksSafeState.Companion.getInstance(this.$project).allowProtocol(this.$protocol);
                }
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = MarkdownBundle.message("markdown.browse.external.link.open.confirmation.dialog.do.not.ask.again.text", this.$protocol);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026sk.again.text\", protocol)");
                return string;
            }
            {
                this.$project = $captured_local_variable$0;
                this.$protocol = $captured_local_variable$1;
            }
        };
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkdownLinkOpenerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        MarkdownLinkOpenerImpl.logger = logger;
    }

    public static final /* synthetic */ void access$openExternalLink(MarkdownLinkOpenerImpl $this, Project project, URI uri) {
        $this.openExternalLink(project, uri);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u001e\u0010\u001c\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001e2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "actuallyOpenInEditor", "", "uri", "Ljava/net/URI;", "createUri", "link", "", "isLocalHost", "hostName", "navigateToHeader", "", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "item", "Lcom/intellij/psi/PsiElement;", "obtainHeadersPopupPosition", "Lcom/intellij/ui/awt/RelativePoint;", "project", "Lcom/intellij/openapi/project/Project;", "showCannotNavigateNotification", "anchor", "point", "showHeadersPopup", "headers", "", "tryOpenInEditor", "HeadersPopup", "intellij.markdown.core"})
    public static final class Companion {
        @Nullable
        public final URI createUri(@NotNull String link) {
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            try {
                uRI = BrowserUtil.isAbsoluteURL((String)link) ? new URI(link) : new URI("http://" + link);
            }
            catch (URISyntaxException exception) {
                logger.warn((Throwable)exception);
                uRI = null;
            }
            return uRI;
        }

        private final boolean isLocalHost(String hostName) {
            return hostName == null || StringsKt.startsWith$default((String)hostName, (String)"127.", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)hostName, (String)":1", (boolean)false, (int)2, null) || NettyKt.isLocalHost((String)hostName, (boolean)false, (boolean)false);
        }

        private final boolean tryOpenInEditor(URI uri) {
            if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file") ^ true) {
                return false;
            }
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(uri){
                final /* synthetic */ URI $uri$inlined;
                {
                    this.$uri$inlined = uRI;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)Boolean.valueOf(org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$actuallyOpenInEditor(MarkdownLinkOpenerImpl.Companion, this.$uri$inlined));
                }
            });
        }

        private final boolean actuallyOpenInEditor(URI uri) {
            String anchor = uri.getFragment();
            String path = uri.getPath();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ath(path) ?: return false");
            VirtualFile targetFile = virtualFile;
            Project project = ProjectUtil.guessProjectForFile((VirtualFile)targetFile);
            if (project == null) {
                return false;
            }
            Project project2 = project;
            if (anchor == null) {
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(targetFile, project2){
                    final /* synthetic */ VirtualFile $targetFile$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$targetFile$inlined = virtualFile;
                        this.$project$inlined = project;
                    }

                    public final void run() {
                        boolean bl = false;
                        OpenFileAction.openFile((VirtualFile)this.$targetFile$inlined, (Project)this.$project$inlined);
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
                return true;
            }
            RelativePoint relativePoint = this.obtainHeadersPopupPosition(project2);
            if (relativePoint == null) {
                return false;
            }
            RelativePoint point = relativePoint;
            boolean $i$f$runReadAction = false;
            Collection headers = (Collection)ApplicationManager.getApplication().runReadAction(new Computable(project2, anchor, targetFile){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $anchor$inlined;
                final /* synthetic */ VirtualFile $targetFile$inlined;
                {
                    this.$project$inlined = project;
                    this.$anchor$inlined = string;
                    this.$targetFile$inlined = virtualFile;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)MarkdownAnchorReference.Companion.getPsiHeaders(this.$project$inlined, this.$anchor$inlined, PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$targetFile$inlined));
                }
            });
            ModalityState modalityState$iv = null;
            boolean $i$f$invokeLater = false;
            Application application = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(headers, project2, anchor, point, targetFile){
                final /* synthetic */ Collection $headers$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $anchor$inlined;
                final /* synthetic */ RelativePoint $point$inlined;
                final /* synthetic */ VirtualFile $targetFile$inlined;
                {
                    this.$headers$inlined = collection;
                    this.$project$inlined = project;
                    this.$anchor$inlined = string;
                    this.$point$inlined = relativePoint;
                    this.$targetFile$inlined = virtualFile;
                }

                public final void run() {
                    boolean bl = false;
                    if (this.$headers$inlined.isEmpty()) {
                        org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$showCannotNavigateNotification(MarkdownLinkOpenerImpl.Companion, this.$project$inlined, this.$anchor$inlined, this.$point$inlined);
                    } else if (this.$headers$inlined.size() == 1) {
                        org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$navigateToHeader(MarkdownLinkOpenerImpl.Companion, this.$targetFile$inlined, (PsiElement)CollectionsKt.first((Iterable)this.$headers$inlined));
                    } else {
                        org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$showHeadersPopup(MarkdownLinkOpenerImpl.Companion, this.$headers$inlined, this.$point$inlined);
                    }
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application.invokeLater(runnable, modalityState);
            return true;
        }

        private final RelativePoint obtainHeadersPopupPosition(Project project) {
            JFrame frame = WindowManager.getInstance().getFrame(project);
            Serializable serializable = frame;
            if (serializable == null || (serializable = serializable.getMousePosition()) == null) {
                return null;
            }
            Serializable mousePosition = serializable;
            return new RelativePoint((Component)frame, (Point)mousePosition);
        }

        private final void showCannotNavigateNotification(Project project, String anchor, RelativePoint point) {
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(MarkdownBundle.message("markdown.navigate.to.header.no.headers", anchor), MessageType.WARNING, null);
            Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"JBPopupFactory.getInstan\u2026ING,\n        null\n      )");
            BalloonBuilder balloonBuilder2 = balloonBuilder;
            Balloon balloon = balloonBuilder2.createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"balloonBuilder.createBalloon()");
            Balloon balloon2 = balloon;
            Disposer.register((Disposable)MarkdownDisposable.Companion.getInstance(project), (Disposable)((Disposable)balloon2));
            balloon2.show(point, Balloon.Position.below);
        }

        private final void showHeadersPopup(Collection<? extends PsiElement> headers, RelativePoint point) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new HeadersPopup(CollectionsKt.toList((Iterable)headers))).show(point);
        }

        private final void navigateToHeader(VirtualFile targetFile, PsiElement item) {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)item.getProject());
            FileEditor fileEditor = editorManager.getSelectedEditor(targetFile);
            if (!(fileEditor instanceof MarkdownEditorWithPreview)) {
                fileEditor = null;
            }
            MarkdownEditorWithPreview markdownEditorWithPreview = (MarkdownEditorWithPreview)fileEditor;
            if (markdownEditorWithPreview == null) {
                return;
            }
            MarkdownEditorWithPreview editor2 = markdownEditorWithPreview;
            boolean oldAutoScrollPreview = editor2.isAutoScrollPreview();
            if (!oldAutoScrollPreview) {
                editor2.setAutoScrollPreview(true);
            }
            PsiNavigateUtil.navigate((PsiElement)item);
            if (!oldAutoScrollPreview) {
                editor2.setAutoScrollPreview(false);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$navigateToHeader(Companion $this, VirtualFile targetFile, PsiElement item) {
            $this.navigateToHeader(targetFile, item);
        }

        public static final /* synthetic */ boolean access$actuallyOpenInEditor(Companion $this, URI uri) {
            return $this.actuallyOpenInEditor(uri);
        }

        public static final /* synthetic */ void access$showCannotNavigateNotification(Companion $this, Project project, String anchor, RelativePoint point) {
            $this.showCannotNavigateNotification(project, anchor, point);
        }

        public static final /* synthetic */ void access$showHeadersPopup(Companion $this, Collection headers, RelativePoint point) {
            $this.showHeadersPopup(headers, point);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl$Companion$HeadersPopup;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/psi/PsiElement;", "headers", "", "(Ljava/util/List;)V", "getTextFor", "", "value", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "", "intellij.markdown.core"})
        private static final class HeadersPopup
        extends BaseListPopupStep<PsiElement> {
            @NotNull
            public String getTextFor(@NotNull PsiElement value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                PsiFile psiFile = value.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"value.containingFile");
                Document document = fileDocumentManager.getDocument(psiFile.getVirtualFile());
                if (document == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                PsiFile psiFile2 = value.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"value.containingFile");
                VirtualFile virtualFile = psiFile2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"value.containingFile.virtualFile");
                String string = virtualFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.containingFile.virtualFile.name");
                String name = string;
                int line = document.getLineNumber(value.getTextOffset()) + 1;
                return value.getText() + " (" + name + ":" + line + ")";
            }

            @NotNull
            public PopupStep<?> onChosen(@NotNull PsiElement selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                PopupStep popupStep = this.doFinalStep(new Runnable(selectedValue){
                    final /* synthetic */ PsiElement $selectedValue;

                    public final void run() {
                        PsiFile psiFile = this.$selectedValue.getContainingFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"selectedValue.containingFile");
                        VirtualFile virtualFile = psiFile.getVirtualFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"selectedValue.containingFile.virtualFile");
                        org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$navigateToHeader(MarkdownLinkOpenerImpl.Companion, virtualFile, this.$selectedValue);
                    }
                    {
                        this.$selectedValue = psiElement;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)popupStep, (String)"doFinalStep {\n          \u2026 selectedValue)\n        }");
                return popupStep;
            }

            public HeadersPopup(@NotNull List<? extends PsiElement> headers) {
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                super(MarkdownBundle.message("markdown.navigate.to.header", new Object[0]), headers);
            }
        }
    }
}

