/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.util.NlsSafe;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.SkippedResult;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public final class GradleProgressEventConverter {
    static EventId getEventId(@NotNull ProgressEvent event, @NotNull String operationId) {
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(0);
        }
        if (operationId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(1);
        }
        OperationDescriptor descriptor = event.getDescriptor();
        String eventId = operationId + descriptor.getDisplayName();
        String parentEventId = descriptor.getParent() == null ? null : operationId + descriptor.getParent().getDisplayName();
        return new EventId(eventId, parentEventId);
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(@NotNull ExternalSystemTaskId id, @NotNull ProgressEvent event, @NotNull String operationId) {
        if (id == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(2);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(3);
        }
        if (operationId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(4);
        }
        return GradleProgressEventConverter.convert(id, event, GradleProgressEventConverter.getEventId(event, operationId));
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(@NotNull ExternalSystemTaskId id, @NotNull ProgressEvent event, @NotNull EventId eventId) {
        if (id == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(5);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(6);
        }
        if (eventId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(7);
        }
        @NlsSafe String description = event.getDescriptor().getName();
        if (event instanceof StartEvent) {
            return new ExternalSystemBuildEvent(id, (BuildEvent)new StartEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description));
        }
        if (event instanceof StatusEvent) {
            StatusEvent statusEvent = (StatusEvent)event;
            return new ExternalSystemBuildEvent(id, (BuildEvent)new ProgressBuildEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description, statusEvent.getTotal(), statusEvent.getProgress(), statusEvent.getUnit()));
        }
        if (event instanceof FinishEvent) {
            return new ExternalSystemBuildEvent(id, (BuildEvent)new FinishEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description, GradleProgressEventConverter.convert(((FinishEvent)event).getResult())));
        }
        if (event instanceof TaskProgressEvent) {
            return new ExternalSystemBuildEvent(id, (BuildEvent)new ProgressBuildEventImpl(eventId.id, eventId.parentId, event.getEventTime(), description, -1L, -1L, ""));
        }
        return new ExternalSystemTaskNotificationEvent(id, description);
    }

    @NotNull
    public static ExternalSystemTaskNotificationEvent convert(ExternalSystemTaskId id, ProgressEvent event) {
        return GradleProgressEventConverter.convert(id, event, "");
    }

    @NotNull
    private static EventResult convert(OperationResult operationResult) {
        if (operationResult instanceof FailureResult) {
            return new FailureResultImpl(null, null);
        }
        if (operationResult instanceof SkippedResult) {
            return new SkippedResultImpl();
        }
        boolean isUpToDate = operationResult instanceof TaskSuccessResult && ((TaskSuccessResult)operationResult).isUpToDate();
        return new SuccessResultImpl(isUpToDate);
    }

    @Nullable
    static ExternalSystemTaskNotificationEvent createProgressBuildEvent(@NotNull ExternalSystemTaskId taskId, @NotNull Object id, @NotNull ProgressEvent event) {
        if (taskId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(8);
        }
        if (id == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(9);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(10);
        }
        long total = -1L;
        long progress = -1L;
        String unit = "";
        @NlsSafe String operationName = event.getDescriptor().getName();
        if (operationName.startsWith("Download ")) {
            String path = operationName.substring("Download ".length());
            operationName = GradleBundle.message("progress.title.download", GradleProgressEventConverter.getFileName(path));
        } else if (event instanceof TaskProgressEvent) {
            operationName = GradleBundle.message("progress.title.run.tasks", new Object[0]);
        } else if (event instanceof TestProgressEvent) {
            operationName = GradleBundle.message("progress.title.run.tests", new Object[0]);
        } else if (event.getDisplayName().startsWith("Configure project ") || event.getDisplayName().startsWith("Cross-configure project ")) {
            operationName = GradleBundle.message("progress.title.configure.projects", new Object[0]);
        } else {
            return null;
        }
        if (event instanceof StatusEvent) {
            total = ((StatusEvent)event).getTotal();
            progress = ((StatusEvent)event).getProgress();
            unit = ((StatusEvent)event).getUnit();
        }
        return new ExternalSystemBuildEvent(taskId, (BuildEvent)new ProgressBuildEventImpl(id, null, event.getEventTime(), operationName + "...", total, progress, unit));
    }

    @Nullable
    static ExternalSystemTaskNotificationEvent legacyCreateProgressBuildEvent(@NotNull ExternalSystemTaskId taskId, @NotNull Object id, @NotNull String event) {
        if (taskId == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(11);
        }
        if (id == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(12);
        }
        if (event == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(13);
        }
        long total = -1L;
        long progress = -1L;
        String unit = "";
        String operationName = event;
        if (operationName.startsWith("Download ")) {
            String path = operationName.substring("Download ".length());
            operationName = GradleBundle.message("progress.title.download", GradleProgressEventConverter.getFileName(path));
        } else if (operationName.startsWith("Task: ")) {
            operationName = GradleBundle.message("progress.title.run.tasks", new Object[0]);
        } else if (operationName.equals("Build")) {
            operationName = GradleBundle.message("progress.title.build", new Object[0]);
        } else if (operationName.startsWith("Build model ") || operationName.startsWith("Build parameterized model")) {
            operationName = GradleBundle.message("progress.title.build.model", new Object[0]);
        } else if (operationName.startsWith("Configure project ") || operationName.startsWith("Cross-configure project ")) {
            operationName = GradleBundle.message("progress.title.configure.projects", new Object[0]);
        } else {
            return null;
        }
        return new ExternalSystemBuildEvent(taskId, (BuildEvent)new ProgressBuildEventImpl(id, null, 0L, operationName + "...", total, progress, unit));
    }

    @NotNull
    private static String getFileName(String path) {
        String fileName;
        int index = path.lastIndexOf(47);
        if (index > 0 && index < path.length() && !(fileName = path.substring(index + 1)).isEmpty()) {
            String string2 = fileName;
            if (string2 == null) {
                GradleProgressEventConverter.$$$reportNull$$$0(14);
            }
            return string2;
        }
        String string3 = path;
        if (string3 == null) {
            GradleProgressEventConverter.$$$reportNull$$$0(15);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationId";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressEventConverter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEventId";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createProgressBuildEvent";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "legacyCreateProgressBuildEvent";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class EventId {
        Object id;
        Object parentId;

        EventId(Object id, Object parentId) {
            this.id = id;
            this.parentId = parentId;
        }
    }
}

