/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tracing.ide;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.tracing.ide.TracingPersistentStateComponent;
import com.intellij.tracing.ide.TracingService$Companion$WhenMappings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/tracing/ide/TracingService;", "", "()V", "jpsTrace", "Ljava/nio/file/Path;", "lock", "traces", "Ljava/util/ArrayList;", "bindJpsTraceIfExistsToCurrentSession", "", "clearPathsToMerge", "drainFilesToMerge", "", "isTracingEnabled", "", "registerIdeTrace", "filePath", "registerJpsTrace", "setTracingEnabled", "enabled", "Companion", "TraceKind", "intellij.platform.tracing.ide"})
public final class TracingService {
    private final Object lock = new Object();
    private ArrayList<Path> traces = new ArrayList();
    private Path jpsTrace;
    private static final String COMMON_TRACING_DIR_NAME = "tracing";
    private static final String IDE_TRACE_DIR_NAME = "ide";
    private static final String JPS_TRACE_DIR_NAME = "jps";
    private static final String MERGED_TRACE_DIR_NAME = "merged";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isTracingEnabled() {
        boolean bl;
        Object object;
        Object object2 = object = this.lock;
        synchronized (object2) {
            boolean bl2 = false;
            bl = ((TracingPersistentStateComponent.State)TracingPersistentStateComponent.Companion.getInstance().getState()).isEnabled();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTracingEnabled(boolean enabled) {
        Object object;
        Object object2 = object = this.lock;
        synchronized (object2) {
            boolean bl = false;
            ((TracingPersistentStateComponent.State)TracingPersistentStateComponent.Companion.getInstance().getState()).setEnabled(enabled);
            if (!enabled) {
                this.traces.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerIdeTrace(@NotNull Path filePath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Object object2 = object = this.lock;
        synchronized (object2) {
            boolean bl = false;
            boolean bl2 = this.traces.add(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerJpsTrace(@NotNull Path filePath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Object object2 = object = this.lock;
        synchronized (object2) {
            boolean bl = false;
            this.bindJpsTraceIfExistsToCurrentSession();
            this.jpsTrace = filePath;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bindJpsTraceIfExistsToCurrentSession() {
        Object object;
        Object object2 = object = this.lock;
        synchronized (object2) {
            boolean bl = false;
            Path jpsTrace = this.jpsTrace;
            if (jpsTrace != null) {
                this.traces.add(jpsTrace);
                this.jpsTrace = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Path> drainFilesToMerge() {
        Object object;
        Object object2 = object = this.lock;
        synchronized (object2) {
            boolean bl = false;
            ArrayList<Path> tracesToMerge = this.traces;
            this.traces = new ArrayList();
            List list = tracesToMerge;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearPathsToMerge() {
        Object object;
        Object object2 = object = this.lock;
        synchronized (object2) {
            boolean bl = false;
            this.traces.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/tracing/ide/TracingService$TraceKind;", "", "(Ljava/lang/String;I)V", "Jps", "Ide", "Merged", "intellij.platform.tracing.ide"})
    public static final class TraceKind
    extends Enum<TraceKind> {
        public static final /* enum */ TraceKind Jps;
        public static final /* enum */ TraceKind Ide;
        public static final /* enum */ TraceKind Merged;
        private static final /* synthetic */ TraceKind[] $VALUES;

        static {
            TraceKind[] traceKindArray = new TraceKind[3];
            TraceKind[] traceKindArray2 = traceKindArray;
            traceKindArray[0] = Jps = new TraceKind();
            traceKindArray[1] = Ide = new TraceKind();
            traceKindArray[2] = Merged = new TraceKind();
            $VALUES = traceKindArray;
        }

        public static TraceKind[] values() {
            return (TraceKind[])$VALUES.clone();
        }

        public static TraceKind valueOf(String string) {
            return Enum.valueOf(TraceKind.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/tracing/ide/TracingService$Companion;", "", "()V", "COMMON_TRACING_DIR_NAME", "", "IDE_TRACE_DIR_NAME", "JPS_TRACE_DIR_NAME", "MERGED_TRACE_DIR_NAME", "createPath", "Ljava/nio/file/Path;", "kind", "Lcom/intellij/tracing/ide/TracingService$TraceKind;", "getInstance", "Lcom/intellij/tracing/ide/TracingService;", "getNewTraceFileName", "getTracesDirPath", "intellij.platform.tracing.ide"})
    public static final class Companion {
        @NotNull
        public final TracingService getInstance() {
            Object object = ApplicationManager.getApplication().getService(TracingService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026acingService::class.java)");
            return (TracingService)object;
        }

        @NotNull
        public final Path createPath(@NotNull TraceKind kind) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Path tracesDirPath = this.getTracesDirPath();
            switch (TracingService$Companion$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    string = TracingService.JPS_TRACE_DIR_NAME;
                    break;
                }
                case 2: {
                    string = TracingService.IDE_TRACE_DIR_NAME;
                    break;
                }
                case 3: {
                    string = TracingService.MERGED_TRACE_DIR_NAME;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String subDir = string;
            Path path = tracesDirPath.resolve(subDir).resolve(this.getNewTraceFileName());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tracesDirPath.resolve(su\u2026ve(getNewTraceFileName())");
            return path;
        }

        private final String getNewTraceFileName() {
            return "trace_" + LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + ".json";
        }

        private final Path getTracesDirPath() {
            Path path = Paths.get(PathManager.getHomePath(), new String[0]).resolve(TracingService.COMMON_TRACING_DIR_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.ge\u2026(COMMON_TRACING_DIR_NAME)");
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

