/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlDebugUtil;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.ModelAccess;
import org.jetbrains.yaml.meta.model.YamlArrayType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public class YamlMetaTypeProvider {
    private static final Logger LOG = Logger.getInstance(YamlMetaTypeProvider.class);
    private final Key<CachedValue<MetaTypeProxy>> myKey;
    @NotNull
    private final ModelAccess myMetaModel;
    @NotNull
    private final ModificationTracker myModificationTracker;

    public YamlMetaTypeProvider(@NotNull ModelAccess metaModel, @NotNull ModificationTracker modificationTracker) {
        if (metaModel == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(0);
        }
        if (modificationTracker == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(1);
        }
        this.myMetaModel = metaModel;
        this.myKey = Key.create((String)(metaModel.getClass().getName() + ":KEY"));
        this.myModificationTracker = modificationTracker;
    }

    @Nullable
    public MetaTypeProxy getMetaTypeProxy(@NotNull PsiElement psi) {
        if (psi == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(2);
        }
        if (psi instanceof YAMLValue) {
            return this.getValueMetaType((YAMLValue)psi);
        }
        YAMLValue metaOwner = this.getMetaOwner(psi);
        return metaOwner == null ? null : this.getValueMetaType(metaOwner);
    }

    @Nullable
    public YAMLValue getMetaOwner(@NotNull PsiElement psi) {
        PsiFile file;
        if (psi == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(3);
        }
        if (!((file = psi.getContainingFile()) instanceof YAMLFile)) {
            return null;
        }
        return YamlMetaTypeProvider.getTypedAncestorOrSelf(psi, YAMLValue.class);
    }

    @Nullable
    public MetaTypeProxy getKeyValueMetaType(@NotNull YAMLKeyValue keyValue) {
        if (keyValue == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(4);
        }
        if (keyValue.getValue() != null) {
            return this.getMetaTypeProxy((PsiElement)keyValue.getValue());
        }
        Field type = this.computeMetaType(keyValue);
        return FieldAndRelation.forNullable(type, Field.Relation.OBJECT_CONTENTS);
    }

    @Nullable
    public MetaTypeProxy getValueMetaType(@NotNull YAMLValue typedValue) {
        if (typedValue == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(5);
        }
        return (MetaTypeProxy)CachedValuesManager.getCachedValue((PsiElement)typedValue, this.myKey, () -> {
            YamlMetaTypeProvider.debug(() -> " >> computing type for : " + YamlDebugUtil.getDebugInfo((PsiElement)typedValue));
            MetaTypeProxy computed = this.computeMetaType(typedValue);
            YamlMetaTypeProvider.debug(() -> " << finished for : " + YamlDebugUtil.getDebugInfo((PsiElement)typedValue) + ", result: " + (computed == null ? "<null>" : computed));
            return new CachedValueProvider.Result((Object)computed, new Object[]{typedValue.getContainingFile(), this.myModificationTracker});
        });
    }

    @Nullable
    private MetaTypeProxy computeMetaType(@NotNull YAMLValue value) {
        PsiElement typed;
        if (value == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(6);
        }
        if ((typed = PsiTreeUtil.getParentOfType((PsiElement)value, (Class[])new Class[]{YAMLKeyValue.class, YAMLSequenceItem.class, YAMLDocument.class})) instanceof YAMLDocument) {
            Field root = this.myMetaModel.getRoot((YAMLDocument)typed);
            return FieldAndRelation.forNullable(root, Field.Relation.OBJECT_CONTENTS);
        }
        if (typed instanceof YAMLSequenceItem) {
            YAMLSequenceItem sequenceItem = (YAMLSequenceItem)typed;
            YAMLSequence sequence = (YAMLSequence)ObjectUtils.tryCast((Object)sequenceItem.getParent(), YAMLSequence.class);
            if (sequence == null) {
                YamlMetaTypeProvider.debug(() -> "Unexpected: sequenceItem parent is not a sequence: " + sequenceItem.getParent());
                return null;
            }
            MetaTypeProxy sequenceMeta = this.getMetaTypeProxy((PsiElement)sequence);
            if (sequenceMeta != null) {
                YamlMetaType sequenceMetaType = sequenceMeta.getMetaType();
                Field resultField = value instanceof YAMLSequence && sequenceMetaType instanceof YamlArrayType ? new Field("<array>", sequenceMetaType) : sequenceMeta.getField();
                return FieldAndRelation.forNullable(YamlMetaTypeProvider.specializeField(resultField, sequenceItem.getValue()), Field.Relation.SEQUENCE_ITEM);
            }
            return null;
        }
        if (typed instanceof YAMLKeyValue) {
            YAMLKeyValue keyValue = (YAMLKeyValue)typed;
            Field keyValueType = this.computeMetaType(keyValue);
            if (keyValueType == null) {
                return null;
            }
            Field.Relation relation = Field.Relation.OBJECT_CONTENTS;
            if (value instanceof YAMLScalar) {
                relation = YamlMetaTypeProvider.computeScalarValueRelation(keyValue, (YAMLScalar)value);
            } else if (value instanceof YAMLSequence) {
                relation = Field.Relation.SEQUENCE_ITEM;
            }
            return FieldAndRelation.forNullable(keyValueType, relation);
        }
        return null;
    }

    private static Field.Relation computeScalarValueRelation(@NotNull YAMLKeyValue keyValue, @NotNull YAMLScalar value) {
        YAMLScalar keySibling;
        if (keyValue == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(7);
        }
        if (value == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(8);
        }
        YAMLScalar yAMLScalar = keySibling = value.getParent() instanceof YAMLMapping ? value.getParent() : value;
        if (YamlMetaTypeProvider.hasLineBreakBetweenKeyAndValue(keyValue, (PsiElement)keySibling)) {
            return Field.Relation.OBJECT_CONTENTS;
        }
        return Field.Relation.SCALAR_VALUE;
    }

    @Nullable
    private Field computeMetaType(@NotNull YAMLKeyValue keyValue) {
        YAMLMapping parentMapping;
        if (keyValue == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(9);
        }
        if ((parentMapping = keyValue.getParentMapping()) == null) {
            YamlMetaTypeProvider.debug(() -> "Unexpected: keyValue parent is not a mapping: " + keyValue.getParent());
            return null;
        }
        MetaTypeProxy parentMeta = this.getMetaTypeProxy((PsiElement)parentMapping);
        Field childMeta = YamlMetaTypeProvider.findChildMeta(parentMeta, keyValue);
        return childMeta != null ? YamlMetaTypeProvider.specializeField(childMeta, keyValue.getValue()) : null;
    }

    @NotNull
    private static Field specializeField(@NotNull Field field, @Nullable YAMLValue value) {
        if (field == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(10);
        }
        Field field2 = value != null ? field.resolveToSpecializedField(value) : field;
        if (field2 == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(11);
        }
        return field2;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static Field findChildMeta(@Nullable MetaTypeProxy parentMeta, @NotNull YAMLKeyValue child) {
        if (child == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(12);
        }
        if (parentMeta == null) {
            return null;
        }
        String tag = child.getKeyText().trim();
        return parentMeta.getMetaType().findFeatureByName(tag);
    }

    @Nullable
    private static <T extends PsiElement> T getTypedAncestorOrSelf(@NotNull PsiElement psi, @NotNull Class<? extends T> clazz) {
        if (psi == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(13);
        }
        if (clazz == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(14);
        }
        return (T)(clazz.isInstance(psi) ? (PsiElement)clazz.cast(psi) : PsiTreeUtil.getParentOfType((PsiElement)psi, clazz));
    }

    private static void debug(Supplier<String> textSupplier) {
        if (LOG.isDebugEnabled()) {
            String text = textSupplier.get();
            LOG.debug(text);
        }
    }

    private static boolean hasLineBreakBetweenKeyAndValue(@NotNull YAMLKeyValue keyValue, @NotNull PsiElement keySibling) {
        if (keyValue == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(15);
        }
        if (keySibling == null) {
            YamlMetaTypeProvider.$$$reportNull$$$0(16);
        }
        if (keySibling.getParent() != keyValue) {
            return false;
        }
        PsiElement key = keyValue.getKey();
        for (PsiElement prev = keySibling.getPrevSibling(); prev != null && prev != key; prev = prev.getPrevSibling()) {
            if (prev.getNode().getElementType() != YAMLTokenTypes.EOL) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationTracker";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedValue";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keySibling";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "specializeField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMetaTypeProxy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMetaOwner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueMetaType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueMetaType";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeMetaType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeScalarValueRelation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "specializeField";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findChildMeta";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypedAncestorOrSelf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreakBetweenKeyAndValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MetaTypeProxy {
        @NotNull
        public YamlMetaType getMetaType();

        @NotNull
        public Field getField();
    }

    public static class FieldAndRelation
    implements MetaTypeProxy {
        private final Field myField;
        private final Field.Relation myRelation;

        @Nullable
        public static FieldAndRelation forNullable(@Nullable Field field, @NotNull Field.Relation relation) {
            if (relation == null) {
                FieldAndRelation.$$$reportNull$$$0(0);
            }
            return field == null ? null : new FieldAndRelation(field, relation);
        }

        public FieldAndRelation(@NotNull Field field, @NotNull Field.Relation relation) {
            if (field == null) {
                FieldAndRelation.$$$reportNull$$$0(1);
            }
            if (relation == null) {
                FieldAndRelation.$$$reportNull$$$0(2);
            }
            this.myField = field;
            this.myRelation = relation;
        }

        @Override
        @NotNull
        public Field getField() {
            Field field = this.myField;
            if (field == null) {
                FieldAndRelation.$$$reportNull$$$0(3);
            }
            return field;
        }

        @NotNull
        public Field.Relation getRelation() {
            Field.Relation relation = this.myRelation;
            if (relation == null) {
                FieldAndRelation.$$$reportNull$$$0(4);
            }
            return relation;
        }

        public String toString() {
            return "[" + this.getField().getName() + " : " + this.getRelation() + "]";
        }

        @Override
        @NotNull
        public YamlMetaType getMetaType() {
            YamlMetaType yamlMetaType = this.myField.getType(this.myRelation);
            if (yamlMetaType == null) {
                FieldAndRelation.$$$reportNull$$$0(5);
            }
            return yamlMetaType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$FieldAndRelation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$FieldAndRelation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forNullable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

