/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.caches;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.BuiltInWithDifferentJvmName;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethods;
import org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.SpecialBridge;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/caches/BridgeLoweringCache;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "signatureCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "specialBridgeMethods", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "canHaveSpecialBridge", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "computeJvmMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "computeSpecialBridge", "Lorg/jetbrains/kotlin/backend/jvm/SpecialBridge;", "backend.jvm"})
public final class BridgeLoweringCache {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final SpecialBridgeMethods specialBridgeMethods;
    @NotNull
    private final ConcurrentHashMap<IrFunctionSymbol, Method> signatureCache;

    public BridgeLoweringCache(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.specialBridgeMethods = new SpecialBridgeMethods(this.context);
        this.signatureCache = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Method computeJvmMethod(@NotNull IrFunction function2) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        ConcurrentMap concurrentMap = this.signatureCache;
        IrFunctionSymbol key$iv = function2.getSymbol();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Method default$iv = this.context.getMethodSignatureMapper().mapAsmMethod(function2);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, "signatureCache.getOrPut(\u2026.mapAsmMethod(function) }");
        return (Method)object;
    }

    private final boolean canHaveSpecialBridge(IrSimpleFunction function2) {
        boolean bl;
        block4: {
            if (this.specialBridgeMethods.getSpecialMethodNames().contains(function2.getName())) {
                return true;
            }
            String string2 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "function.name.asString()");
            String functionName = string2;
            Iterable $this$any$iv = this.specialBridgeMethods.getSpecialMethodNames();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default(functionName, it.asString() + '-', false, 2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SpecialBridge computeSpecialBridge(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        IrPropertySymbol correspondingProperty2 = function2.getCorrespondingPropertySymbol();
        if (correspondingProperty2 != null ? !this.specialBridgeMethods.getSpecialPropertyNames().contains(((IrProperty)correspondingProperty2.getOwner()).getName()) : !this.canHaveSpecialBridge(function2)) {
            return null;
        }
        SpecialMethodWithDefaultInfo specialMethodInfo = this.specialBridgeMethods.getSpecialMethodInfo(function2);
        if (specialMethodInfo != null) {
            return new SpecialBridge(function2, this.computeJvmMethod(function2), specialMethodInfo.getNeedsGenericSignature(), null, null, specialMethodInfo, null, false, false, false, specialMethodInfo.getNeedsUnsubstitutedBridge(), null, 3032, null);
        }
        BuiltInWithDifferentJvmName specialBuiltInInfo = this.specialBridgeMethods.getBuiltInWithDifferentJvmName(function2);
        if (specialBuiltInInfo != null) {
            return new SpecialBridge(function2, this.computeJvmMethod(function2), specialBuiltInInfo.getNeedsGenericSignature(), null, null, null, null, false, false, specialBuiltInInfo.isOverriding(), false, null, 3576, null);
        }
        for (IrSimpleFunctionSymbol overridden : function2.getOverriddenSymbols()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object item$iv$iv2;
            void $this$mapIndexedTo$iv$iv;
            SpecialBridge specialBridge = this.computeSpecialBridge((IrSimpleFunction)overridden.getOwner());
            if (specialBridge == null) continue;
            SpecialBridge specialBridge2 = specialBridge;
            if (!specialBridge2.getNeedsGenericSignature()) {
                return specialBridge2;
            }
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = specialBridge2.getMethodInfo();
            int erasedParameterCount = specialMethodWithDefaultInfo != null ? specialMethodWithDefaultInfo.getArgumentsToCheck() : 0;
            Iterable $this$mapIndexed$iv = function2.getValueParameters();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void param;
                void index2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv2;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(index2 < erasedParameterCount ? this.context.getIrBuiltIns().getAnyNType() : param.getType());
            }
            List substitutedParameterTypes = (List)destination$iv$iv;
            Object $this$buildFun$iv = this.context.getIrFactory();
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
            IrFunctionBuilder $this$computeSpecialBridge_u24lambda_u2d3 = $this$buildFun_u24lambda_u2d16$iv;
            boolean bl = false;
            $this$computeSpecialBridge_u24lambda_u2d3.updateFrom(specialBridge2.getOverridden());
            Name name = Name.identifier(specialBridge2.getSignature().getName());
            Intrinsics.checkNotNullExpressionValue(name, "identifier(specialBridge.signature.name)");
            $this$computeSpecialBridge_u24lambda_u2d3.setName(name);
            $this$computeSpecialBridge_u24lambda_u2d3.setReturnType(function2.getReturnType());
            Object $this$computeSpecialBridge_u24lambda_u2d5 = $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u2d16$iv);
            boolean bl2 = false;
            Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = CollectionsKt.zip((Iterable)function2.getValueParameters(), substitutedParameterTypes);
            Object object = $this$computeSpecialBridge_u24lambda_u2d5;
            boolean $i$f$map = false;
            item$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv3;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                IrValueParameter param = (IrValueParameter)pair.component1();
                IrType type2 = (IrType)pair.component2();
                collection.add(IrUtilsKt.copyTo$default(param, (IrFunction)$this$computeSpecialBridge_u24lambda_u2d5, IrDeclarationOrigin.BRIDGE.INSTANCE, 0, 0, 0, null, null, type2, null, null, false, false, false, 8060, null));
            }
            ((IrFunction)object).setValueParameters((List)destination$iv$iv2);
            $this$computeSpecialBridge_u24lambda_u2d5.setOverriddenSymbols(CollectionsKt.listOf(specialBridge2.getOverridden().getSymbol()));
            $this$computeSpecialBridge_u24lambda_u2d5.setParent(function2.getParent());
            Object substitutedOverride = $this$buildFun$iv;
            Method substitutedOverrideSignature = this.computeJvmMethod((IrFunction)substitutedOverride);
            SpecialBridge unsubstitutedSpecialBridge = specialBridge2.getUnsubstitutedSpecialBridge() != null ? specialBridge2.getUnsubstitutedSpecialBridge() : (specialBridge2.getNeedsUnsubstitutedBridge() && !Intrinsics.areEqual(specialBridge2.getSignature(), substitutedOverrideSignature) ? SpecialBridge.copy$default(specialBridge2, null, null, false, null, null, null, null, false, true, false, false, null, 3839, null) : null);
            return SpecialBridge.copy$default(specialBridge2, null, substitutedOverrideSignature, false, substitutedParameterTypes, function2.getReturnType(), null, null, false, false, false, false, unsubstitutedSpecialBridge, 2021, null);
        }
        return null;
    }
}

