/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.util;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.AwtUtilsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.IntScalingExtensionsKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0014\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/util/HtmlEditorPane;", "Ljavax/swing/JEditorPane;", "()V", "addHyperlinkListener", "", "listener", "Ljavax/swing/event/HyperlinkListener;", "clearBody", "createBodyHtmlChunk", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "onLinkClicked", "anchor", "", "removeHyperlinkListener", "setBody", "chunks", "", "Lcom/intellij/openapi/util/text/HtmlChunk;", "setBodyText", "text", "ProxyingHyperlinkListener", "intellij.packageSearch"})
public class HtmlEditorPane
extends JEditorPane {
    protected final void clearBody() {
        this.setBody(CollectionsKt.emptyList());
    }

    public final void setBody(@NotNull Collection<? extends HtmlChunk> chunks) {
        String string;
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        if (chunks.isEmpty()) {
            string = "";
        } else {
            Collection<? extends HtmlChunk> $this$toTypedArray$iv = chunks;
            boolean $i$f$toTypedArray = false;
            Collection<? extends HtmlChunk> thisCollection$iv = $this$toTypedArray$iv;
            HtmlChunk[] htmlChunkArray = thisCollection$iv.toArray(new HtmlChunk[0]);
            if (htmlChunkArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            string = this.createBodyHtmlChunk().children(Arrays.copyOf(htmlChunkArray, htmlChunkArray.length)).toString();
        }
        this.setText(string);
    }

    public final void setBodyText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setText(this.createBodyHtmlChunk().addText(text).toString());
    }

    private final HtmlChunk.Element createBodyHtmlChunk() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildString.append("color: ");
        Color color = this.getForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground");
        $this$buildString.append(AwtUtilsKt.toCssHexColorString(color));
        $this$buildString.append("; font-size: ");
        Font font = this.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
        $this$buildString.append(font.getSize());
        $this$buildString.append("pt;");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String style = string;
        HtmlChunk.Element element = HtmlChunk.body().style(style);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"HtmlChunk.body().style(style)");
        return element;
    }

    protected void onLinkClicked(@NotNull String anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
    }

    @Override
    public final void addHyperlinkListener(@Nullable HyperlinkListener listener2) {
        super.addHyperlinkListener(listener2);
    }

    @Override
    public final void removeHyperlinkListener(@Nullable HyperlinkListener listener2) {
        super.removeHyperlinkListener(listener2);
    }

    /*
     * WARNING - void declaration
     */
    public HtmlEditorPane() {
        void $this$apply;
        HTMLEditorKit hTMLEditorKit;
        HTMLEditorKit hTMLEditorKit2 = hTMLEditorKit = new HTMLEditorKitBuilder().withWordWrapViewFactory().withGapsBetweenParagraphs().build();
        HtmlEditorPane htmlEditorPane = this;
        boolean bl = false;
        $this$apply.getStyleSheet().addRule(StringsKt.trimMargin$default((String)("\n                      |ul {padding-left: " + IntScalingExtensionsKt.scaled(8) + "px;}\n                      "), null, (int)1, null));
        StyleSheet styleSheet = $this$apply.getStyleSheet();
        Color color = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.Link.Foreground.ENABLED");
        String string = AwtUtilsKt.toCssHexColorString(color);
        Color color2 = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"JBUI.CurrentTheme.Link.Foreground.ENABLED");
        String string2 = AwtUtilsKt.toCssHexColorString(color2);
        Color color3 = JBUI.CurrentTheme.Link.Foreground.VISITED;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"JBUI.CurrentTheme.Link.Foreground.VISITED");
        String string3 = AwtUtilsKt.toCssHexColorString(color3);
        Color color4 = JBUI.CurrentTheme.Link.Foreground.PRESSED;
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"JBUI.CurrentTheme.Link.Foreground.PRESSED");
        String string4 = AwtUtilsKt.toCssHexColorString(color4);
        Color color5 = JBUI.CurrentTheme.Link.Foreground.HOVERED;
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"JBUI.CurrentTheme.Link.Foreground.HOVERED");
        styleSheet.addRule(StringsKt.trimMargin$default((String)("\n                          |a{color: " + string + ";}\n                          |a:link{color: " + string2 + ";}\n                          |a:visited{color: " + string3 + ";}\n                          |a:active{color: " + string4 + ";}\n                          |a:hover{color: " + AwtUtilsKt.toCssHexColorString(color5) + ";}\n                      "), null, (int)1, null));
        Unit unit = Unit.INSTANCE;
        htmlEditorPane.setEditorKit(hTMLEditorKit);
        this.setHighlighter(null);
        this.setEditable(false);
        this.setOpaque(false);
        this.addHyperlinkListener((HyperlinkListener)((Object)new ProxyingHyperlinkListener((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){

            public final void invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((HtmlEditorPane)this.receiver).onLinkClicked(p1);
            }
        }))));
        this.setMargin((Insets)JBInsets.emptyInsets());
        GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAAHintForSwingComponent());
        Caret caret = this.getCaret();
        if (caret == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.text.DefaultCaret");
        }
        DefaultCaret caret2 = (DefaultCaret)caret;
        caret2.setUpdatePolicy(1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B(\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0014R)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/util/HtmlEditorPane$ProxyingHyperlinkListener;", "Lcom/intellij/ui/HyperlinkAdapter;", "callback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "anchor", "", "(Lkotlin/jvm/functions/Function1;)V", "hyperlinkActivated", "e", "Ljavax/swing/event/HyperlinkEvent;", "intellij.packageSearch"})
    private static final class ProxyingHyperlinkListener
    extends HyperlinkAdapter {
        private final Function1<String, Unit> callback;

        protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string = e.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.description");
            this.callback.invoke((Object)string);
        }

        public ProxyingHyperlinkListener(@NotNull Function1<? super String, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.callback = callback;
        }
    }
}

